/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.ui.console;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import tigase.util.ui.console.CommandlineParameter;

public class Task {
    private final Optional<Supplier<List<CommandlineParameter>>> additionalParameterSupplier;
    private final Optional<String> description;
    private final String name;
    private Executor<Properties> function;

    private Task(Builder builder) {
        this.name = builder.name;
        this.function = builder.function;
        this.description = Optional.ofNullable(builder.description);
        this.additionalParameterSupplier = Optional.ofNullable(builder.additionalParameterSupplier);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public List<CommandlineParameter> getAdditionalParameters() {
        if (this.additionalParameterSupplier.isPresent()) {
            return this.additionalParameterSupplier.get().get();
        }
        return Collections.emptyList();
    }

    public void execute(Properties props) throws Exception {
        this.function.execute(props);
    }

    public static class Builder {
        private Supplier<List<CommandlineParameter>> additionalParameterSupplier;
        private String description;
        private Executor<Properties> function;
        private String name;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder function(Executor<Properties> function) {
            this.function = function;
            return this;
        }

        public Builder additionalParameterSupplier(Supplier<List<CommandlineParameter>> supplier) {
            this.additionalParameterSupplier = supplier;
            return this;
        }

        public Task build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalStateException("Name of a task is REQUIRED!");
            }
            if (this.function == null) {
                throw new IllegalStateException("Function of a task is REQUIRED");
            }
            return new Task(this);
        }
    }

    public static interface Executor<T> {
        public void execute(T var1) throws Exception;
    }
}

