/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;

public abstract class VCardXMPPProcessorAbstract
extends XMPPProcessorAbstract
implements Initializable,
UnregisterAware {
    private static final Pattern DATA_URI_PATTERN = Pattern.compile("data:(.+);base64,(.+)");
    private static final Pattern TEL_URI_PATTERN = Pattern.compile("tel:(.+)");
    private static final Pattern XMPP_URI_PATTERN = Pattern.compile("xmpp:(.+)");
    private static final Pattern GEO_URI_PATTERN = Pattern.compile("geo:([\\-0-9\\.]+),([\\-0-9\\.]+)");
    private static Map<String, Converter> CONVERTERS = new ConcurrentHashMap<String, Converter>();
    private static Map<String, VCardXMPPProcessorAbstract> PROCESSORS = new ConcurrentHashMap<String, VCardXMPPProcessorAbstract>();

    public static Element convertVCard4ToVCardTemp(Element vcard4) {
        return CONVERTERS.get("urn:ietf:params:xml:ns:vcard-4.0|vcard-temp").convert(vcard4);
    }

    public static Element convertVCardTempToVCard4(Element vcardTemp) {
        return CONVERTERS.get("vcard-temp|urn:ietf:params:xml:ns:vcard-4.0").convert(vcardTemp);
    }

    @Override
    public void beforeUnregister() {
        PROCESSORS.remove(this.id(), this);
    }

    protected abstract String getVCardXMLNS();

    @Override
    public void initialize() {
        PROCESSORS.put(this.id(), this);
    }

    protected void setVCard(XMPPResourceConnection session, Element vcard) throws TigaseDBException, NotAuthorizedException {
        for (VCardXMPPProcessorAbstract processor : PROCESSORS.values()) {
            Converter conv = CONVERTERS.get(this.getVCardXMLNS() + "|" + processor.getVCardXMLNS());
            Element vcardEl = conv == null ? vcard : conv.convert(vcard);
            processor.storeVCard(session, vcardEl);
        }
    }

    protected abstract void storeVCard(XMPPResourceConnection var1, Element var2) throws TigaseDBException, NotAuthorizedException;

    static {
        CONVERTERS.put("vcard-temp|urn:ietf:params:xml:ns:vcard-4.0", vcardTemp -> {
            if (vcardTemp == null) {
                return null;
            }
            Element vcard4 = new Element("vcard", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:vcard-4.0"});
            vcardTemp.forEachChild(c -> {
                Element r = null;
                List list = null;
                Element parameters = null;
                Element type = null;
                switch (c.getName()) {
                    case "FN": 
                    case "NICKNAME": 
                    case "TZ": 
                    case "TITLE": 
                    case "ROLE": 
                    case "CATEGORIES": 
                    case "NOTE": 
                    case "PRODID": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("text", c.getCData()));
                        break;
                    }
                    case "N": {
                        r = new Element("n");
                        list = c.mapChildren(c1 -> {
                            switch (c1.getName()) {
                                case "GIVEN": {
                                    return new Element("given", c1.getCData());
                                }
                                case "FAMILY": {
                                    return new Element("surname", c1.getCData());
                                }
                                case "MIDDLE": {
                                    return new Element("additional", c1.getCData());
                                }
                                case "PREFIX": {
                                    return new Element("prefix", c1.getCData());
                                }
                                case "SUFFIX": {
                                    return new Element("suffix", c1.getCData());
                                }
                            }
                            return null;
                        });
                        if (list == null) break;
                        list.removeIf(c1 -> c1 == null);
                        r.addChildren(list);
                        break;
                    }
                    case "PHOTO": 
                    case "LOGO": {
                        r = new Element(c.getName().toLowerCase());
                        Element extVal = c.findChild(c1 -> c1.getName() == "EXTVAL");
                        if (extVal != null) {
                            r.addChild((XMLNodeIfc)new Element("uri", extVal.getCData()));
                            break;
                        }
                        String binval = c.getChildCData(c1 -> c1.getName() == "BINVAL");
                        String tp = c.getChildCData(c1 -> c1.getName() == "TYPE");
                        if (binval == null || tp == null) break;
                        r.addChild((XMLNodeIfc)new Element("uri", "data:" + tp + ";base64," + binval.replace("\n", "").replace("\r", "")));
                        break;
                    }
                    case "BDAY": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("date", c.getCData()));
                        break;
                    }
                    case "ADR": {
                        r = new Element("adr");
                        for (Element c12 : c.getChildren()) {
                            switch (c12.getName()) {
                                case "POBOX": 
                                case "STREET": 
                                case "LOCALITY": 
                                case "REGION": {
                                    r.addChild((XMLNodeIfc)new Element(c12.getName().toLowerCase(), c12.getCData()));
                                    break;
                                }
                                case "EXTADD": {
                                    r.addChild((XMLNodeIfc)new Element("ext", c12.getCData()));
                                    break;
                                }
                                case "PCODE": {
                                    r.addChild((XMLNodeIfc)new Element("code", c12.getCData()));
                                    break;
                                }
                                case "CTRY": {
                                    r.addChild((XMLNodeIfc)new Element("country", c12.getCData()));
                                    break;
                                }
                                case "HOME": 
                                case "WORK": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    if (type == null) {
                                        type = new Element("type");
                                        parameters.addChild((XMLNodeIfc)type);
                                    }
                                    type.addChild((XMLNodeIfc)new Element("text", c12.getName().toLowerCase()));
                                    break;
                                }
                                case "PREF": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    Element pref = new Element("pref");
                                    pref.addChild((XMLNodeIfc)new Element("integer", "1"));
                                    parameters.addChild((XMLNodeIfc)pref);
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case "TEL": {
                        r = new Element("tel");
                        for (Element c13 : c.getChildren()) {
                            switch (c13.getName()) {
                                case "HOME": 
                                case "WORK": 
                                case "TEXT": 
                                case "FAX": 
                                case "CELL": 
                                case "VOICE": 
                                case "VIDEO": 
                                case "PAGER": 
                                case "TEXTPHONE": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    if (type == null) {
                                        type = new Element("type");
                                        parameters.addChild((XMLNodeIfc)type);
                                    }
                                    type.addChild((XMLNodeIfc)new Element("text", c13.getName().toLowerCase()));
                                    break;
                                }
                                case "PREF": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    Element pref = new Element("pref");
                                    pref.addChild((XMLNodeIfc)new Element("integer", "1"));
                                    parameters.addChild((XMLNodeIfc)pref);
                                    break;
                                }
                                case "NUMBER": {
                                    Element uri = new Element("uri", "tel:" + c13.getCData());
                                    r.addChild((XMLNodeIfc)uri);
                                }
                            }
                        }
                        break;
                    }
                    case "EMAIL": {
                        r = new Element("email");
                        for (Element c14 : c.getChildren()) {
                            switch (c14.getName()) {
                                case "HOME": 
                                case "WORK": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    if (type == null) {
                                        type = new Element("type");
                                        parameters.addChild((XMLNodeIfc)type);
                                    }
                                    type.addChild((XMLNodeIfc)new Element("text", c14.getName().toLowerCase()));
                                    break;
                                }
                                case "PREF": {
                                    if (parameters == null) {
                                        parameters = new Element("parameters");
                                        r.addChild((XMLNodeIfc)parameters);
                                    }
                                    Element pref = new Element("pref");
                                    pref.addChild((XMLNodeIfc)new Element("integer", "1"));
                                    parameters.addChild((XMLNodeIfc)pref);
                                    break;
                                }
                                case "USERID": {
                                    r.addChild((XMLNodeIfc)new Element("text", c14.getCData()));
                                }
                            }
                        }
                        break;
                    }
                    case "JABBERID": {
                        r = new Element("impp");
                        r.addChild((XMLNodeIfc)new Element("uri", "xmpp:" + c.getCData()));
                        break;
                    }
                    case "GEO": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("uri", "geo:" + c.getChildCData(c1 -> c1.getName() == "LAT") + "," + c.getChildCData(c1 -> c1.getName() == "LON")));
                        break;
                    }
                    case "AGENT": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("uri", c.getChildCData(c1 -> c1.getName() == "EXTVAL")));
                        break;
                    }
                    case "ORG": {
                        c = c.findChild(c1 -> c1.getName() == "ORGNAME");
                        if (c == null) break;
                        r = new Element("org");
                        r.addChild((XMLNodeIfc)new Element("text", c.getCData()));
                        break;
                    }
                    case "REV": {
                        r = new Element("rev");
                        r.addChild((XMLNodeIfc)new Element("timestamp", c.getCData()));
                        break;
                    }
                    case "SORT-STRING": {
                        r = new Element("sort-as", c.getCData());
                        break;
                    }
                    case "SOUND": {
                        r = new Element("sound");
                        Element extVal = c.findChildStaticStr(new String[]{"EXTVAL"});
                        if (extVal != null) {
                            r.addChild((XMLNodeIfc)new Element("uri", extVal.getCData()));
                            break;
                        }
                        r.addChild((XMLNodeIfc)new Element("uri", "data:audio/basic;base64," + c.getChildCData(c1 -> c1.getName() == "BINVAL")));
                        break;
                    }
                    case "UID": 
                    case "URL": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("uri", c.getCData()));
                        break;
                    }
                    case "KEY": {
                        r = new Element(c.getName().toLowerCase());
                        r.addChild((XMLNodeIfc)new Element("text", c.getChildCData(c1 -> c1.getName() == "CRED")));
                        break;
                    }
                    case "DESC": {
                        r = new Element("note");
                        r.addChild((XMLNodeIfc)new Element("text", c.getCData()));
                        break;
                    }
                }
                if (r != null) {
                    vcard4.addChild((XMLNodeIfc)r);
                }
            });
            return vcard4;
        });
        CONVERTERS.put("urn:ietf:params:xml:ns:vcard-4.0|vcard-temp", vcard4 -> {
            Element vcardTemp = new Element("vCard", new String[]{"xmlns"}, new String[]{"vcard-temp"});
            vcard4.forEachChild(c -> {
                Element r = null;
                Element text = null;
                Element uri = null;
                List list = null;
                Object parameters = null;
                Object type = null;
                switch (c.getName()) {
                    case "fn": 
                    case "nickname": 
                    case "tz": 
                    case "title": 
                    case "role": 
                    case "categories": 
                    case "note": 
                    case "prodid": {
                        text = c.findChild(c1 -> c1.getName() == "text");
                        if (text == null) break;
                        r = new Element(c.getName().toUpperCase(), text.getCData());
                        break;
                    }
                    case "n": {
                        r = new Element("N");
                        list = c.mapChildren(c1 -> {
                            switch (c1.getName()) {
                                case "given": {
                                    return new Element("GIVEN", c1.getCData());
                                }
                                case "surname": {
                                    return new Element("FAMILY", c1.getCData());
                                }
                                case "additional": {
                                    return new Element("MIDDLE", c1.getCData());
                                }
                                case "prefix": {
                                    return new Element("PREFIX", c1.getCData());
                                }
                                case "suffix": {
                                    return new Element("SUFFIX", c1.getCData());
                                }
                            }
                            return null;
                        });
                        if (list == null) break;
                        list.removeIf(c1 -> c1 == null);
                        r.addChildren(list);
                        break;
                    }
                    case "photo": 
                    case "logo": {
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        if (uri == null) break;
                        r = new Element(c.getName().toUpperCase());
                        String uriStr = uri.getCData();
                        Matcher matcher = DATA_URI_PATTERN.matcher(uriStr);
                        if (matcher.matches()) {
                            r.addChild((XMLNodeIfc)new Element("TYPE", matcher.group(1)));
                            r.addChild((XMLNodeIfc)new Element("BINVAL", matcher.group(2)));
                            break;
                        }
                        r.addChild((XMLNodeIfc)new Element("EXTVAL", uriStr));
                        break;
                    }
                    case "bday": {
                        Element date = c.findChild(c1 -> c1.getName() == "date");
                        if (date == null) break;
                        r = new Element(c.getName().toUpperCase(), date.getCData());
                        break;
                    }
                    case "adr": {
                        r = new Element("ADR");
                        block102: for (Element c12 : c.getChildren()) {
                            switch (c12.getName()) {
                                case "pobox": 
                                case "street": 
                                case "locality": 
                                case "region": {
                                    r.addChild((XMLNodeIfc)new Element(c12.getName().toUpperCase(), c12.getCData()));
                                    break;
                                }
                                case "ext": {
                                    r.addChild((XMLNodeIfc)new Element("EXTADD", c12.getCData()));
                                    break;
                                }
                                case "code": {
                                    r.addChild((XMLNodeIfc)new Element("PCODE", c12.getCData()));
                                    break;
                                }
                                case "country": {
                                    r.addChild((XMLNodeIfc)new Element("CTRY", c12.getCData()));
                                    break;
                                }
                                case "parameters": {
                                    for (Element c22 : c12.getChildren()) {
                                        switch (c22.getName()) {
                                            case "type": {
                                                list = c22.findChildren(c3 -> c3.getName() == "text");
                                                if (list != null) {
                                                    for (Element c32 : list) {
                                                        r.addChild((XMLNodeIfc)new Element(c32.getCData().toUpperCase()));
                                                    }
                                                }
                                            }
                                            case "pref": {
                                                text = c22.findChild(c3 -> c3.getName() == "integer");
                                                if (text == null) break;
                                                r.addChild((XMLNodeIfc)new Element("PREF"));
                                                break;
                                            }
                                        }
                                    }
                                    continue block102;
                                }
                            }
                        }
                        break;
                    }
                    case "tel": {
                        r = new Element("TEL");
                        block105: for (Element c13 : c.getChildren()) {
                            switch (c13.getName()) {
                                case "parameters": {
                                    for (Element c23 : c13.getChildren()) {
                                        switch (c23.getName()) {
                                            case "type": {
                                                list = c23.findChildren(c3 -> c3.getName() == "text");
                                                if (list != null) {
                                                    for (Element c33 : list) {
                                                        r.addChild((XMLNodeIfc)new Element(c33.getCData().toUpperCase()));
                                                    }
                                                }
                                            }
                                            case "pref": {
                                                text = c23.findChild(c3 -> c3.getName() == "integer");
                                                if (text == null) break;
                                                r.addChild((XMLNodeIfc)new Element("PREF"));
                                                break;
                                            }
                                        }
                                    }
                                    continue block105;
                                }
                                case "uri": {
                                    String uriStr = c13.getCData();
                                    Matcher matcher = TEL_URI_PATTERN.matcher(uriStr);
                                    if (!matcher.matches()) break;
                                    r.addChild((XMLNodeIfc)new Element("NUMBER", matcher.group(1)));
                                }
                            }
                        }
                        break;
                    }
                    case "email": {
                        r = new Element("EMAIL");
                        block108: for (Element c14 : c.getChildren()) {
                            switch (c14.getName()) {
                                case "parameters": {
                                    List parametersChildren = c14.getChildren();
                                    if (parametersChildren == null) break;
                                    for (Element c24 : c14.getChildren()) {
                                        switch (c24.getName()) {
                                            case "type": {
                                                list = c24.findChildren(c3 -> c3.getName() == "text");
                                                if (list != null) {
                                                    for (Element c34 : list) {
                                                        r.addChild((XMLNodeIfc)new Element(c34.getCData().toUpperCase()));
                                                    }
                                                }
                                            }
                                            case "pref": {
                                                text = c24.findChild(c3 -> c3.getName() == "integer");
                                                if (text == null) break;
                                                r.addChild((XMLNodeIfc)new Element("PREF"));
                                                break;
                                            }
                                        }
                                    }
                                    continue block108;
                                }
                                case "text": {
                                    r.addChild((XMLNodeIfc)new Element("USERID", c14.getCData()));
                                }
                            }
                        }
                        break;
                    }
                    case "impp": {
                        Matcher matcher;
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        if (uri != null && (matcher = XMPP_URI_PATTERN.matcher(uri.getCData())).matches()) {
                            r = new Element("JABBERID", matcher.group(1));
                        }
                    }
                    case "geo": {
                        Matcher matcher;
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        if (uri == null || !(matcher = GEO_URI_PATTERN.matcher(uri.getCData())).matches()) break;
                        r = new Element("GEO");
                        r.addChild((XMLNodeIfc)new Element("LAT", matcher.group(1)));
                        r.addChild((XMLNodeIfc)new Element("LON", matcher.group(2)));
                        break;
                    }
                    case "agent": {
                        r = new Element(c.getName().toUpperCase());
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        r.addChild((XMLNodeIfc)new Element("EXTVAL", uri.getCData()));
                        break;
                    }
                    case "org": {
                        text = c.findChild(c1 -> c1.getName() == "text");
                        if (text == null) break;
                        r = new Element("ORG");
                        r.addChild((XMLNodeIfc)new Element("ORGNAME", text.getCData()));
                        break;
                    }
                    case "rev": {
                        text = c.findChild(c2 -> c2.getName() == "timestamp");
                        if (text == null) break;
                        r = new Element("REV", text.getCData());
                        break;
                    }
                    case "sort-as": {
                        r = new Element("SORT-STRING", c.getCData());
                        break;
                    }
                    case "sound": {
                        r = new Element("SOUND");
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        if (uri == null) break;
                        Matcher matcher = DATA_URI_PATTERN.matcher(uri.getCData());
                        if (matcher.matches()) {
                            r.addChild((XMLNodeIfc)new Element("BINVAL", matcher.group(2)));
                            break;
                        }
                        r.addChild((XMLNodeIfc)new Element("EXTVAL", uri.getCData()));
                        break;
                    }
                    case "uid": 
                    case "url": {
                        uri = c.findChild(c1 -> c1.getName() == "uri");
                        if (uri == null) break;
                        r = new Element(c.getName().toUpperCase(), uri.getCData());
                        break;
                    }
                    case "key": {
                        text = c.findChild(c1 -> c1.getName() == "text");
                        if (text == null) break;
                        r = new Element(c.getName().toUpperCase());
                        r.addChild((XMLNodeIfc)new Element("CRED", text.getCData()));
                        break;
                    }
                }
                if (r != null) {
                    vcardTemp.addChild((XMLNodeIfc)r);
                }
            });
            return vcardTemp;
        });
    }

    private static interface Converter {
        public Element convert(Element var1);
    }
}

