/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.conf.ConfigReader;
import tigase.conf.ConfiguratorAbstract;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.events.StartupFinishedEvent;
import tigase.kernel.KernelException;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.BeanConfig;
import tigase.server.Bootstrap;
import tigase.server.ComponentInfo;
import tigase.server.ThreadExceptionHandler;
import tigase.sys.TigaseRuntime;
import tigase.util.ClassUtil;
import tigase.util.ExceptionUtilities;
import tigase.util.Version;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.log.LogFormatter;
import tigase.xml.XMLUtils;

public final class XMPPServer {
    public static final String CONFIGURATOR_PROP_KEY = "tigase-configurator";
    public static final String NAME = "Tigase";
    private static final String DEF_CONFIGURATOR = "tigase.conf.Configurator";
    private static final String[] serverVersionCandidates = new String[]{"tigase.dist.XmppServerDist", XMPPServer.class.getCanonicalName()};
    private static Bootstrap bootstrap;
    private static boolean inOSGi;
    private static String serverName;

    public static <T> T getComponent(String name) {
        try {
            return bootstrap.getInstance(name);
        }
        catch (KernelException ex) {
            Logger.getLogger(XMPPServer.class.getCanonicalName()).log(Level.FINEST, "failed to retrieve instance of " + name, ex);
            return null;
        }
    }

    public static <T> T getComponent(Class<T> clazz) {
        try {
            return bootstrap.getInstance(clazz);
        }
        catch (KernelException ex) {
            Logger.getLogger(XMPPServer.class.getCanonicalName()).log(Level.FINEST, "failed to retrieve instance of " + clazz, ex);
            return null;
        }
    }

    public static <T> Stream<T> getComponents(Class<T> clazz) {
        return bootstrap.getKernel().getDependencyManager().getBeanConfigs().stream().filter(bc -> clazz.isAssignableFrom(bc.getClazz()) && bc.getState() == BeanConfig.State.initialized).map(bc -> bootstrap.getInstance(bc.getBeanName()));
    }

    public static String getImplementationVersion() {
        Optional<Version> version = ComponentInfo.getImplementationVersion(serverVersionCandidates);
        return version.isPresent() ? version.get().toString() : "0.0.0-0";
    }

    public static Version getVersion() {
        return ComponentInfo.getImplementationVersion(serverVersionCandidates).orElse(Version.ZERO);
    }

    public static String help() {
        return "\nParameters:\n -h               this help message\n -v               prints server version info\n -n server-name    sets server name\n";
    }

    public static boolean isOSGi() {
        return inOSGi;
    }

    public static void setOSGi(boolean val) {
        inOSGi = val;
    }

    public static void main(String[] args) {
        XMPPServer.parseParams(args);
        System.out.println(new ComponentInfo(XMLUtils.class).toString());
        System.out.println(new ComponentInfo(ClassUtil.class).toString());
        System.out.println(new ComponentInfo(XMPPServer.class).toString());
        ComponentInfo.of("tigase.dist.XmppServerDist").ifPresent(System.out::println);
        XMPPServer.start(args);
    }

    public static void parseParams(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(XMPPServer.help());
                    System.exit(0);
                }
                if (args[i].equals("-v")) {
                    System.out.print(XMPPServer.version());
                    System.exit(0);
                }
                if (!args[i].equals("-n")) continue;
                if (i + 1 == args.length) {
                    System.out.print(XMPPServer.help());
                    System.exit(1);
                    continue;
                }
                serverName = args[++i];
            }
        }
    }

    public static void start(String[] args) {
        long start = System.currentTimeMillis();
        Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionHandler());
        if (!XMPPServer.isOSGi()) {
            String initial_config = "tigase.level=ALL\ntigase.xml.level=INFO\nhandlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=" + LogFormatter.class.getName() + "\n";
            ConfiguratorAbstract.loadLogManagerConfig(initial_config);
        }
        try {
            bootstrap = new Bootstrap();
            bootstrap.init(args);
            bootstrap.start();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
            if (ServerBeanSelector.getConfigType(bootstrap.getKernel()) == ConfigTypeEnum.SetupMode) {
                System.out.println("== " + sdf.format(new Date()) + " Please setup server at http://localhost:8080/\n");
            } else {
                System.out.println("== " + sdf.format(new Date()) + " Server finished starting up in (" + (System.currentTimeMillis() - start) / 1000L + "s) and (if there wasn't any error) is ready to use\n");
            }
            EventBusFactory.getInstance().fire(new StartupFinishedEvent(DNSResolverFactory.getInstance().getDefaultHost()));
        }
        catch (ConfigReader.UnsupportedOperationException e) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Terminating the server process.", e.getMessage() + " at line " + e.getLine() + " position " + e.getPosition(), "Line: " + e.getLineContent(), "Please fix the problem and start the server again."});
        }
        catch (ConfigReader.ConfigException e) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Terminating the server process.", "Issue with configuration file: " + e, "Please fix the problem and start the server again."});
        }
        catch (Exception e) {
            String cause = ExceptionUtilities.getExceptionRootCause((Exception)e, (boolean)true);
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"ERROR! Terminating the server process.", "Problem initializing the server: " + cause, "Please fix the problem and start the server again."});
        }
    }

    public static void stop() {
        if (bootstrap != null) {
            bootstrap.stop();
        }
    }

    public static String version() {
        return "\n-- \nTigase XMPP Server, version: " + XMPPServer.getImplementationVersion() + "\nAuthor:  Artur Hefczyc <artur.hefczyc@tigase.org>\n-- \n";
    }

    private XMPPServer() {
    }

    static {
        inOSGi = false;
        serverName = "message-router";
    }
}

