/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="x-info", parent=MonitorComponent.class, active=true)
public class InfoTaskCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(InfoTaskCommand.class.getName());
    public static final String NODE = "x-info";
    @Inject
    private MonitorComponent component;
    @Inject
    private Kernel kernel;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else {
                InfoTask taskInstance = (InfoTask)this.kernel.getInstance(request.getIq().getStanzaTo().getResource());
                Form form = taskInstance.getTaskInfo();
                response.getElements().add(form.getElement());
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Error executing script", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Task info";
    }

    @Override
    public String getNode() {
        return NODE;
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

