/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.DataSourcePool;
import tigase.db.beans.MDPoolBean;
import tigase.db.beans.MDPoolConfigBean;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.BasicComponent;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsCollector;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProviderIfc;

@Bean(name="dataSource", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class DataSourceBean
extends MDPoolBean<DataSource, DataSourceMDConfigBean>
implements ComponentStatisticsProvider {
    private static final Logger log = Logger.getLogger(DataSourceBean.class.getCanonicalName());
    private final Map<String, DataSource> repositories = new ConcurrentHashMap<String, DataSource>();
    @Inject
    private EventBus eventBus;
    private ScheduledExecutorService executorService = null;
    private int watchdogs = 0;

    public DataSource getRepository(String name) {
        if (name == null) {
            return this.repositories.get("default");
        }
        return this.repositories.get(name);
    }

    @Override
    public Class<? extends DataSourceMDConfigBean> getConfigClass() {
        return DataSourceMDConfigBean.class;
    }

    @Override
    public void addRepo(String domain, DataSource repo) {
        DataSource oldRepo = this.repositories.put(domain, repo);
        this.fire(new DataSourceChangedEvent(this, domain, repo, oldRepo));
    }

    @Override
    public DataSource removeRepo(String domain) {
        DataSource oldRepo = this.repositories.remove(domain);
        this.fire(new DataSourceChangedEvent(this, domain, null, oldRepo));
        return oldRepo;
    }

    public Set<String> getDataSourceNames() {
        return Collections.unmodifiableSet(this.repositories.keySet());
    }

    @Override
    public void setDefault(DataSource repo) {
    }

    @Override
    public boolean belongsTo(Class<? extends BasicComponent> component) {
        return StatisticsCollector.class.isAssignableFrom(component);
    }

    @Override
    public void everyHour() {
    }

    @Override
    public void everyMinute() {
    }

    @Override
    public void everySecond() {
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        String name = this.getName();
        list.add(name, "Number of data sources", this.repositories.size(), Level.FINE);
        this.repositories.entrySet().stream().filter(e -> e.getValue() instanceof StatisticsProviderIfc).forEach(e -> ((StatisticsProviderIfc)e.getValue()).getStatistics(name + "/" + (String)e.getKey(), list));
    }

    @Override
    public Class<?> getDefaultBeanClass() {
        return DataSourceMDConfigBean.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledFuture addWatchdogTask(Runnable task, Duration frequency) {
        DataSourceBean dataSourceBean = this;
        synchronized (dataSourceBean) {
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadScheduledExecutor();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "created watchdog executor");
                }
            }
            ++this.watchdogs;
            return this.executorService.scheduleAtFixedRate(task, frequency.toMillis(), frequency.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWatchdogTask(ScheduledFuture scheduledFuture) {
        DataSourceBean dataSourceBean = this;
        synchronized (dataSourceBean) {
            scheduledFuture.cancel(true);
            --this.watchdogs;
            if (this.watchdogs == 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "destroying watchdog executor");
                }
                this.executorService.shutdown();
                this.executorService = null;
            }
        }
    }

    private void fire(Object event) {
        if (this.eventBus != null) {
            this.eventBus.fire(event);
        }
    }

    public static class DataSourceMDConfigBean
    extends MDPoolConfigBean<DataSource, DataSourceMDConfigBean>
    implements UnregisterAware {
        private ScheduledFuture future = null;
        @ConfigField(desc="Watchdog data source frequency", alias="watchdog-frequency")
        private Duration watchdogFrequency = Duration.ofHours(1L);

        public void setWatchdogFrequency(Duration watchdogFrequency) {
            this.watchdogFrequency = watchdogFrequency;
            this.updateWatchdogTask();
        }

        @Override
        public void initialize() {
            super.initialize();
            this.updateWatchdogTask();
        }

        @Override
        public void beforeUnregister() {
            if (this.future != null && this.mdPool != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "unregistering watchdog for data source {0}", this.name);
                }
                ((DataSourceBean)this.mdPool).removeWatchdogTask(this.future);
            }
        }

        @Override
        protected Class<? extends DataSource> getRepositoryIfc() {
            return DataSource.class;
        }

        @Override
        protected String getRepositoryPoolClassName() throws DBInitException {
            if (this.poolCls != null) {
                return this.poolCls;
            }
            Class<DataSourcePool> poolClass = null;
            try {
                poolClass = DataSourceHelper.getDefaultClass(DataSourcePool.class, this.uri);
            }
            catch (DBInitException dBInitException) {
                // empty catch block
            }
            return poolClass == null ? null : poolClass.getCanonicalName();
        }

        @Override
        protected void initRepository(DataSource repo) throws RepositoryException {
            repo.initialize(this.getUri());
        }

        private void executeWatchdog() {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "execution of watchdog for data source {0}", this.name);
            }
            ((DataSource)this.getRepository()).checkConnectivity(this.watchdogFrequency);
        }

        private void updateWatchdogTask() {
            if (this.mdPool != null) {
                DataSourceBean dataSourceBean = (DataSourceBean)this.mdPool;
                if (this.future != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "unregistering watchdog for data source {0}", this.name);
                    }
                    dataSourceBean.removeWatchdogTask(this.future);
                }
                if (!this.watchdogFrequency.isZero()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "registering watchdog for data source {0} with frequency {1}", new Object[]{this.name, this.watchdogFrequency});
                    }
                    dataSourceBean.addWatchdogTask(this::executeWatchdog, this.watchdogFrequency);
                }
            }
        }
    }

    public static class DataSourceChangedEvent {
        private final DataSourceBean bean;
        private final String domain;
        private final DataSource newDataSource;
        private final DataSource oldDataSource;

        public DataSourceChangedEvent(DataSourceBean bean, String domain, DataSource newDataSource, DataSource oldDataSource) {
            this.bean = bean;
            this.domain = domain;
            this.newDataSource = newDataSource;
            this.oldDataSource = oldDataSource;
        }

        public boolean isCorrectSender(DataSourceBean bean) {
            return this.bean == bean;
        }

        public String getDomain() {
            return this.domain;
        }

        public DataSource getOldDataSource() {
            return this.oldDataSource;
        }

        public DataSource getNewDataSource() {
            return this.newDataSource;
        }
    }
}

