/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticFileServlet
extends HttpServlet {
    public static final String ALLOWED_PATTERN_KEY = "allowed-pattern";
    public static final String DIRECTORY_KEY = "directory";
    public static final String INDEX_KEY = "index";
    private Pattern allowedPattern = null;
    private File directory = null;
    private String index = null;

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        this.directory = new File(cfg.getInitParameter(DIRECTORY_KEY));
        this.index = cfg.getInitParameter(INDEX_KEY);
        String allowedPatternStr = cfg.getInitParameter(ALLOWED_PATTERN_KEY);
        if (allowedPatternStr != null) {
            this.allowedPattern = Pattern.compile(allowedPatternStr);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String prefix = req.getServletPath();
        prefix = String.valueOf(req.getContextPath()) + prefix;
        String pathStr = req.getRequestURI().replace(prefix, "");
        if (pathStr.contains("../")) {
            resp.sendError(406);
            return;
        }
        if ((pathStr == null || pathStr.isEmpty() || pathStr.equals("/")) && this.index != null) {
            pathStr = this.index;
        }
        if (this.allowedPattern != null && !this.allowedPattern.matcher(pathStr).matches()) {
            resp.sendError(403);
            return;
        }
        Path path = Paths.get(this.directory.getAbsolutePath(), pathStr);
        if (!Files.exists(path, new LinkOption[0])) {
            resp.sendError(404);
            return;
        }
        String mimeType = Files.probeContentType(path);
        if (mimeType != null) {
            resp.setContentType(mimeType);
        }
        Files.copy(path, (OutputStream)resp.getOutputStream());
    }
}

