/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.AbstractHttpModule;
import tigase.http.upload.HttpModule;
import tigase.http.upload.db.FileUploadRepository;
import tigase.http.upload.logic.Logic;
import tigase.http.upload.logic.UriFormat;
import tigase.http.upload.store.Store;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.xmpp.jid.BareJID;

public class FileServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(FileServlet.class.getCanonicalName());
    private FileServletContext context;

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String kernelId = cfg.getInitParameter("kernel");
        Kernel kernel = AbstractHttpModule.getKernel(kernelId);
        this.context = (FileServletContext)kernel.getInstance(FileServletContext.class);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            UriFormat uriFormat = this.context.logic.getDownloadURIFormat();
            Matcher m = uriFormat.parsePath(req.getPathInfo().substring(1));
            if (!m.matches()) {
                resp.sendError(404);
                return;
            }
            BareJID uploader = null;
            if (uriFormat.hasGroup("jid")) {
                String jidStr = m.group("jid");
                uploader = jidStr.isEmpty() ? null : BareJID.bareJIDInstanceNS((String)jidStr);
            } else if (uriFormat.hasGroup("domain")) {
                String domain = m.group("domain");
                uploader = domain.isEmpty() ? null : BareJID.bareJIDInstanceNS((String)domain);
            }
            String slotId = m.group("slotId");
            String filename = m.group("filename");
            FileUploadRepository.Slot slot = this.context.repo.getSlot(uploader, slotId);
            if (slot == null) {
                resp.sendError(404);
                return;
            }
            WritableByteChannel outChannel = Channels.newChannel((OutputStream)resp.getOutputStream());
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (ReadableByteChannel inChannel = this.context.store.getContent(slot.uploader, slot.slotId, filename);){
                    if (inChannel == null) {
                        resp.sendError(404);
                    } else {
                        resp.setHeader("Content-Length", String.valueOf(slot.filesize));
                        resp.setHeader("Content-Disposition", "inline; filename=\"" + slot.filename + "\"");
                        if (slot.contentType != null) {
                            resp.setHeader("Content-Type", slot.contentType);
                        }
                        resp.setStatus(200);
                        this.transferData(inChannel, outChannel);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                resp.sendError(500, "Internal Server Error");
                log.log(Level.FINE, "Exception during processing request", ex);
            }
        }
        catch (Throwable ex) {
            resp.sendError(500, "Internal Server Error");
            log.log(Level.FINE, "Exception during processing request", ex);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            UriFormat uriFormat = this.context.logic.getDownloadURIFormat();
            Matcher m = uriFormat.parsePath(req.getPathInfo().substring(1));
            if (!m.matches()) {
                resp.sendError(404);
                return;
            }
            BareJID uploader = null;
            if (uriFormat.hasGroup("jid")) {
                String jidStr = m.group("jid");
                uploader = jidStr.isEmpty() ? null : BareJID.bareJIDInstanceNS((String)jidStr);
            } else if (uriFormat.hasGroup("domain")) {
                String domain = m.group("domain");
                uploader = domain.isEmpty() ? null : BareJID.bareJIDInstanceNS((String)domain);
            }
            String slotId = m.group("slotId");
            m.group("filename");
            FileUploadRepository.Slot slot = this.context.repo.getSlot(uploader, slotId);
            if (slot == null) {
                resp.sendError(404);
                return;
            }
            resp.setHeader("Content-Length", String.valueOf(slot.filesize));
            if (slot.contentType != null) {
                resp.setHeader("Content-Type", slot.contentType);
            }
            resp.setStatus(200);
        }
        catch (Throwable ex) {
            resp.sendError(500, "Internal Server Error");
            log.log(Level.FINE, "Exception during processing request", ex);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doOptions(req, resp);
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Methods", "PUT, GET, OPTIONS");
        resp.setHeader("Access-Control-Allow-Headers", "Content-Type");
        resp.setHeader("Access-Control-Max-Age", "86400");
        resp.setStatus(200);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            UriFormat uriFormat = this.context.logic.getUploadURIFormat();
            Matcher m = uriFormat.parsePath(req.getPathInfo().substring(1));
            if (!m.matches()) {
                resp.sendError(404);
                return;
            }
            BareJID uploader = null;
            if (uriFormat.hasGroup("jid")) {
                String jidStr = m.group("jid");
                uploader = jidStr.isEmpty() ? null : BareJID.bareJIDInstance((String)jidStr);
            } else if (uriFormat.hasGroup("domain")) {
                String domain = m.group("domain");
                uploader = domain.isEmpty() ? null : BareJID.bareJIDInstance((String)domain);
            }
            String slotId = m.group("slotId");
            String filename = m.group("filename");
            String contentType = req.getContentType();
            long fileSize = req.getContentLengthLong();
            FileUploadRepository.Slot slot = this.context.repo.getSlot(uploader, slotId);
            if (slot != null && slot.matches(slotId, fileSize, contentType)) {
                ReadableByteChannel inChannel = Channels.newChannel((InputStream)req.getInputStream());
                this.context.store.setContent(uploader, slotId, filename, fileSize, inChannel);
                this.context.repo.updateSlot(slot.uploader, slotId);
                resp.setStatus(201);
            } else {
                resp.sendError(404);
            }
        }
        catch (Throwable ex) {
            resp.sendError(500, "Internal Server Error");
            log.log(Level.FINE, "Exception during processing request", ex);
        }
    }

    protected void transferData(ReadableByteChannel in, WritableByteChannel out) throws IOException {
        if (in instanceof FileChannel) {
            FileChannel fin = (FileChannel)in;
            long size = fin.size();
            fin.transferTo(0L, size, out);
        } else {
            ByteBuffer buf = ByteBuffer.allocate(65536);
            while (in.read(buf) != -1) {
                buf.flip();
                out.write(buf);
                buf.compact();
            }
        }
    }

    @Bean(name="fileServletContext", parent=HttpModule.class, active=true)
    public static class FileServletContext {
        @Inject
        public Logic logic;
        @Inject
        public FileUploadRepository repo;
        @Inject
        public Store store;
    }
}

