/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.xmpp.jid.BareJID;

public class BasicConfigPage
extends Page {
    public BasicConfigPage(Config config) {
        super("Basic Tigase server configuration", "basicConfig.html", new SingleAnswerQuestion("configType", true, () -> config.getConfigType().id(), type -> config.setConfigType(ConfigTypeEnum.valueForId((String)type))), new VirtualDomainQuestion("virtualDomain", config), new AdminsQuestion("admins", config), new SingleAnswerQuestion("adminPwd", () -> config.adminPwd, pwd -> {
            String string = config.adminPwd = pwd;
        }), new SingleAnswerQuestion("dbType", true, () -> config.getDbType(), type -> config.setDbType((String)type)), new SingleAnswerQuestion("advancedConfig", () -> String.valueOf(config.advancedConfig), val -> {
            boolean bl = config.advancedConfig = val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false;
        }));
    }

    private static class AdminsQuestion
    extends SingleAnswerQuestion {
        AdminsQuestion(String id, Config config) {
            super(id, false, () -> Arrays.stream(config.admins).map(jid -> jid.toString()).collect(Collectors.joining(",")), (String admins) -> {
                config.admins = admins != null && !admins.trim().isEmpty() ? (BareJID[])Stream.of(admins.split(",")).map(str -> str.trim()).map(str -> BareJID.bareJIDInstanceNS((String)str)).toArray(BareJID[]::new) : new BareJID[0];
            });
        }
    }

    private static class VirtualDomainQuestion
    extends SingleAnswerQuestion {
        VirtualDomainQuestion(String id, Config config) {
            super(id, true, () -> Optional.ofNullable(config.defaultVirtualDomain).orElse(""), (String vhost) -> {
                config.defaultVirtualDomain = vhost;
            });
        }
    }
}

