/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.stateless;

import java.util.Date;
import java.util.List;
import tigase.component.exceptions.RepositoryException;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

class Items
implements IItems {
    private final IPubSubDAO dao;
    private final long nodeId;
    private final String nodeName;
    private final BareJID serviceJid;

    public Items(long nodeId, BareJID serviceJid, String nodeName, IPubSubDAO dao) {
        this.nodeId = nodeId;
        this.dao = dao;
        this.nodeName = nodeName;
        this.serviceJid = serviceJid;
    }

    @Override
    public void deleteItem(String id) throws RepositoryException {
        this.dao.deleteItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Element getItem(String id) throws RepositoryException {
        return this.dao.getItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Date getItemCreationDate(String id) throws RepositoryException {
        return this.dao.getItemCreationDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public String[] getItemsIds(CollectionItemsOrdering order) throws RepositoryException {
        return this.dao.getItemsIds(this.serviceJid, this.nodeId, order);
    }

    @Override
    public String[] getItemsIdsSince(CollectionItemsOrdering order, Date since) throws RepositoryException {
        return this.dao.getItemsIdsSince(this.serviceJid, this.nodeId, order, since);
    }

    @Override
    public List<IItems.ItemMeta> getItemsMeta() throws RepositoryException {
        return this.dao.getItemsMeta(this.serviceJid, this.nodeId, this.nodeName);
    }

    @Override
    public Date getItemUpdateDate(String id) throws RepositoryException {
        return this.dao.getItemUpdateDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public void writeItem(long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        this.dao.writeItem(this.serviceJid, this.nodeId, timeInMilis, id, publisher, item);
    }
}

