/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.converter;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.converter.Converter;
import tigase.db.converter.Convertible;
import tigase.db.converter.QueryExecutor;
import tigase.kernel.beans.Inject;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.converter.PubSubItemEntity;
import tigase.pubsub.repository.converter.PubSubNodeConverter;
import tigase.pubsub.repository.converter.PubSubQueries;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;

public class PubSubItemsConverter
implements Convertible<PubSubItemEntity> {
    private static final Logger log = Logger.getLogger(PubSubItemsConverter.class.getName());
    @Inject
    QueryExecutor queryExecutor;
    private SimpleParser parser = SingletonFactory.getParserInstance();
    private Converter.ConverterProperties properties;
    private PubSubQueries queries;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;

    public Optional<Class> getParentBean() {
        return Optional.of(PubSubComponent.class);
    }

    public Optional<Class<? extends Convertible>> dependsOn() {
        return Optional.of(PubSubNodeConverter.class);
    }

    public Optional<String> getMainQuery() {
        return this.queries.getQuery("SELECT pubsub_item.nodeid, host, node, itemid, publisher, creation, modification, payload FROM pubsub_item LEFT JOIN pubsub_node on pubsub_item.nodeid = pubsub_node.nodeid order by host, node, creation");
    }

    public void initialise(Converter.ConverterProperties converterProperties) {
        this.properties = converterProperties;
        this.queries = new PubSubQueries(this.properties.getServerType(), this.properties.getDatabaseType());
    }

    public Optional<PubSubItemEntity> processResultSet(ResultSet rs) throws Exception {
        String node = null;
        String host = null;
        String itemid = null;
        String publisher = null;
        String payloadStr = null;
        switch (this.properties.getServerType()) {
            case ejabberd: {
                node = rs.getString("node");
                host = rs.getString("host");
                itemid = rs.getString("itemid");
                publisher = rs.getString("publisher");
                payloadStr = rs.getString("payload");
            }
        }
        Optional<Element> payload = this.parsePayload(payloadStr);
        if (node != null && host != null && publisher != null && payload.isPresent()) {
            BareJID service = BareJID.bareJIDInstance((String)host);
            PubSubItemEntity pubSubNodeEntity = new PubSubItemEntity(service, node, itemid, publisher, payload.get());
            return Optional.of(pubSubNodeEntity);
        }
        return Optional.empty();
    }

    public boolean storeEntity(PubSubItemEntity entity) throws Exception {
        IItems nodeItems = this.repository.getNodeItems(entity.getService(), entity.getNode());
        nodeItems.writeItem(System.currentTimeMillis(), entity.getItemid(), entity.getPublisher(), entity.getPayload());
        return true;
    }

    public Map<String, String> getAdditionalQueriesToInitialise() {
        return this.queries.getAllQueriesForServerAndDatabase().orElse(Collections.emptyMap());
    }

    private Optional<Element> parsePayload(String payloadStr) {
        if (payloadStr != null) {
            DomBuilderHandler domHandler = new DomBuilderHandler();
            char[] data = payloadStr.toCharArray();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue parsedElements = domHandler.getParsedElements();
            return parsedElements.peek() != null ? Optional.of(parsedElements.poll()) : Optional.empty();
        }
        return Optional.empty();
    }
}

