/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.logging.Logger;
import tigase.pubsub.modules.commands.AbstractLoadRunner;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class LoadTestGenerator
extends AbstractLoadRunner {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final AbstractMessageReceiver component;
    private final boolean useBlockingMethod;
    private String nodeName;
    private JID packetFromJid;
    private Element payload;
    private BareJID publisher;
    private BareJID serviceJid;

    public LoadTestGenerator(AbstractMessageReceiver component, BareJID serviceJid, String node, BareJID publisher, long time, long frequency, int messageLength, boolean useBlockingMethod) {
        super(time, frequency);
        this.component = component;
        this.serviceJid = serviceJid;
        this.nodeName = node;
        this.publisher = publisher;
        this.useBlockingMethod = useBlockingMethod;
        this.packetFromJid = JID.jidInstanceNS((String)"sess-man", (String)serviceJid.getDomain(), null);
        String x = "";
        for (int i = 0; i < messageLength; ++i) {
            x = x + "a";
        }
        this.payload = new Element("payload", x);
    }

    @Override
    protected void doWork() throws Exception {
        Element item = new Element("item", new String[]{"id"}, new String[]{this.getCounter() + "-" + this.getTestEndTime()});
        item.addChild((XMLNodeIfc)this.payload);
        Element iq = new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"set", this.publisher.toString(), this.serviceJid.toString(), "pub-" + this.getCounter() + "-" + this.getTestEndTime()});
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish", new String[]{"node"}, new String[]{this.nodeName});
        pubsub.addChild((XMLNodeIfc)publish);
        publish.addChild((XMLNodeIfc)item);
        Packet p = Packet.packetInstance((Element)iq);
        p.setXMLNS("jabber:client");
        p.setPacketFrom(this.packetFromJid);
        if (this.component != null) {
            if (this.useBlockingMethod) {
                this.component.addPacket(p);
            } else {
                this.component.addPacketNB(p);
            }
        }
    }
}

