/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IEncryptedNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPlainNotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.apns.APNS;
import tigase.push.apns.ApnsNotification;
import tigase.push.apns.ApnsPayload;
import tigase.push.apns.ApnsService;
import tigase.push.modules.AffiliationChangedModule;

@Bean(name="apns-binary-api", parent=PushNotificationsComponent.class, active=false)
public class APNsBinaryApiProvider
implements UnregisterAware,
ConfigurationChangedAware,
IPushProvider {
    private static final Logger a = Logger.getLogger(APNsBinaryApiProvider.class.getCanonicalName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    private final ApnsDelegate b = new ApnsDelegate("main");
    private final ApnsDelegate c = new ApnsDelegate("sandbox");
    @ConfigField(desc="Password for certificate file", alias="cert-password")
    private String certificatePassword;
    @ConfigField(desc="Path to certificate file (.p12)", alias="cert-file")
    private String certificatePath;
    @ConfigField(desc="Provider description")
    private String description = "Push provider for APNs - Binary API";
    private Set<String> d = new ConcurrentSkipListSet<String>();
    @ConfigField(desc="Fallback to sandbox")
    private boolean fallbackToSandbox = false;
    @ConfigField(desc="APNS-Topic", alias="apns-topic")
    private String apnsTopic;
    @ConfigField(desc="Provider name")
    private String name = "apns-binary-api";
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Sandbox")
    private boolean sandbox = false;
    private ApnsService e;
    private ApnsService f;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Optional<Integer> maxPayloadSize() {
        return Optional.of(3072);
    }

    @Override
    public Set<IPushProvider.Feature> supportedFeatures() {
        return Set.of(IPushProvider.Feature.plain, IPushProvider.Feature.encrypted);
    }

    @Override
    public void pushNotification(String deviceId, INotification notification) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "sending push notification to " + deviceId + " for account " + notification.getAccount());
        }
        ApnsPayload.Builder builder = this.preparePayload(APNS.newPayload(), notification);
        ApnsNotification.Builder builder2 = APNS.newNotification();
        if (this.apnsTopic != null) {
            builder2.topic(this.apnsTopic);
        }
        switch (notification.getPriority()) {
            case low: {
                builder2.pushType(ApnsNotification.PushType.background);
                break;
            }
            case high: {
                builder.body("New message!").sound("default").mutableContent(1).category("MESSAGE").threadId(notification.getAccount().toString());
                builder2.pushType(ApnsNotification.PushType.alert);
            }
        }
        ApnsNotification apnsNotification = builder2.deviceId(deviceId).payload(builder.build()).build();
        this.e.push(apnsNotification);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "pushed for push notification delivery = " + apnsNotification);
        }
    }

    public void beforeUnregister() {
        this.a(null);
        this.b(null);
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (changedFields.contains("certificatePath") || changedFields.contains("certificatePassword") || changedFields.contains("poolSize") || changedFields.contains("fallbackToSandbox")) {
            try {
                if (this.fallbackToSandbox) {
                    this.b(APNS.newService().withCert(this.certificatePath, this.certificatePassword).withDelegate(this.c).withAppleDestination(false).build());
                    this.c.a(this::failure);
                } else {
                    this.b(null);
                }
                this.a(APNS.newService().withCert(this.certificatePath, this.certificatePassword).withDelegate(this.b).withAppleDestination(!this.sandbox).build());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not configure APNs provider!");
            }
        }
    }

    protected void failureWithFallback(ApnsNotification notification, ApnsService.ErrorCode errorCode, ApnsService.ErrorType errorType) {
        switch (errorType) {
            case badDeviceToken: {
                this.d.add(notification.getDeviceId());
                this.f.push(notification);
                break;
            }
            default: {
                this.failure(notification, errorCode, errorType);
            }
        }
    }

    protected void failure(ApnsNotification notification, ApnsService.ErrorCode errorCode, ApnsService.ErrorType errorType) {
        switch (errorType) {
            case badDeviceToken: {
                this.d.remove(notification.getDeviceId());
            }
            case deviceTokenNotForTopic: 
            case unregistred: {
                this.unregisterDevice(notification.getDeviceId());
                break;
            }
        }
    }

    protected ApnsPayload.Builder preparePayload(ApnsPayload.Builder builder, INotification notification) {
        if (notification instanceof IPlainNotification) {
            return this.preparePlainPayload(builder, (IPlainNotification)notification);
        }
        if (notification instanceof IEncryptedNotification) {
            return this.prepareEncryptedPayload(builder, (IEncryptedNotification)notification);
        }
        throw new IllegalArgumentException("Not supported notification class:" + notification.getClass().getCanonicalName());
    }

    protected ApnsPayload.Builder preparePlainPayload(ApnsPayload.Builder builder, IPlainNotification notification) {
        if (notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        builder.customField("account", notification.getAccount().toString());
        notification.ifMessageCount(l -> builder.customField("unread-messages", l));
        notification.ifLastMessageSender(jID -> builder.customField("sender", jID.getBareJID().toString()));
        notification.ifGroupchatSenderNickname(string -> builder.customField("nickname", string));
        notification.ifLastMessageBody(object -> {
            if (((String)object).length() > 512) {
                object = ((String)object).substring(0, 500) + "...";
            }
            builder.customField("body", object);
        });
        return builder;
    }

    protected ApnsPayload.Builder prepareEncryptedPayload(ApnsPayload.Builder builder, IEncryptedNotification notification) {
        if (notification.getPriority() != INotification.Priority.high) {
            builder.instantDeliveryOrSilentNotification();
        }
        builder.customField("account", notification.getAccount().toString()).customField("encrypted", notification.getEncrypted()).customField("iv", notification.getIV());
        return builder;
    }

    protected void unregisterDevice(String deviceId) {
        try {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "unregistering device " + deviceId + " as it was reported as inactive by APNs");
            }
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), deviceId);
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && (iPushSettings2.getDevices().isEmpty() || iPushSettings2.getVersion() > 0)) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwnerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException | RepositoryException throwable) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, throwable);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    private void a(ApnsService apnsService) {
        ApnsService apnsService2 = this.e;
        this.e = apnsService;
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private void b(ApnsService apnsService) {
        ApnsService apnsService2 = this.f;
        this.f = apnsService;
        if (apnsService != null) {
            this.b.a(this::failureWithFallback);
        } else {
            this.b.a(this::failure);
            this.d.clear();
        }
        if (apnsService2 != null) {
            apnsService2.stop();
        }
    }

    private static class ApnsDelegate
    implements tigase.push.apns.ApnsDelegate {
        private final String a;
        private volatile Optional<TriConsumer<ApnsNotification, ApnsService.ErrorCode, ApnsService.ErrorType>> b;

        ApnsDelegate(String name) {
            this.a = name;
        }

        private void a(TriConsumer<ApnsNotification, ApnsService.ErrorCode, ApnsService.ErrorType> triConsumer) {
            this.b = Optional.ofNullable(triConsumer);
        }

        @Override
        public void messageSendFailed(ApnsNotification message, ApnsService.ErrorCode errorCode, ApnsService.ErrorType errorType) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "failed to deliver push notification = {0} using {1} service with error code: {2} and type: {3}", new Object[]{message, this.a, errorCode, errorType});
            }
            this.b.ifPresent(triConsumer -> triConsumer.accept(message, errorCode, errorType));
        }

        @Override
        public void messageSent(ApnsNotification message) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "push notification successfully sent to " + this.a + " APNs = " + message);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.a;
        }

        @FunctionalInterface
        public static interface TriConsumer<T, S, U> {
            public void accept(T var1, S var2, U var3);
        }
    }
}

