/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.scheduler;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import tigase.component.PacketWriter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.workgroupqueues.Config;
import tigase.workgroupqueues.scheduler.Agent;
import tigase.workgroupqueues.scheduler.Controller;
import tigase.workgroupqueues.scheduler.Queue;
import tigase.workgroupqueues.scheduler.Room;
import tigase.workgroupqueues.scheduler.Scheduler;
import tigase.workgroupqueues.scheduler.User;
import tigase.workgroupqueues.util.sequencer.Actions;
import tigase.workgroupqueues.util.sequencer.ISequenceAction;
import tigase.workgroupqueues.util.sequencer.Sequencer;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="Scheduler", active=true)
public class DummyScheduler
implements Scheduler {
    @Inject
    Config a;
    @Inject
    private Controller controller;
    @Inject
    private PacketWriter writer;

    @Override
    public Agent getBestAgent(Queue queue, User user) {
        Iterator iterator = queue.getAgents().stream().filter(Objects::nonNull).filter(agent -> agent.getMaxChats() > agent.getBusySlots()).sorted(Comparator.comparingInt(Agent::getBusySlots)).iterator();
        if (iterator.hasNext()) {
            return (Agent)iterator.next();
        }
        return null;
    }

    @Override
    public void onUserJoinedQueue(Queue queue, User user) {
        if (this.a.getInviteBotJID() != null) {
            try {
                Room room = this.controller.createRoomInstance(queue, user);
                user.setRoom(room);
                Sequencer sequencer = new Sequencer(){

                    @Override
                    public void onFailure() {
                    }

                    @Override
                    public void onFinish() {
                    }
                };
                sequencer.add(this.controller.getRoomCreateActions(queue, user, room));
                sequencer.add(this.a(queue, room));
                sequencer.add(this.b(queue, room));
                sequencer.run();
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                tigaseStringprepException.printStackTrace();
            }
        }
    }

    private ISequenceAction a(Queue queue, Room room) throws TigaseStringprepException {
        Element element = new Element("iq", new String[]{"type", "to", "from", "id"}, new String[]{"set", room.getRoomJID().toString(), queue.getJid().toString(), UUID.randomUUID().toString()});
        Element element2 = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#admin"});
        element.addChild((XMLNodeIfc)element2);
        element2.addChild((XMLNodeIfc)new Element("item", new String[]{"affiliation", "jid"}, new String[]{"admin", this.a.getInviteBotJID().toString()}));
        return new Actions.WriteIQPacket(this.writer, Packet.packetInstance((Element)element));
    }

    private ISequenceAction b(Queue queue, Room room) throws TigaseStringprepException {
        Element element = new Element("message", new String[]{"from", "to"}, new String[]{room.getRoomJID().toString(), this.a.getInviteBotJID().toString()});
        Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        element.addChild((XMLNodeIfc)element2);
        Element element3 = new Element("invite", new String[]{"from"}, new String[]{queue.getJid().toString()});
        element2.addChild((XMLNodeIfc)element3);
        final Packet packet = Packet.packetInstance((Element)element);
        return new Actions.CallMethod(){

            @Override
            public void proxy() {
                DummyScheduler.this.writer.write(packet);
            }
        };
    }
}

