/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import tigase.util.cache.SimpleCache;
import tigase.util.dns.DNSEntry;
import tigase.util.dns.DNSResolverIfc;

public class DNSResolverDefault
implements DNSResolverIfc {
    private static final long DNS_CACHE_TIME = 60000L;
    private static final String LOCALHOST = "localhost";
    private static final Logger log = Logger.getLogger(DNSResolverDefault.class.getName());
    private static final String OPEN_DNS_HIT_NXDOMAIN = "hit-nxdomain.opendns.com";
    public static Map<String, DNSEntry> ip_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    public static Map<String, DNSEntry[]> srv_cache = Collections.synchronizedMap(new SimpleCache(100, 60000L));
    private static String defaultHost = null;
    private static String[] localnames = null;
    private static String opendns_hit_nxdomain_ip = null;
    private static String primaryHost = null;
    private static long resolveDefaultTime = 0L;
    private static String secondaryHost = null;

    protected static boolean isHostValid(String host) {
        try {
            if (host != null && !host.trim().isEmpty()) {
                InetAddress.getByName(host);
                return true;
            }
        }
        catch (UnknownHostException ex) {
            log.log(Level.SEVERE, "Not possible to resolve " + host + ", using fallback address...");
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        InetAddress[] all;
        String host = "tigase.im";
        if (args.length > 0) {
            host = args[0];
        }
        DNSResolverDefault dnsResolver = new DNSResolverDefault();
        Object[] hostIPs = dnsResolver.getHostIPs(host);
        Object[] dns_entries = dnsResolver.getHostSRV_Entries(host);
        System.out.println(host + ":getHostIP: " + dnsResolver.getHostIP(host));
        System.out.println(host + ":getHostIPs (" + hostIPs.length + "): " + Arrays.toString(hostIPs));
        System.out.println(host + ":getHostSRV_IP: " + dnsResolver.getHostSRV_IP(host));
        System.out.println(host + ":getHostSRV_Entries S2S: " + Arrays.toString(dns_entries));
        System.out.println("-------------------");
        for (InetAddress ia : all = InetAddress.getAllByName(host)) {
            System.out.println("Host:getAllByName: " + ia.toString());
        }
        System.out.println("-------------------");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes attrs = ctx.getAttributes("_xmpp-server._tcp." + host, new String[]{"SRV", "A"});
        String id = "SRV";
        Attribute att = attrs.get(id);
        if (att == null) {
            id = "A";
            att = attrs.get(id);
        }
        System.out.println(id + ": " + att.get(0));
        System.out.println("Class: " + att.get(0).getClass().getSimpleName());
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMoreElements()) {
            Attribute attr = ae.next();
            String attrId = attr.getID();
            NamingEnumeration<?> vals = attr.getAll();
            while (vals.hasMoreElements()) {
                System.out.println(attrId + ": " + vals.nextElement());
            }
        }
        ctx.close();
        System.out.println("-------------------");
        for (Object entry : dns_entries) {
            System.out.println(((DNSEntry)entry).toString());
        }
        System.out.println("-------------------");
        System.out.println("defaultHostname: " + defaultHost);
        System.out.println("-------------------");
        System.out.println("Localhost name: " + InetAddress.getLocalHost().getHostName());
        System.out.println("Localhost canonnical name: " + InetAddress.getLocalHost().getCanonicalHostName());
        System.out.println("Is local loopback: " + InetAddress.getLocalHost().isLoopbackAddress());
        for (String hostname : localnames) {
            for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                System.out.println("  ------   ");
                System.out.println("Host name: " + addr.getHostName());
                System.out.println("Host getCanonicalHostName(): " + addr.getCanonicalHostName());
                System.out.println("Host getHostAddress(): " + addr.getHostAddress());
                System.out.println("Is isLoopbackAddress()  : " + addr.isLoopbackAddress());
                System.out.println("Is isAnyLocalAddress()  : " + addr.isAnyLocalAddress());
                System.out.println("Is isLinkLocalAddress() : " + addr.isLinkLocalAddress());
                System.out.println("Is isSiteLocalAddress() : " + addr.isSiteLocalAddress());
            }
        }
    }

    protected DNSResolverDefault() {
        long start = System.currentTimeMillis();
        Security.setProperty("networkaddress.cache.ttl", "0");
        ip_cache.put(LOCALHOST, new DNSEntry(LOCALHOST, "127.0.0.1"));
        this.setPrimaryHost(System.getProperty("tigase-primary-address"));
        this.setSecondaryHost(System.getProperty("tigase-secondary-address"));
        try {
            String newHostName = InetAddress.getLocalHost().getCanonicalHostName().toLowerCase();
            if (newHostName.equalsIgnoreCase(InetAddress.getLocalHost().getHostAddress())) {
                newHostName = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            if (!LOCALHOST.equals(newHostName)) {
                localnames = new String[2];
                DNSResolverDefault.localnames[0] = newHostName;
                DNSResolverDefault.localnames[1] = LOCALHOST;
                InetAddress[] all = InetAddress.getAllByName(localnames[0]);
                ip_cache.put(localnames[0], new DNSEntry(localnames[0], all[0].getHostAddress().toLowerCase()));
            } else {
                localnames = new String[]{LOCALHOST};
            }
            for (String hostname : localnames) {
                InetAddress[] all;
                for (InetAddress addr : all = InetAddress.getAllByName(hostname)) {
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress() || !(defaultHost = addr.getCanonicalHostName().toLowerCase()).equalsIgnoreCase(addr.getHostAddress())) continue;
                    defaultHost = addr.getHostName();
                }
            }
            if (defaultHost == null) {
                defaultHost = localnames[0];
            }
        }
        catch (UnknownHostException e) {
            localnames = new String[]{LOCALHOST};
            defaultHost = LOCALHOST;
            log.log(Level.SEVERE, "Retrieval of default hostnames failed! Most likely network misconfiguration problem,make sure the local hostname to whichever it is set does resolve to IP address,fallback to: " + defaultHost, e);
        }
        new Thread("OpenDNS checker"){

            @Override
            public void run() {
                try {
                    opendns_hit_nxdomain_ip = InetAddress.getByName(DNSResolverDefault.OPEN_DNS_HIT_NXDOMAIN).getHostAddress();
                }
                catch (UnknownHostException e) {
                    opendns_hit_nxdomain_ip = null;
                }
            }
        }.start();
        resolveDefaultTime = System.currentTimeMillis() - start;
        if (resolveDefaultTime > 0L) {
            log.log(Level.WARNING, "Resolving default host name: {0} took: {1}", new Object[]{defaultHost, resolveDefaultTime});
        }
    }

    @Override
    public String[] getDefaultHosts() {
        return localnames != null ? Arrays.copyOf(localnames, localnames.length) : null;
    }

    @Override
    public String getDefaultHost() {
        if (primaryHost == null) {
            return defaultHost;
        }
        return primaryHost;
    }

    public String getPrimaryHost() {
        return primaryHost;
    }

    public void setPrimaryHost(String tigasePrimaryHost) {
        if (DNSResolverDefault.isHostValid(tigasePrimaryHost)) {
            primaryHost = tigasePrimaryHost;
            log.log(Level.WARNING, "Explicit configuring default hostname: {0}", new Object[]{this.getDefaultHost()});
        } else {
            primaryHost = defaultHost;
        }
    }

    @Override
    public String getSecondaryHost() {
        if (secondaryHost == null) {
            return this.getDefaultHost();
        }
        return secondaryHost;
    }

    public void setSecondaryHost(String tigaseSecondaryHost) {
        secondaryHost = DNSResolverDefault.isHostValid(tigaseSecondaryHost) ? tigaseSecondaryHost : null;
    }

    @Override
    public String[] getHostIPs(String hostname) throws UnknownHostException {
        DNSEntry cache_res = ip_cache.get(hostname);
        if (cache_res != null) {
            return cache_res.getIps();
        }
        InetAddress[] all = InetAddress.getAllByName(hostname);
        String[] ip_addresses = new String[all.length];
        for (int j = 0; j < all.length; ++j) {
            ip_addresses[j] = all[j].getHostAddress();
            if (!ip_addresses[j].equals(opendns_hit_nxdomain_ip)) continue;
            throw new UnknownHostException("OpenDNS NXDOMAIN");
        }
        ip_cache.put(hostname, new DNSEntry(hostname, ip_addresses));
        return ip_addresses;
    }

    @Override
    public DNSEntry[] getHostSRV_Entries(String hostname, String service, int defPort) throws UnknownHostException {
        String key = service + "." + hostname;
        DNSEntry[] cache_res = srv_cache.get(key);
        if (cache_res != null) {
            return cache_res;
        }
        cache_res = DNSResolverIfc.super.getHostSRV_Entries(hostname, service, defPort);
        if (cache_res != null) {
            srv_cache.put(key, cache_res);
        }
        return cache_res;
    }
}

