/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.OfflineMessages;
import tigase.xmpp.jid.JID;

@Bean(name="amp", parent=SessionManager.class, active=true)
public class MessageAmp
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPPostprocessorIfc,
XMPPPreprocessorIfc,
XMPPProcessorIfc,
RegistrarBean {
    protected static final String ID = "amp";
    private static final String AMP_JID_PROP_KEY = "amp-jid";
    private static final String STATUS_ATTRIBUTE_NAME = "status";
    private static final String[][] ELEMENTS = new String[][]{{"message"}, {"presence"}, {"iq", "msgoffline"}};
    private static final Logger log = Logger.getLogger(MessageAmp.class.getName());
    private static final String XMLNS = "http://jabber.org/protocol/amp";
    private static final String[] XMLNSS = new String[]{"jabber:client", "jabber:client", "msgoffline"};
    private static final Element[] DISCO_FEATURES_WITH_OFFLINE = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"}), new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private static final Element[] DISCO_FEATURES_WITHOUT_OFFLINE = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/amp"})};
    private static String defHost = DNSResolverFactory.getInstance().getDefaultHost();
    @ConfigField(desc="AMP component JID", alias="amp-jid")
    private JID ampJID = JID.jidInstanceNS((String)("amp@" + defHost));
    @Inject(nullAllowed=true)
    private Message messageProcessor;
    @Inject
    private MsgRepositoryIfc msg_repo = null;
    @Inject(nullAllowed=true)
    private OfflineMessages offlineProcessor;
    @ConfigField(desc="", alias="quota-exceeded")
    private QuotaRule quotaExceededRule = QuotaRule.error;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        C2SDeliveryErrorProcessor.filter(packet, session, repo, results, this.ampJID);
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (this.offlineProcessor != null && (session == null || packet.getElemName() == "message" && !this.messageProcessor.hasConnectionForMessageDelivery(session))) {
            if (packet.getElemName() == "message" && packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
                return;
            }
            Element amp = packet.getElement().getChild(ID);
            if (amp == null || amp.getXMLNS() != XMLNS) {
                try {
                    if (!(session == null || packet.getStanzaTo() == null || packet.getStanzaTo().getLocalpart() != null && session.isUserId(packet.getStanzaTo().getBareJID()))) {
                        return;
                    }
                    Authorization saveResult = this.offlineProcessor.savePacketForOffLineUser(packet, this.msg_repo, repo);
                    Packet result = null;
                    this.offlineProcessor.notifyNewOfflineMessage(packet, session, results, settings);
                    block1 : switch (saveResult) {
                        case SERVICE_UNAVAILABLE: {
                            switch (this.quotaExceededRule) {
                                case error: {
                                    result = saveResult.getResponseMessage(packet, "Offline messages queue is full", true);
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                    if (result != null) {
                        results.offer(result);
                    }
                }
                catch (UserNotFoundException ex) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                    }
                }
                catch (NotAuthorizedException ex) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "NotAuthorizedException when checking if message is to this user at trying to save packet for off-line user, {0}, {1}", new Object[]{packet, session});
                    }
                }
                catch (PacketErrorTypeException ex) {
                    log.log(Level.FINE, "Could not sent error to packet sent to offline user which storage to offline store failed. Packet is error type already: {0}", packet.toStringSecure());
                }
            }
        }
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        boolean processed = C2SDeliveryErrorProcessor.preProcess(packet, session, repo, results, settings, this.messageProcessor);
        if (processed && packet.getPacketFrom() != null && packet.getPacketFrom().getLocalpart().equals(this.ampJID.getLocalpart())) {
            processed = false;
        }
        if (processed) {
            packet.processedBy(ID);
        } else if (packet.getElemName() == "message") {
            Element amp = packet.getElement().getChild(ID, XMLNS);
            if (amp == null || amp.getAttributeStaticStr(STATUS_ATTRIBUTE_NAME) != null || this.ampJID.equals((Object)packet.getPacketFrom())) {
                return false;
            }
            try {
                if (session == null) {
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ampJID);
                    results.offer(result);
                    result.getElement().addAttribute("offline", "1");
                    packet.processedBy(ID);
                    return true;
                }
                if (session.isUserId(packet.getStanzaTo().getBareJID()) && session.getjid() != null && session.getjid().equals((Object)packet.getStanzaTo())) {
                    boolean offline;
                    Packet result = packet.copyElementOnly();
                    result.setPacketTo(this.ampJID);
                    if (packet.getStanzaTo().getResource() != null) {
                        result.getElement().addAttribute("to-res", session.getResource());
                    }
                    results.offer(result);
                    boolean bl = offline = !this.messageProcessor.hasConnectionForMessageDelivery(session);
                    if (offline) {
                        result.getElement().addAttribute("offline", "1");
                    }
                    packet.processedBy(ID);
                    return true;
                }
                return false;
            }
            catch (XMPPException ex) {
                log.log(Level.SEVERE, "this should not happen", ex);
            }
        }
        return processed;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        switch (packet.getElemName()) {
            case "presence": {
                if (this.offlineProcessor == null || !this.offlineProcessor.loadOfflineMessages(packet, session)) break;
                try {
                    Queue<Packet> packets = this.offlineProcessor.restorePacketForOffLineUser(session, this.msg_repo);
                    if (packets != null) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Sending off-line messages: " + packets.size());
                        }
                        results.addAll(packets);
                        if (!packets.isEmpty()) {
                            this.offlineProcessor.notifyOfflineMessagesRetrieved(session, results);
                        }
                    }
                }
                catch (UserNotFoundException e) {
                    log.info("Something wrong, DB problem, cannot load offline messages. " + e);
                }
                if (packet.getStanzaTo() != null) break;
                Packet notification = packet.copyElementOnly();
                notification.initVars(session.getJID(), this.ampJID);
                results.offer(notification);
                break;
            }
            case "message": {
                Element amp = packet.getElement().getChild(ID, XMLNS);
                if (amp == null || amp.getAttributeStaticStr(STATUS_ATTRIBUTE_NAME) != null || packet.getPacketFrom() != null && this.ampJID.getLocalpart().equals(packet.getPacketFrom().getLocalpart())) {
                    this.messageProcessor.process(packet, session, repo, results, settings);
                    break;
                }
                JID connectionId = session.getConnectionId();
                Packet result = packet.copyElementOnly();
                if (connectionId.equals((Object)packet.getPacketFrom())) {
                    result.getElement().addAttribute("from-conn-id", connectionId.toString());
                    if (null != session.getBareJID()) {
                        result.getElement().addAttribute("from-session-jid", session.getJID().toString());
                    }
                }
                result.setPacketTo(this.ampJID);
                results.offer(result);
                break;
            }
            case "iq": {
                if (this.offlineProcessor != null) {
                    this.offlineProcessor.processIq(packet, session, repo, results);
                    break;
                }
                results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, ID, true));
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return this.offlineProcessor == null ? DISCO_FEATURES_WITHOUT_OFFLINE : DISCO_FEATURES_WITH_OFFLINE;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void register(Kernel kernel) {
        kernel.registerBean(Message.class).setActive(true).exec();
        kernel.registerBean(OfflineMessages.class).setActive(true).exec();
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    private static enum QuotaRule {
        error,
        drop;


        public static QuotaRule valueof(String name) {
            try {
                if (name != null) {
                    return QuotaRule.valueOf(name);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return error;
        }
    }
}

