/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cert.CertCheckResult;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.net.ConnectionType;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.util.Algorithms;
import tigase.util.common.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="dialback", parent=S2SConnectionManager.class, active=true)
public class Dialback
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(Dialback.class.getName());
    private static final Element features_required = new Element("dialback", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:xmpp:features:dialback"});
    private static final Element features = new Element("dialback", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:dialback"});
    private static final String REQUESTED_RESULT_DOMAINS_KEY = "requested-result-domains-key";
    @ConfigField(desc="Authentication timeout for S2S connections")
    private long authenticationTimeOut = 30L;
    @ConfigField(desc="Workaround for TLS dialback issue in Ejabberd", alias="ejabberd-bug-workaround")
    private boolean ejabberd_bug_workaround_active = true;

    @Override
    public int order() {
        return S2SAbstractProcessor.Order.Dialback.ordinal();
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        boolean skipTLS;
        CID cid = (CID)serv.getSessionData().get("cid");
        boolean bl = skipTLS = cid == null ? false : this.skipTLSForHost(cid.getRemoteHost());
        if (p.getXMLNS() == "jabber:server:dialback") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Processing dialback packet: {1}", new Object[]{serv, p});
            }
            this.processDialback(p, serv);
            return true;
        }
        if (p.isElement("features", "http://etherx.jabber.org/streams")) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Stream features received packet: {1}", new Object[]{serv, p});
            }
            CertCheckResult certCheckResult = (CertCheckResult)serv.getSessionData().get("cert-check-result");
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, TLS Certificate check: {1}, packet: {2}", new Object[]{serv, certCheckResult, p});
            }
            if (p.isXMLNSStaticStr(FEATURES_STARTTLS_PATH, "urn:ietf:params:xml:ns:xmpp-tls") && certCheckResult == null && !skipTLS) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, Waiting for starttls, packet: {1}", new Object[]{serv, p});
                }
                return true;
            }
            if (certCheckResult == CertCheckResult.trusted && !p.isXMLNSStaticStr(FEATURES_DIALBACK_PATH, "urn:xmpp:features:dialback")) {
                if (this.ejabberd_bug_workaround_active) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Ejabberd bug workaround active, proceeding to dialback anyway, packet: {1}", new Object[]{serv, p});
                    }
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, TLS trusted peer, no dialback needed or requested, packet: {1}", new Object[]{serv, p});
                    }
                    try {
                        CIDConnections cid_conns = this.handler.getCIDConnections(cid, true);
                        cid_conns.connectionAuthenticated(serv, cid);
                    }
                    catch (NotLocalhostException ex) {
                        log.log(Level.INFO, "{0}, Incorrect local hostname, packet: {1}", new Object[]{serv, p});
                        serv.forceStop();
                    }
                    catch (LocalhostException ex) {
                        log.log(Level.INFO, "{0}, Incorrect remote hostname name, packet: {1}", new Object[]{serv, p});
                        serv.stop();
                    }
                    return true;
                }
            }
            if (!skipTLS && cid != null && !serv.getSessionData().containsKey("TLS") && this.handler.isTlsRequired(cid.getLocalHost())) {
                log.log(Level.FINER, "{0}, TLS is required for domain {1} but STARTTLS was not offered by {2} - policy-violation", new Object[]{serv, cid.getLocalHost(), cid.getRemoteHost()});
                serv.forceStop();
                return true;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Initializing dialback, packet: {1}", new Object[]{serv, p});
            }
            this.initDialback(serv, serv.getSessionId());
        }
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
        this.handler.addTimerTask(new AuthenticationTimer(serv), this.authenticationTimeOut, TimeUnit.SECONDS);
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
        CertCheckResult certCheckResult = (CertCheckResult)serv.getSessionData().get("cert-check-result");
        if (certCheckResult == CertCheckResult.trusted) {
            results.add(features);
        } else {
            results.add(features_required);
        }
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (attribs.containsKey("version")) {
            return null;
        }
        switch (serv.connectionType()) {
            case connect: {
                this.initDialback(serv, attribs.get("id"));
                break;
            }
        }
        return null;
    }

    protected boolean wasResultRequested(S2SIOService serv, String domain) {
        Set requested = (Set)serv.getSessionData().get(REQUESTED_RESULT_DOMAINS_KEY);
        return requested != null && requested.contains(domain);
    }

    protected boolean wasVerifyRequested(S2SIOService serv, String domain) {
        String requested = (String)serv.getSessionData().get("handshaking-domain-key");
        return requested != null && requested.contains(domain);
    }

    private void initDialback(S2SIOService serv, String remote_id) {
        try {
            CID cid = (CID)serv.getSessionData().get("cid");
            String secret = this.handler.getSecretForDomain(cid.getLocalHost());
            String key = Algorithms.generateDialbackKey((String)cid.getLocalHost(), (String)cid.getRemoteHost(), (String)secret, (String)remote_id);
            if (!serv.isHandshakingOnly()) {
                Element elem = new Element("db:result", key, new String[]{"xmlns:db"}, new String[]{"jabber:server:dialback"});
                this.addToResultRequested(serv, cid.getRemoteHost());
                serv.getS2SConnection().addControlPacket(Packet.packetInstance(elem, JID.jidInstanceNS((String)cid.getLocalHost()), JID.jidInstanceNS((String)cid.getRemoteHost())));
            }
            serv.getS2SConnection().sendAllControlPackets();
        }
        catch (NotLocalhostException ex) {
            this.generateStreamError(false, "host-unknown", serv);
        }
    }

    private void processDialback(Packet p, S2SIOService serv) {
        CID cid_main = (CID)serv.getSessionData().get("cid");
        CID cid_packet = new CID(p.getStanzaTo().getDomain(), p.getStanzaFrom().getDomain());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, DIALBACK packet: {1}, CID_packet: {2}", new Object[]{serv, p, cid_packet});
        }
        CIDConnections cid_conns = null;
        if (cid_main == null) {
            cid_main = cid_packet;
            serv.getSessionData().put("cid", cid_main);
            serv.getSessionData().put("local-hostname", cid_main.getLocalHost());
            serv.getSessionData().put("remote-hostname", cid_main.getRemoteHost());
        }
        try {
            cid_conns = this.handler.getCIDConnections(cid_main, true);
        }
        catch (NotLocalhostException ex) {
            log.log(Level.FINER, "{0} Incorrect local hostname: {1}", new Object[]{serv, p});
            this.generateStreamError(false, "host-unknown", serv);
            return;
        }
        catch (LocalhostException ex) {
            log.log(Level.FINER, "{0} Incorrect remote hostname: {1}", new Object[]{serv, p});
            this.generateStreamError(false, "invalid-from", serv);
            return;
        }
        if (serv.connectionType() == ConnectionType.accept) {
            cid_conns.addIncoming(serv);
        }
        String remote_key = p.getElemCData();
        if (p.getElemName() == "result" || p.getElemName() == "db:result") {
            if (p.getType() == null) {
                CID cid = (CID)serv.getSessionData().get("cid");
                boolean skipTls = this.skipTLSForHost(cid.getRemoteHost());
                if (!skipTls && !serv.getSessionData().containsKey("TLS") && this.handler.isTlsRequired(cid.getLocalHost())) {
                    log.log(Level.FINER, "{0}, rejecting S2S connection from {1} to {2} due to policy violation - STARTTLS is required", new Object[]{serv, cid.getRemoteHost(), cid.getLocalHost()});
                    this.handler.sendVerifyResult("db:result", cid_main, cid_packet, false, null, serv.getSessionId(), null, false, new Element("error", new Element[]{new Element("policy-violation", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"})}, new String[]{"type"}, new String[]{"cancel"}));
                } else {
                    String conn_sessionId = serv.getSessionId();
                    this.handler.sendVerifyResult("db:verify", cid_main, cid_packet, null, conn_sessionId, null, p.getElemCData(), true);
                }
            } else if (p.getType() == StanzaType.valid) {
                if (this.wasResultRequested(serv, p.getStanzaFrom().toString())) {
                    cid_conns.connectionAuthenticated(serv, cid_packet);
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Received result with type valid for {0} but it was not requested!", p.getStanzaFrom());
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Invalid result for DB authentication: {0}, stopping connection: {1}", new Object[]{cid_packet, serv});
                }
                serv.stop();
            }
        }
        if (p.getElemName() == "verify" || p.getElemName() == "db:verify") {
            if (p.getType() == null) {
                boolean result;
                try {
                    String secret = this.handler.getSecretForDomain(cid_packet.getLocalHost());
                    String local_key = Algorithms.generateDialbackKey((String)cid_packet.getLocalHost(), (String)cid_packet.getRemoteHost(), (String)secret, (String)p.getStanzaId());
                    if (local_key == null && log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "The key is not available for connection CID: {0}, or the packet CID: {1} ", new Object[]{cid_main, cid_packet});
                    }
                    result = local_key != null && local_key.equals(remote_key);
                }
                catch (NotLocalhostException ex) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Could not retreive secret for " + cid_packet.getLocalHost(), ex);
                    }
                    result = false;
                }
                this.handler.sendVerifyResult("db:verify", cid_main, cid_packet, result, p.getStanzaId(), serv.getSessionId(), null, false);
            } else {
                if (this.wasVerifyRequested(serv, p.getStanzaFrom().toString())) {
                    this.handler.sendVerifyResult("db:result", cid_main, cid_packet, p.getType() == StanzaType.valid, null, p.getStanzaId(), null, false);
                    if (p.getType() == StanzaType.valid) {
                        cid_conns.connectionAuthenticated(p.getStanzaId(), cid_packet);
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "received verify for {0} but it was not requested!", p.getStanzaFrom());
                }
                if (serv.isHandshakingOnly()) {
                    serv.stop();
                }
            }
        }
    }

    private void addToResultRequested(S2SIOService serv, String domain) {
        Set<String> requested = (CopyOnWriteArraySet<String>)serv.getSessionData().get(REQUESTED_RESULT_DOMAINS_KEY);
        if (requested == null) {
            CopyOnWriteArraySet<String> requested_tmp = new CopyOnWriteArraySet<String>();
            requested = serv.getSessionData().putIfAbsent(REQUESTED_RESULT_DOMAINS_KEY, requested_tmp);
            if (requested == null) {
                requested = requested_tmp;
            }
        }
        requested.add(domain);
    }

    private class AuthenticationTimer
    extends TimerTask {
        private S2SIOService serv = null;

        private AuthenticationTimer(S2SIOService serv) {
            this.serv = serv;
        }

        @Override
        public void run() {
            if (!this.serv.isAuthenticated() && this.serv.isConnected()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Connection not authenticated within timeout, stopping: {0}", this.serv);
                }
                this.serv.stop();
            }
        }
    }
}

