/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.filters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.QueueType;
import tigase.stats.StatisticsList;

public class PacketCounter
implements PacketFilterIfc {
    private static final String DETAILED_OTHER_STATISTICS_KEY = "detailed-other-statistics";
    private final TypeCounter iqCounter = new TypeCounter("IQ");
    private final Map<String, TypeCounter> otherCounters = new ConcurrentHashMap<String, TypeCounter>();
    private long clusterCounter = 0L;
    private boolean detailedOtherStat = true;
    private long msgCounter = 0L;
    private String name = null;
    private long otherCounter = 0L;
    private long presCounter = 0L;
    private QueueType qType = null;
    private long total = 0L;

    public PacketCounter() {
        String tmp = System.getProperty(DETAILED_OTHER_STATISTICS_KEY);
        if (null != tmp) {
            this.detailedOtherStat = Boolean.valueOf(tmp);
        }
    }

    public PacketCounter(boolean detailedOtherStat) {
        this.detailedOtherStat = detailedOtherStat;
    }

    @Override
    public Packet filter(Packet packet) {
        ++this.total;
        String elemName = packet.getElemName();
        if (elemName == "message") {
            ++this.msgCounter;
        } else if (elemName == "presence") {
            ++this.presCounter;
        } else if (elemName == "cluster") {
            ++this.clusterCounter;
        } else if (elemName == "iq") {
            String xmlns = ((Iq)packet).getIQXMLNS();
            this.iqCounter.incrementCounter(xmlns != null ? xmlns : ((Iq)packet).getIQChildName());
        } else {
            ++this.otherCounter;
            if (this.detailedOtherStat) {
                String xmlns = packet.getXMLNS() != null ? packet.getXMLNS() : "no XMLNS";
                String element = elemName;
                TypeCounter counter = this.otherCounters.get(xmlns);
                if (counter == null) {
                    counter = new TypeCounter("other " + xmlns);
                    this.otherCounters.put(xmlns, counter);
                }
                counter.incrementCounter(element);
            }
        }
        return packet;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.name, this.qType.name() + " processed", this.total, Level.FINER);
        list.add(this.name, this.qType.name() + " processed messages", this.msgCounter, Level.FINER);
        list.add(this.name, this.qType.name() + " processed presences", this.presCounter, Level.FINER);
        list.add(this.name, this.qType.name() + " processed cluster", this.clusterCounter, Level.FINER);
        list.add(this.name, this.qType.name() + " processed other", this.otherCounter, Level.FINER);
        this.iqCounter.getStatistics(list, Level.FINER);
        Level finer = Level.FINER;
        if (this.detailedOtherStat & list.checkLevel(finer)) {
            this.otherCounters.values().forEach(typeCounter -> typeCounter.getStatistics(list, finer));
        }
    }

    @Override
    public void init(String name, QueueType qType) {
        this.name = name;
        this.qType = qType;
    }

    private class TypeCounter {
        private final Map<String, MutableLong> counter = new ConcurrentHashMap<String, MutableLong>();
        private final String counterName;
        private final MutableLong total = new MutableLong();
        private final MutableLong withoutValue = new MutableLong();

        public TypeCounter(String name) {
            this.counterName = name;
        }

        public Map<String, MutableLong> getCounter() {
            return this.counter;
        }

        public void getStatistics(StatisticsList list) {
            this.getStatistics(list, Level.FINEST);
        }

        public void getStatistics(StatisticsList list, Level level) {
            list.add(PacketCounter.this.name, PacketCounter.this.qType.name() + " processed " + this.counterName, this.total.get(), level);
            if (this.withoutValue.get() > 0L) {
                list.add(PacketCounter.this.name, PacketCounter.this.qType.name() + " processed " + this.counterName + " no XMLNS", this.withoutValue.get(), level);
            }
            for (Map.Entry<String, MutableLong> xmlnsValues : this.counter.entrySet()) {
                list.add(PacketCounter.this.name, PacketCounter.this.qType.name() + " processed " + this.counterName + " " + xmlnsValues.getKey(), xmlnsValues.getValue().get(), level);
            }
        }

        public long getTotal() {
            return this.total.get();
        }

        public synchronized void incrementCounter(String param) {
            this.total.increment();
            if (param == null) {
                this.withoutValue.increment();
            } else {
                MutableLong count = this.counter.get(param);
                if (count == null) {
                    count = new MutableLong();
                    this.counter.put(param, count);
                }
                count.increment();
            }
        }
    }

    private class MutableLong {
        long value = 0L;

        private MutableLong() {
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        private long get() {
            return this.value;
        }

        private void increment() {
            ++this.value;
        }
    }
}

