/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.HashSet;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

@Bean(name="load-checker-task", parent=MonitorComponent.class, active=true)
public class LoadCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask,
Initializable {
    public static final String MONITOR_EVENT_NAME = "tigase.monitor.tasks.LoadAverageMonitorEvent";
    private static final TimestampHelper dtf = new TimestampHelper();
    private final HashSet<String> triggeredEvents = new HashSet();
    @ConfigField(desc="Average Load Threshold")
    private long averageLoadThreshold = 10L;
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @Inject
    private MonitorRuntime runtime;

    public long getAverageLoadThreshold() {
        return this.averageLoadThreshold;
    }

    public void setAverageLoadThreshold(Long averageLoadThreshold) {
        this.averageLoadThreshold = averageLoadThreshold;
    }

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle((String)"averageLoadThreshold", (String)String.valueOf(this.averageLoadThreshold), (String)"Alarm when AverageLoad is bigger than"));
        return form;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Load Information", "");
        result.addField(Field.fieldTextSingle((String)"averageLoad", (String)Double.toString(this.runtime.getLoadAverage()), (String)"Load Average"));
        return result;
    }

    @Override
    public void initialize() {
        this.eventBus.registerEvent(MONITOR_EVENT_NAME, "Fired when load is too high", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field tmp = form.get("averageLoadThreshold");
        if (tmp != null) {
            this.averageLoadThreshold = Long.parseLong(tmp.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        double curAverageLoad = this.runtime.getLoadAverage();
        if (curAverageLoad >= (double)this.averageLoadThreshold) {
            Element event = new Element(MONITOR_EVENT_NAME);
            event.addChild((XMLNodeIfc)new Element("timestamp", "" + dtf.format(new Date())));
            event.addChild((XMLNodeIfc)new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild((XMLNodeIfc)new Element("averageLoad", Double.toString(curAverageLoad)));
            event.addChild((XMLNodeIfc)new Element("message", "Average Load is higher than " + this.averageLoadThreshold + " and it is equals " + Double.toString(curAverageLoad)));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(MONITOR_EVENT_NAME);
        }
    }
}

