/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.MonitorComponent;
import tigase.monitor.MonitorTask;
import tigase.monitor.TasksScriptRegistrar;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="x-delete-task", parent=MonitorComponent.class, active=true)
public class DeleteScriptTaskCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(DeleteScriptTaskCommand.class.getName());
    @Inject
    private MonitorComponent component;
    @Inject
    private Kernel kernel;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("form", "Delete monitor task", null);
                Collection<String> taskNames = this.kernel.getNamesOf(MonitorTask.class);
                form.addField(Field.fieldListSingle((String)"delete_task", (String)"", (String)"Task to delete", (String[])taskNames.toArray(new String[0]), (String[])taskNames.toArray(new String[0])));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    String taskName = form.getAsString("delete_task");
                    Object i = this.kernel.getInstance(taskName);
                    if (i instanceof MonitorTask) {
                        ((TasksScriptRegistrar)this.kernel.getInstance("TasksScriptRegistrar")).delete(taskName);
                    } else {
                        throw new RuntimeException("Are you kidding me?");
                    }
                }
                form = new Form("form", "Completed", null);
                form.addField(Field.fieldFixed((String)"Script removed"));
                response.getElements().add(form.getElement());
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Error executing script", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Delete monitor task";
    }

    @Override
    public String getNode() {
        return "x-delete-task";
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

