/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.nio.ByteOrder;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.io.CertificateContainer;
import tigase.io.CertificateContainerIfc;
import tigase.io.IOInterface;
import tigase.io.JcaTLSWrapper;
import tigase.io.SSLContextContainerAbstract;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSIO;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.server.ConnectionManager;

@Bean(name="sslContextContainer", parent=ConnectionManager.class, active=true)
public class SSLContextContainer
extends SSLContextContainerAbstract {
    private static final String[] TLS_WORKAROUND_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
    private static final String[] HARDENED_MODE_FORBIDDEN_CIPHERS = new String[]{"TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5"};
    private static final String[] HARDENED_MODE_PROTOCOLS = new String[]{"SSLv2Hello", "TLSv1", "TLSv1.1", "TLSv1.2"};
    private static final Logger log = Logger.getLogger(SSLContextContainer.class.getName());
    private static String[] HARDENED_MODE_CIPHERS;
    @Inject
    protected EventBus eventBus = EventBusFactory.getInstance();
    protected Map<String, SSLContextContainerAbstract.SSLHolder> sslContexts = new ConcurrentSkipListMap<String, SSLContextContainerAbstract.SSLHolder>();
    @ConfigField(desc="Enabled TLS/SSL ciphers", alias="tls-enabled-ciphers")
    private String[] enabledCiphers;
    @ConfigField(desc="Enabled TLS/SSL protocols", alias="tls-enabled-protocols")
    private String[] enabledProtocols;
    @ConfigField(desc="TLS/SSL hardened mode", alias="hardened-mode")
    private boolean hardenedMode = false;
    @Inject(bean="rootSslContextContainer", type=Root.class, nullAllowed=true)
    private SSLContextContainerIfc parent;
    @ConfigField(desc="TLS/SSL", alias="tls-jdk-nss-bug-workaround-active")
    private boolean tlsJdkNssBugWorkaround = false;

    private static String markEnabled(String[] enabled, String[] supported) {
        List<Object> en = enabled == null ? new ArrayList() : Arrays.asList(enabled);
        String result = "";
        if (supported != null) {
            for (int i = 0; i < supported.length; ++i) {
                String t = supported[i];
                result = result + (en.contains(t) ? "(+)" : "(-)");
                result = result + t;
                if (i + 1 >= supported.length) continue;
                result = result + ",";
            }
        }
        return result;
    }

    public SSLContextContainer() {
        this(null, null);
    }

    public SSLContextContainer(CertificateContainerIfc certContainer) {
        this(certContainer, null);
    }

    public SSLContextContainer(CertificateContainerIfc certContainer, SSLContextContainerIfc parent) {
        super(certContainer);
        this.parent = parent;
    }

    @Override
    public IOInterface createIoInterface(String protocol, String tls_hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth, ByteOrder byteOrder, TrustManager[] x509TrustManagers, TLSEventHandler eventHandler, IOInterface socketIO, CertificateContainerIfc certificateContainer) throws IOException {
        SSLContext sslContext = this.getSSLContext(protocol, tls_hostname, clientMode, x509TrustManagers);
        JcaTLSWrapper wrapper = new JcaTLSWrapper(sslContext, eventHandler, tls_hostname, port, clientMode, wantClientAuth, needClientAuth, this.getEnabledCiphers(), this.getEnabledProtocols());
        return new TLSIO(socketIO, wrapper, byteOrder);
    }

    @Override
    public String[] getEnabledCiphers() {
        if (this.enabledCiphers != null && this.enabledCiphers.length != 0) {
            return this.enabledCiphers;
        }
        if (this.hardenedMode) {
            return HARDENED_MODE_CIPHERS;
        }
        if (this.tlsJdkNssBugWorkaround) {
            return TLS_WORKAROUND_CIPHERS;
        }
        return null;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled ciphers: " + (enabledCiphers == null ? "default" : Arrays.toString(enabledCiphers)));
        }
        this.enabledCiphers = enabledCiphers;
    }

    @Override
    public String[] getEnabledProtocols() {
        if (this.enabledProtocols != null && this.enabledProtocols.length != 0) {
            return this.enabledProtocols;
        }
        if (this.hardenedMode) {
            return HARDENED_MODE_PROTOCOLS;
        }
        return null;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Enabled protocols: " + (enabledProtocols == null ? "default" : Arrays.toString(enabledProtocols)));
        }
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode, TrustManager[] tms) {
        SSLContextContainerAbstract.SSLHolder holder = null;
        String alias = hostname;
        try {
            if (tms == null) {
                if (this.parent != null) {
                    return this.parent.getSSLContext(protocol, hostname, clientMode, tms);
                }
                tms = this.getTrustManagers();
            }
            if (alias == null) {
                alias = this.getDefCertAlias();
            }
            if (!this.validateDomainCertificate(holder = SSLContextContainer.find(this.sslContexts, alias), alias)) {
                holder = null;
            }
            if (holder == null || !holder.isValid(tms)) {
                holder = this.createContextHolder(protocol, hostname, alias, clientMode, tms);
                if (clientMode) {
                    return holder.sslContext;
                }
                if (!this.validateDomainCertificate(holder, alias)) {
                    holder = this.createContextHolder(protocol, hostname, alias, clientMode, tms);
                }
                this.sslContexts.put(alias, holder);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not initialize SSLContext for domain: " + alias + ", protocol: " + protocol, e);
            holder = null;
        }
        return holder != null ? holder.getSSLContext() : null;
    }

    @Override
    public KeyStore getTrustStore() {
        KeyStore trustStore = super.getTrustStore();
        if (trustStore == null && this.parent != null) {
            trustStore = this.parent.getTrustStore();
        }
        return trustStore;
    }

    private void invalidateContextHolder(SSLContextContainerAbstract.SSLHolder holder, String alias) throws Exception {
        this.sslContexts.remove(alias);
        this.createCertificate(alias);
    }

    @HandleEvent
    private void onCertificateChange(CertificateContainer.CertificateChanged event) {
        String alias = event.getAlias();
        this.sslContexts.remove(alias);
    }

    public void setHardenedMode(boolean hardenedMode) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Hardened mode is " + (hardenedMode ? "enabled" : "disabled"));
        }
        if (hardenedMode) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        }
        this.hardenedMode = hardenedMode;
    }

    public void setParent(SSLContextContainerIfc parent) {
        log.log(Level.FINE, "setting root = " + parent);
        this.parent = parent;
    }

    public void setTlsJdkNssBugWorkaround(boolean value) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Workaround for TLS/SSL bug is " + (value ? "enabled" : "disabled"));
        }
        this.tlsJdkNssBugWorkaround = value;
    }

    @Override
    public void start() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll(this);
    }

    private boolean validateDomainCertificate(SSLContextContainerAbstract.SSLHolder holder, String alias) throws Exception {
        if (holder != null && holder.domainCertificate != null && holder.domainCertificate.getIssuerDN().equals(holder.domainCertificate.getSubjectDN())) {
            try {
                holder.domainCertificate.checkValidity();
            }
            catch (CertificateException e) {
                this.invalidateContextHolder(holder, alias);
                return false;
            }
        }
        return true;
    }

    static {
        String[] allEnabledCiphers = null;
        try {
            SSLEngine tmpE = SSLContext.getDefault().createSSLEngine();
            allEnabledCiphers = tmpE.getEnabledCipherSuites();
            log.config("Supported protocols: " + SSLContextContainer.markEnabled(tmpE.getEnabledProtocols(), tmpE.getSupportedProtocols()));
            log.config("Supported ciphers: " + SSLContextContainer.markEnabled(allEnabledCiphers, tmpE.getSupportedCipherSuites()));
            ArrayList<String> ciphers = new ArrayList<String>(Arrays.asList(allEnabledCiphers));
            ciphers.removeAll(Arrays.asList(HARDENED_MODE_FORBIDDEN_CIPHERS));
            HARDENED_MODE_CIPHERS = ciphers.toArray(new String[0]);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Can't determine supported protocols", e);
        }
    }

    @Bean(name="rootSslContextContainer", parent=Kernel.class, active=true, exportable=true)
    public static class Root
    extends SSLContextContainer
    implements Initializable,
    UnregisterAware {
        @Override
        public void beforeUnregister() {
            this.stop();
        }

        @Override
        public void initialize() {
            this.start();
        }

        @Override
        public void setParent(SSLContextContainerIfc parent) {
            log.log(Level.FINE, "setting root = " + parent);
        }
    }
}

