/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.eventbus.EventListener;
import tigase.eventbus.component.AbstractEventBusModule;
import tigase.eventbus.component.ElemPathCriteria;
import tigase.eventbus.component.EventBusComponent;
import tigase.eventbus.component.stores.Affiliation;
import tigase.eventbus.component.stores.AffiliationStore;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.component.stores.SubscriptionStore;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.eventbus.impl.EventName;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

@Bean(name="subscribe", active=true)
public class SubscribeModule
extends AbstractEventBusModule
implements Initializable,
UnregisterAware {
    public static final String ID = "subscribe";
    private static final Criteria CRIT = new ElemPathCriteria(new String[]{"iq", "pubsub", "subscribe"}, new String[]{null, "http://jabber.org/protocol/pubsub", null});
    @Inject
    private AffiliationStore affiliationStore;
    @Inject
    private EventBusComponent component;
    private final EventListener<EventBusImplementation.ListenerAddedEvent> eventBusHandlerAddedHandler = new EventListener<EventBusImplementation.ListenerAddedEvent>(){

        @Override
        public void onEvent(EventBusImplementation.ListenerAddedEvent event) {
            if (!event.getPackageName().startsWith("tigase.eventbus")) {
                SubscribeModule.this.onAddHandler(event.getEventName(), event.getPackageName());
            }
        }
    };
    @Inject(nullAllowed=false, bean="localEventBus")
    private EventBusImplementation localEventBus;
    @Inject
    private SubscriptionStore subscriptionStore;

    @Override
    public void beforeUnregister() {
        this.localEventBus.removeListener(this.eventBusHandlerAddedHandler);
    }

    public void clusterNodeConnected(JID node) {
        if (this.component.getComponentId().equals((Object)node)) {
            return;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is connected. Preparing subscribe request.");
        }
        HashSet<Element> pubsubNodes = new HashSet<Element>();
        for (EventName eventName : this.localEventBus.getAllListenedEvents()) {
            pubsubNodes.add(this.prepareSubscribeElement(eventName, this.component.getComponentId(), null));
        }
        for (EventName eventName : this.subscriptionStore.getSubscribedEvents()) {
            Collection<Subscription> subscriptions = this.subscriptionStore.getSubscribersJIDs(eventName.getPackage(), eventName.getName());
            for (Subscription subscription : subscriptions) {
                if (subscription.getServiceJID() == null) continue;
                pubsubNodes.add(this.prepareSubscribeElement(eventName, subscription.getJid(), subscription.getServiceJID().toString()));
            }
        }
        if (!pubsubNodes.isEmpty()) {
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), pubsubNodes);
        }
    }

    public void clusterNodeDisconnected(JID node) {
        if (this.component.getComponentId().equals((Object)node)) {
            return;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Node " + node + " is disconnected.");
        }
        this.subscriptionStore.remove(new Subscription(JID.jidInstanceNS((String)"eventbus", (String)node.getDomain(), null)));
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#subscribe"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void initialize() {
        this.localEventBus.addListener(EventBusImplementation.ListenerAddedEvent.class, this.eventBusHandlerAddedHandler);
    }

    protected void onAddHandler(String eventName, String eventPackage) {
        for (JID node : this.component.getNodesConnected()) {
            if (this.component.getComponentId().equals((Object)node)) continue;
            Element se = this.prepareSubscribeElement(new EventName(eventPackage, eventName), this.component.getComponentId(), null);
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), Collections.singleton(se));
        }
    }

    private Element prepareSubscribeElement(EventName event, JID jid, String service) {
        Element subscribeElem = new Element(ID);
        subscribeElem.addAttribute("node", event.toString());
        subscribeElem.addAttribute("jid", jid.toString());
        if (service != null) {
            subscribeElem.addChild((XMLNodeIfc)new Element("service", service));
        }
        return subscribeElem;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getType() != StanzaType.set) {
            throw new ComponentException(Authorization.NOT_ALLOWED, "Only type set is allowed.");
        }
        this.processSet(packet);
    }

    protected Element processClusterSubscription(Packet packet) throws TigaseStringprepException {
        this.log.finest("Processing cluster subscription request from " + packet.getStanzaFrom());
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        for (Element subscribe : subscribeElements) {
            Element serviceItem = subscribe.getChild("service");
            EventName parsedName = new EventName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance((String)subscribe.getAttributeStaticStr("jid"));
            String service = serviceItem != null && serviceItem.getCData() != null ? serviceItem.getCData() : null;
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Node " + jid + " subscribed for events " + parsedName);
            }
            Subscription subscription = new Subscription(jid);
            subscription.setInClusterSubscription(true);
            subscription.setServiceJID(JID.jidInstanceNS((String)service));
            this.subscriptionStore.addSubscription(parsedName.getPackage(), parsedName.getName(), subscription);
            this.localEventBus.fire(new NewRemoteSubscriptionEvent(parsedName, subscription));
        }
        return null;
    }

    protected Element processNonClusterSubscription(Packet packet) throws TigaseStringprepException, ComponentException {
        Affiliation affiliation;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Processing noncluster subscription request from " + packet.getStanzaFrom());
        }
        if (!(affiliation = this.affiliationStore.getAffiliation(packet.getStanzaFrom())).isSubscribe()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Subscription rejected. Subscriber " + packet.getStanzaFrom() + " has bad affiliation: " + (Object)((Object)affiliation));
            }
            throw new ComponentException(Authorization.FORBIDDEN, "Bad affiliation: " + (Object)((Object)affiliation));
        }
        List<Element> subscribeElements = packet.getElemChildrenStaticStr(new String[]{"iq", "pubsub"});
        Element response = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        HashSet<Element> subscribedNodes = new HashSet<Element>();
        for (Element subscribe : subscribeElements) {
            EventName parsedName = new EventName(subscribe.getAttributeStaticStr("node"));
            JID jid = JID.jidInstance((String)subscribe.getAttributeStaticStr("jid"));
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Entity " + jid + " subscribed for events " + parsedName);
            }
            Subscription subscription = new Subscription(jid, packet.getStanzaTo());
            subscription.setInClusterSubscription(false);
            this.subscriptionStore.addSubscription(parsedName.getPackage(), parsedName.getName(), subscription);
            subscribedNodes.add(this.prepareSubscribeElement(parsedName, jid, packet.getStanzaTo().toString()));
            response.addChild((XMLNodeIfc)new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{parsedName.toString(), jid.toString(), "subscribed"}));
            this.localEventBus.fire(new NewRemoteSubscriptionEvent(parsedName, subscription));
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Forwarding subscription to: " + this.component.getNodesConnected());
        }
        for (JID node : this.component.getNodesConnected()) {
            if (this.component.getComponentId().equals((Object)node)) continue;
            this.sendSubscribeRequest("eventbus@" + node.getDomain(), subscribedNodes);
        }
        return response;
    }

    private void processSet(Packet packet) throws TigaseStringprepException, ComponentException {
        Element subscriptionResponse = this.isClusteredEventBus(packet.getStanzaFrom()) ? this.processClusterSubscription(packet) : this.processNonClusterSubscription(packet);
        Packet response = packet.okResult(subscriptionResponse, 0);
        response.setPermissions(Permissions.ADMIN);
        this.write(response);
    }

    protected void sendSubscribeRequest(final String to, Collection<Element> subscriptionElements) {
        try {
            String id = this.nextStanzaID();
            Element iq = new Element("iq", new String[]{"from", "to", "type", "id"}, new String[]{this.component.getComponentId().toString(), to, "set", id});
            Element pubsubElem = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            iq.addChild((XMLNodeIfc)pubsubElem);
            subscriptionElements.forEach(arg_0 -> ((Element)pubsubElem).addChild(arg_0));
            Packet packet = Packet.packetInstance(iq);
            packet.setPermissions(Permissions.ADMIN);
            packet.setXMLNS("jabber:client");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sending subscribe request (id=" + id + ") to node " + to);
            }
            this.write(packet, new AsyncCallback(){

                @Override
                public void onError(Packet responseStanza, String errorCondition) {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request was cancelled by node " + to + " with error " + errorCondition);
                    }
                }

                @Override
                public void onSuccess(Packet responseStanza) {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request was accepted by node " + to + ".");
                    }
                }

                @Override
                public void onTimeout() {
                    if (SubscribeModule.this.log.isLoggable(Level.FINE)) {
                        SubscribeModule.this.log.fine("Subscription request timeout. Node " + to + " not answered.");
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Why? Oh Why?", e);
        }
    }

    public static class NewRemoteSubscriptionEvent
    implements EventBusImplementation.InternalEventbusEvent {
        private final EventName parsedName;
        private Subscription subscription;

        public EventName getParsedName() {
            return this.parsedName;
        }

        public NewRemoteSubscriptionEvent(EventName parsedName, Subscription subscription) {
            this.parsedName = parsedName;
            this.subscription = subscription;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }
    }
}

