/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.UserRepositoryMDPoolBean;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.RegistrarBeanWithDefaultBeanClass;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;

public abstract class MDRepositoryBean<T extends DataSourceAware>
implements Initializable,
UnregisterAware,
RegistrarBeanWithDefaultBeanClass {
    private static final Logger log = Logger.getLogger(MDRepositoryBean.class.getCanonicalName());
    private final Map<String, T> repositories = new ConcurrentHashMap<String, T>();
    @ConfigField(desc="Map of aliases for data sources to use")
    protected ConcurrentHashMap<String, String> aliases = new ConcurrentHashMap();
    @ConfigField(desc="Create repositories for: every UserRepository, every data source, listed data sources")
    protected SelectorType dataSourceSelection = SelectorType.List;
    @Inject(nullAllowed=true)
    private MDRepositoryConfigBean[] configBeans;
    @Inject
    private DataSourceBean dataSourceBean;
    @Inject
    private EventBus eventBus;
    private Kernel kernel;
    @ConfigField(desc="Bean name")
    private String name;

    public String getName() {
        return this.name;
    }

    public void setDataSourceBean(DataSourceBean dataSourceBean) {
        HashMap<String, DataSource> oldDataSources = new HashMap<String, DataSource>();
        String defAlias = "default";
        if (this.dataSourceBean != null) {
            oldDataSources.put(defAlias, this.dataSourceBean.getRepository(defAlias));
            for (String domain : this.dataSourceBean.getDataSourceNames()) {
                oldDataSources.put(domain, this.dataSourceBean.getRepository(domain));
            }
        }
        this.dataSourceBean = dataSourceBean;
        if (this.dataSourceBean != null) {
            switch (this.dataSourceSelection) {
                case EveryDataSource: {
                    for (String name : dataSourceBean.getDataSourceNames()) {
                        this.registerIfNotExists(name);
                    }
                    break;
                }
                case EveryUserRepository: {
                    this.registerIfNotExists("default");
                    UserRepositoryMDPoolBean userRepositoryPool = this.kernel.getInstance(UserRepositoryMDPoolBean.class);
                    for (String name : userRepositoryPool.getDomainsList()) {
                        this.registerIfNotExists(name);
                    }
                    break;
                }
                case List: {
                    this.registerIfNotExists("default");
                }
            }
        }
    }

    public void registerIfNotExists(String name) {
        if (!this.kernel.isBeanClassRegistered(name)) {
            Class<?> cls = this.getDefaultBeanClass();
            this.kernel.registerBean(name).asClass(cls).exec();
        }
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
        this.registerIfNotExists("default");
    }

    @Override
    public void unregister(Kernel kernel) {
        this.kernel = null;
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    protected abstract Class<? extends T> findClassForDataSource(DataSource var1) throws DBInitException;

    protected Stream<T> repositoriesStream() {
        return this.getRepositories().values().stream();
    }

    protected Map<String, T> getRepositories() {
        return Collections.unmodifiableMap(this.repositories);
    }

    protected T getRepository(String domain) {
        DataSourceAware repo = (DataSourceAware)this.repositories.get(this.aliases.getOrDefault(domain, domain));
        if (repo == null) {
            repo = (DataSourceAware)this.repositories.get("default");
        }
        return (T)repo;
    }

    @HandleEvent
    protected void onDataSourceChange(DataSourceBean.DataSourceChangedEvent event) {
        if (!event.isCorrectSender(this.dataSourceBean)) {
            return;
        }
        if (this.dataSourceSelection == SelectorType.EveryDataSource) {
            if (event.getNewDataSource() == null) {
                this.kernel.unregister(event.getDomain());
            } else {
                this.registerIfNotExists(event.getDomain());
            }
        }
    }

    protected void initializeRepository(String domain, T repo) {
    }

    protected void updateDataSourceAware(String domain, T newRepo, T oldRepo) {
        if (newRepo != null) {
            this.repositories.put(domain, newRepo);
        } else {
            this.repositories.remove(domain, oldRepo);
        }
    }

    public static abstract class MDRepositoryConfigBean<A extends DataSourceAware>
    implements Initializable,
    UnregisterAware,
    ConfigurationChangedAware,
    RegistrarBean {
        @Inject
        protected DataSourceBean dataSourceBean;
        @ConfigField(alias="repo-class", desc="Class implementing repository", allowAliasFromParent=false)
        private String cls;
        private DataSource dataSource;
        @Inject(bean="instance", nullAllowed=true)
        private A dataSourceAware;
        @ConfigField(desc="Name of data source", alias="data-source")
        private String dataSourceName;
        @Inject
        private EventBus eventBus;
        private Kernel kernel;
        @Inject
        private MDRepositoryBean<A> mdRepositoryBean;
        @ConfigField(desc="Name (ie. domain)")
        private String name;

        @Override
        public void beanConfigurationChanged(Collection<String> changedFields) {
            if (this.name == null || this.mdRepositoryBean == null || this.dataSourceBean == null) {
                return;
            }
            String name = this.name;
            if (this.dataSourceName != null && !this.dataSourceName.isEmpty()) {
                name = this.dataSourceName;
            }
            this.dataSource = this.dataSourceBean.getRepository(name);
            if (this.dataSource != null) {
                try {
                    Class<?> repoClass = this.getRepositoryClassName();
                    this.kernel.registerBean("instance").asClass(repoClass).exec();
                }
                catch (ClassNotFoundException | DBInitException ex) {
                    throw new RuntimeException("Could not initialize bean '" + name + "'", ex);
                }
            } else {
                if (this.kernel.isBeanClassRegistered("instance")) {
                    this.kernel.unregister("instance");
                }
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "There is no data source named '" + Optional.ofNullable(this.dataSourceName).orElse(name) + "'");
                }
            }
        }

        public void setDataSourceAware(A dataSourceAware) {
            if (this.mdRepositoryBean == null || this.dataSourceAware == dataSourceAware) {
                return;
            }
            if (dataSourceAware != null) {
                this.mdRepositoryBean.initializeRepository(this.name, dataSourceAware);
                try {
                    this.dataSource.checkSchemaVersion((DataSourceAware<? extends DataSource>)dataSourceAware, true);
                    dataSourceAware.setDataSource((DataSource)this.dataSource);
                }
                catch (RepositoryException ex) {
                    throw new RuntimeException("Failed to initialize repository", ex);
                }
            }
            this.mdRepositoryBean.updateDataSourceAware(this.name, dataSourceAware, this.dataSourceAware);
            this.dataSourceAware = dataSourceAware;
        }

        @Override
        public void register(Kernel kernel) {
            this.kernel = kernel;
            if (kernel.getParent() != null) {
                String rootBean = kernel.getParent().getName();
                this.kernel.getParent().ln("service", kernel, rootBean);
            }
        }

        @Override
        public void unregister(Kernel kernel) {
            kernel.unregister("instance");
        }

        @Override
        public void initialize() {
            this.eventBus.registerAll(this);
            this.beanConfigurationChanged(Collections.singleton("uri"));
            if (this.dataSource == null) {
                throw new RuntimeException("There is no data source named '" + Optional.ofNullable(this.dataSourceName).orElse(this.name) + "'");
            }
            this.setDataSourceAware((DataSourceAware)this.kernel.getInstance("instance"));
        }

        @Override
        public void beforeUnregister() {
            this.eventBus.unregisterAll(this);
            this.kernel.unregister("instance");
        }

        protected Class<?> getRepositoryClassName() throws DBInitException, ClassNotFoundException {
            if (this.cls == null) {
                return this.mdRepositoryBean.findClassForDataSource(this.dataSource);
            }
            return ModulesManagerImpl.getInstance().forName(this.cls);
        }

        protected String getCls() {
            return this.cls;
        }

        @HandleEvent
        protected void onDataSourceChange(DataSourceBean.DataSourceChangedEvent event) {
            if (!event.isCorrectSender(this.dataSourceBean)) {
                return;
            }
            if (!event.getDomain().equals(this.name) && !event.getDomain().equals(this.dataSourceName)) {
                return;
            }
            this.beanConfigurationChanged(Collections.singleton("uri"));
        }
    }

    public static enum SelectorType {
        List,
        EveryDataSource,
        EveryUserRepository;

    }
}

