/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import tigase.auth.SessionAware;
import tigase.auth.callbacks.ValidateCertificateData;
import tigase.cert.CertificateUtil;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public class CertBasedCallbackHandler
implements CallbackHandler,
SessionAware {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private XMPPResourceConnection session;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            for (int i = 0; i < callbacks.length; ++i) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
                }
                if (callbacks[i] instanceof ValidateCertificateData) {
                    String[] authJIDs;
                    ValidateCertificateData authCallback = (ValidateCertificateData)callbacks[i];
                    String domain = this.session.getDomain().getVhost().getDomain();
                    BareJID defaultAuthzid = authCallback.getDefaultAuthzid();
                    if (defaultAuthzid != null && !defaultAuthzid.getDomain().equals(domain)) {
                        return;
                    }
                    Certificate cert = (Certificate)this.session.getSessionData("PEER_CERTIFICATE_ENTRY_KEY");
                    for (String string : authJIDs = CertificateUtil.extractXmppAddrs((X509Certificate)((X509Certificate)cert)).toArray(new String[0])) {
                        if (defaultAuthzid != null) {
                            if (!string.equals(defaultAuthzid.toString())) continue;
                            authCallback.setAuthorized(true);
                            authCallback.setAuthorizedID(string);
                            continue;
                        }
                        if (!BareJID.bareJIDInstance((String)string).getDomain().equals(domain)) continue;
                        authCallback.setAuthorized(true);
                        authCallback.setAuthorizedID(string);
                    }
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
        catch (TigaseStringprepException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }
}

