--
-- Tigase Push - Push notifications component for Tigase
-- Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
-- Unauthorized copying of this file, via any medium is strictly prohibited
-- Proprietary and confidential
--

-- -----------------------------------------------------------------------------
-- Tables
-- -----------------------------------------------------------------------------

-- Table to store service jids
-- QUERY START:
create table tig_push_devices (
	service_jid varchar(2049) not null,
	user_jid varchar(2049) not null,
    node varchar(1024) not null,
    provider varchar(100) not null,
    device_id varchar(1024) not null,

	primary key ( service_jid, user_jid, provider, device_id )
);
-- QUERY END:

-- QUERY START:
create index tig_push_devices_service_jid_node on tig_push_devices ( service_jid, node );
-- QUERY END:

-- QUERY START:
create unique index tig_push_devices_provider_device_id on tig_push_devices ( provider, device_id );
-- QUERY END:

-- -----------------------------------------------------------------------------
-- Functions
-- -----------------------------------------------------------------------------
-- QUERY START:
create procedure Tig_Push_RegisterDevice(service_jid varchar(2049), user_jid varchar(2049), node varchar(1024), provider varchar(100), device_id varchar(1024))
	PARAMETER STYLE JAVA
	LANGUAGE JAVA
	MODIFIES SQL DATA
	EXTERNAL NAME 'tigase.push.repositories.derby.StoredProcedures.tigPushRegisterDevice';
-- QUERY END:

-- QUERY START:
create procedure Tig_Push_UnregisterDevice(service_jid varchar(2049), user_jid varchar(2049), node varchar(1024), provider varchar(100), device_id varchar(1024))
	PARAMETER STYLE JAVA
	LANGUAGE JAVA
	MODIFIES SQL DATA
	EXTERNAL NAME 'tigase.push.repositories.derby.StoredProcedures.tigPushUnregisterDevice';
-- QUERY END:

-- QUERY START:
create procedure Tig_Push_GetNodeSettingsByNode(service_jid varchar(2049), node varchar(1024))
	PARAMETER STYLE JAVA
	LANGUAGE JAVA
	READS SQL DATA
	DYNAMIC RESULT SETS 1
	EXTERNAL NAME 'tigase.push.repositories.derby.StoredProcedures.tigPushGetNodeSettingsByNode';
-- QUERY END:

-- QUERY START:
create procedure Tig_Push_GetNodeSettingsByDevice(provider varchar(100), device_id varchar(1024))
	PARAMETER STYLE JAVA
	LANGUAGE JAVA
	READS SQL DATA
	DYNAMIC RESULT SETS 1
	EXTERNAL NAME 'tigase.push.repositories.derby.StoredProcedures.tigPushGetNodeSettingsByDevice';
-- QUERY END:

-- QUERY START:
call TigSetComponentVersion('push', '1.0.0');
-- QUERY END:
