/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.ui.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.SystemConsole;
import tigase.util.ui.console.Task;

public class ParameterParser {
    private static final Logger log = Logger.getLogger(ParameterParser.class.getName());
    private final CommandlineParameter helpOption = new CommandlineParameter.Builder(null, "help").description("Print the help").requireArguments(false).build();
    private final boolean interactiveMode;
    private final CommandlineParameter interactiveOption = new CommandlineParameter.Builder("I", "interactive").description("Enable interactive mode, which will result in prompting for missing parameters").requireArguments(false).build();
    private final List<CommandlineParameter> options;
    private final Map<String, CommandlineParameter> optionsByLetter;
    private final Map<String, CommandlineParameter> optionsByName;
    private Optional<Task> task = Optional.empty();
    private Optional<List<Task>> tasks = Optional.empty();

    public static void main(String[] args) {
        Properties properties;
        ParameterParser parser = new ParameterParser(true);
        parser.addOption(new CommandlineParameter.Builder("T", "db-type").description("Database server type").options("derby", "mysql", "postgresql", "sqlserver").defaultValue("mysql").required(true).build());
        parser.addOption(new CommandlineParameter.Builder("V", "schema-version").description("Intended version of the schema to be loaded").options("4", "5", "5-1", "7-1").required(true).defaultValue("7-1").build());
        parser.addOption(new CommandlineParameter.Builder("D", "db-name").description("Name of the database that will be created and to which schema will be loaded").defaultValue("tigasedb").required(true).build());
        parser.addOption(new CommandlineParameter.Builder("H", "db-host").description("Address of the database instance").defaultValue("localhost").required(true).build());
        parser.addOption(new CommandlineParameter.Builder("U", "db-user-name").description("Name of the user that will be created specifically to access Tigase XMPP Server").defaultValue("tigase_user").required(true).build());
        parser.addOption(new CommandlineParameter.Builder("P", "db-user-password").description("Password of the user that will be created specifically to access Tigase XMPP Server").defaultValue("tigase_pass").required(true).secret().build());
        parser.addOption(new CommandlineParameter.Builder("R", "db-root-name").description("Database root account username used to create tigase user and database").defaultValue("root").required(true).build());
        parser.addOption(new CommandlineParameter.Builder("A", "db-root-password").description("Database root account password used to create tigase user and database").defaultValue("root").secret().required(true).build());
        parser.addOption(new CommandlineParameter.Builder("F", "file").description("Comma separated list of SQL files that will be processed").build());
        parser.addOption(new CommandlineParameter.Builder("L", "log-level").description("Java Logger level during loading process").defaultValue("CONFIG").build());
        parser.addOption(new CommandlineParameter.Builder("S", "use-ssl").description("Enable SSL support for database connection (if database supports it)").requireArguments(false).defaultValue("false").build());
        parser.addOption(new CommandlineParameter.Builder("J", "admin-jid-name").description("Comma separated list of administrator JID(s)").build());
        parser.addOption(new CommandlineParameter.Builder("N", "admin-jid-password").description("Password that will be used for the entered JID(s) - one for all configured administrators").defaultValue("pass").secret().build());
        if (null == args || args.length == 0 || (properties = parser.parseArgs(args)) == null) {
            System.out.println(parser.getHelp());
        } else {
            System.out.println("properties: " + properties);
        }
    }

    public ParameterParser() {
        this(null, false);
    }

    public ParameterParser(boolean interactiveMode) {
        this(null, interactiveMode);
    }

    public ParameterParser(List<CommandlineParameter> options, boolean interactiveMode) {
        this.options = new ArrayList<CommandlineParameter>();
        this.optionsByName = new HashMap<String, CommandlineParameter>();
        this.optionsByLetter = new HashMap<String, CommandlineParameter>();
        this.interactiveMode = interactiveMode;
        this.addOption(this.helpOption);
        if (interactiveMode) {
            this.addInteractiveModeCommand();
        }
        if (null != options && !options.isEmpty()) {
            this.addOptions(options);
        }
    }

    public void addOption(CommandlineParameter option) throws IllegalArgumentException {
        if (option != null && !this.options.contains(option)) {
            this.options.add(option);
            if (option.getSingleLetter().isPresent()) {
                this.optionsByLetter.put(option.getSingleLetter().get(), option);
            }
            if (option.getFullName().isPresent()) {
                this.optionsByName.put(option.getFullName().get(), option);
            }
        } else {
            throw new IllegalArgumentException("Option already exists! Existing: " + this.options.get(this.options.indexOf(option)).toStringSimple() + " added: " + (option != null ? option.toStringSimple() : "n/a"));
        }
    }

    public void addOptions(List<CommandlineParameter> options) {
        if (null != options && !options.isEmpty()) {
            options.forEach(this::addOption);
        }
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    public String getHelp(String executionCommand) {
        if (null == executionCommand) {
            executionCommand = "$ java -cp \"path_to_binary.jar\" some.package.Class " + (this.tasks.isPresent() ? "[task] " : "") + "[options]\n\t\tif the option defines default then <value> is optional";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Usage:").append("\n");
        sb.append("\t").append(executionCommand).append("\n");
        sb.append("\n");
        if (this.tasks.isPresent()) {
            sb.append("Tasks:");
            for (Task task : this.tasks.get()) {
                sb.append("\n\t");
                sb.append(task.getName());
                task.getDescription().ifPresent(str -> sb.append("\t-\t").append((String)str));
            }
            sb.append("\n\n");
        }
        sb.append("Options:");
        List parameterDependentParameters = this.getOptions().stream().filter(option -> option.hasValueDependentParameters()).collect(Collectors.toList());
        if (!parameterDependentParameters.isEmpty()) {
            sb.append("\n\tThis is not a full list of possible parameters. Please pass values for ");
            if (this.tasks.isPresent()) {
                sb.append("task and ");
            }
            sb.append("following parameters to get full list of parameters: ");
            sb.append(parameterDependentParameters.stream().map(option -> option.getSingleLetter(true).orElseGet(() -> option.getFullName(true).get())).collect(Collectors.joining(", ")));
        }
        for (CommandlineParameter option2 : this.options) {
            sb.append("\n\n\t");
            option2.getSingleLetter(true).ifPresent(str -> sb.append((String)str));
            if (option2.getSingleLetter(true).isPresent()) {
                if (option2.isRequireArguments()) {
                    sb.append(" value");
                }
                sb.append(',').append(' ');
            }
            option2.getFullName(true).ifPresent(sb::append);
            if (option2.getFullName(true).isPresent()) {
                if (option2.isRequireArguments()) {
                    sb.append("=value");
                }
                sb.append(',').append(' ');
            }
            if (!option2.isRequired()) {
                sb.append(" (optional)");
            }
            sb.append("\n\t\t");
            option2.getDescription().ifPresent(sb::append);
            option2.getSelectionOptions().ifPresent(e -> sb.append(", possible values: ").append(e));
            option2.getDefaultValue().ifPresent(e -> sb.append(" (default: ").append((String)e).append(')'));
        }
        sb.append("\n");
        return sb.toString();
    }

    public Optional<CommandlineParameter> getOptionByLetter(String letter) {
        return null == this.optionsByLetter.get(letter) ? Optional.empty() : Optional.of(this.optionsByLetter.get(letter));
    }

    public Optional<CommandlineParameter> getOptionByName(String commandName) {
        return null == this.optionsByName.get(commandName) ? Optional.empty() : Optional.of(this.optionsByName.get(commandName));
    }

    public List<CommandlineParameter> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public List<CommandlineParameter> getOptions(Predicate<? super CommandlineParameter> predicate) {
        return this.options.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<String> getOptionsNames(Predicate<? super CommandlineParameter> predicate) {
        return this.getOptions(predicate).stream().map(CommandlineParameter::getFullName).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<Task> getTask() {
        return this.task;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public Properties parseArgs(String[] args) {
        log.log(Level.FINEST, "Parsing arguments: " + Arrays.toString(args));
        Properties props = new Properties();
        for (CommandlineParameter p2 : this.getOptions()) {
            p2.setValue(null);
        }
        int i = 0;
        this.task = Optional.empty();
        if (this.tasks.isPresent()) {
            if (args.length > 0) {
                this.task = this.tasks.get().stream().filter(t -> t.getName().equals(args[0])).findAny();
                if (this.task.isPresent()) {
                    ++i;
                }
            }
            if (!this.task.isPresent()) {
                return null;
            }
            this.addOptions(this.task.get().getAdditionalParameters());
        }
        while (this.parseArgsToProperties(props, i, args)) {
        }
        Predicate<CommandlineParameter> missingValuesPredicate = p -> !p.getValue().isPresent();
        boolean help = this.getOptionByName("help").isPresent();
        Optional<String> help1 = this.getOptionByName("help").get().getValue();
        if (help && Boolean.valueOf(help1.orElse("false")).booleanValue()) {
            return null;
        }
        if (this.interactiveMode && this.getOptionByName("interactive").isPresent() && Boolean.valueOf(this.getOptionByName("interactive").get().getValue().orElse("false")).booleanValue()) {
            log.log(Level.FINEST, "Using interactive mode for {0}", this.getOptionsNames(missingValuesPredicate));
            System.out.println("Using interactive mode for: " + this.getOptionsNames(missingValuesPredicate) + ", skipped options will use default if available");
            SystemConsole console = new SystemConsole();
            for (CommandlineParameter e : this.getOptions(missingValuesPredicate)) {
                if (e.equals(this.helpOption) || e.equals(this.interactiveOption)) continue;
                String label = (e.getFullName().isPresent() ? e.getFullName().get() : "") + (e.getDefaultValue().isPresent() ? " [" + e.getDefaultValue().orElse("n/a") + "]" : "") + ": ";
                String val = e.isSecret() ? new String(console.readPassword(label)) : console.readLine(label);
                if (null == val || val.isEmpty()) continue;
                e.setValue(val);
                this.addOptionsIfMissing(e.getValueDependentParameters());
            }
        }
        log.log(Level.FINEST, "Using defaults for mode for {0}", this.getOptionsNames(missingValuesPredicate));
        this.getOptions(missingValuesPredicate).forEach(CommandlineParameter::setValueFromDefault);
        Predicate<CommandlineParameter> missingAndRequired = p -> !p.getValue().isPresent() && p.isRequired();
        log.log(Level.FINEST, "Still missing values for: {0}, of which required are: {1}", new Object[]{this.getOptionsNames(missingValuesPredicate), this.getOptionsNames(missingAndRequired)});
        if (this.getOptions(missingAndRequired).size() > 0) {
            throw new IllegalArgumentException("You are missing arguments! Missing are: " + this.getOptionsNames(missingAndRequired));
        }
        for (CommandlineParameter e : this.getOptions(p -> p.getValue().isPresent())) {
            if (e.equals(this.interactiveOption) || e.equals(this.helpOption) || !e.getFullName().isPresent() || !e.getValue().isPresent()) continue;
            props.putIfAbsent(e.getFullName().get(), e.getValue().get());
        }
        return props;
    }

    public void removeOption(CommandlineParameter option) {
        if (null != option) {
            this.options.remove(option);
            option.getSingleLetter().ifPresent(this.optionsByLetter::remove);
            option.getFullName().ifPresent(this.optionsByName::remove);
        }
    }

    public void removeOptionByLetter(String singleLetter) {
        Optional<CommandlineParameter> option = this.getOptionByLetter(singleLetter);
        option.ifPresent(this::removeOption);
    }

    public void removeOptionByName(String name) {
        Optional<CommandlineParameter> option = this.getOptionByName(name);
        option.ifPresent(this::removeOption);
    }

    public void setTasks(Task[] supportedTasks) {
        this.tasks = Optional.ofNullable(supportedTasks == null ? null : Arrays.asList(supportedTasks));
    }

    private void addInteractiveModeCommand() {
        if (this.interactiveMode) {
            this.addOption(this.interactiveOption);
        }
    }

    private boolean addOptionsIfMissing(List<CommandlineParameter> options) {
        if (null != options && !options.isEmpty()) {
            return options.stream().filter(option -> !this.options.contains(option)).map(option -> {
                this.addOption((CommandlineParameter)option);
                return option;
            }).count() > 0L;
        }
        return false;
    }

    private boolean parseArgsToProperties(Properties props, int i, String[] args) {
        boolean added = false;
        while (i < args.length) {
            block18: {
                String value;
                String key;
                block19: {
                    block20: {
                        Boolean b;
                        CommandlineParameter option;
                        Optional<CommandlineParameter> optionOption;
                        block17: {
                            String arg = args[i];
                            key = null;
                            value = null;
                            if (!args[i].startsWith("--")) break block17;
                            key = args[i].contains("=") ? args[i].substring(2, args[i].indexOf("=")) : args[i].substring(2);
                            optionOption = this.getOptionByName(key);
                            if (!optionOption.isPresent()) break block18;
                            option = optionOption.get();
                            if (option.isRequireArguments()) {
                                if (args[i].contains("=")) {
                                    value = args[i].substring(arg.indexOf("=") + 1, args[i].length());
                                    option.setValue(value);
                                } else if (args.length - 1 > i) {
                                    value = args[i + 1];
                                    option.setValue(value);
                                    ++i;
                                } else if (option.getDefaultValue().isPresent()) {
                                    value = option.getDefaultValue().get();
                                    option.setValue(value);
                                }
                            } else {
                                b = true;
                                if (option.getDefaultValue().isPresent()) {
                                    b = Boolean.valueOf(option.getDefaultValue().get()) == false;
                                }
                                option.setValue(b.toString());
                            }
                            added |= this.addOptionsIfMissing(option.getValueDependentParameters());
                            break block19;
                        }
                        if (!args[i].startsWith("-")) break block20;
                        key = args[i].substring(1, args[i].length());
                        optionOption = this.getOptionByLetter(key);
                        if (!optionOption.isPresent()) break block18;
                        option = optionOption.get();
                        if (option.getFullName().isPresent()) {
                            key = option.getFullName().get();
                        }
                        if (option.isRequireArguments()) {
                            if (i + 1 < args.length) {
                                value = args[i + 1];
                                option.setValue(value);
                            } else if (option.getDefaultValue().isPresent()) {
                                value = option.getDefaultValue().get();
                                option.setValue(value);
                            }
                        } else {
                            b = true;
                            if (option.getDefaultValue().isPresent()) {
                                b = Boolean.valueOf(option.getDefaultValue().get()) == false;
                            }
                            option.setValue(b.toString());
                        }
                        added |= this.addOptionsIfMissing(option.getValueDependentParameters());
                        break block19;
                    }
                    log.log(Level.FINE, "Checked item is not valid: %1$s, possibly value of parameter", args[i]);
                }
                if (null != key && null != value) {
                    props.put(key, value);
                }
            }
            ++i;
        }
        return added;
    }
}

