/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

public class Token {
    private static final Random RAND_GEN = new SecureRandom();
    private BareJID jid;
    private String random;
    private Date timestamp;

    static String copy(byte[] buff, int offset, int len) {
        String r = "";
        for (int i = offset; i < offset + len; ++i) {
            r = r + (char)buff[i];
        }
        return r;
    }

    public static Token create(BareJID jid) {
        byte[] r = new byte[20];
        RAND_GEN.nextBytes(r);
        return Token.create(jid, new Date(), Base64.encode(r));
    }

    public static Token create(BareJID jid, Date timestamp, String random) {
        Token t = new Token();
        t.jid = jid;
        t.timestamp = timestamp;
        t.random = random;
        return t;
    }

    private static Token decodeTokenV1(byte[] buff) {
        int jidEndPos = Token.nullPos(buff, 1);
        int timestampEndPos = Token.nullPos(buff, jidEndPos + 1);
        String j = Token.copy(buff, 1, jidEndPos - 1);
        String ts = Token.copy(buff, jidEndPos + 1, timestampEndPos - jidEndPos - 1);
        String r = Token.copy(buff, timestampEndPos + 1, buff.length - timestampEndPos - 1);
        Token result = new Token();
        result.random = r;
        result.jid = BareJID.bareJIDInstanceNS(new String(Base64.decode(j), Charset.forName("UTF-8")));
        result.timestamp = new Date(Long.parseLong(ts));
        return result;
    }

    static int nullPos(byte[] buff, int from) {
        for (int i = from; i < buff.length; ++i) {
            if (buff[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public static Token parse(String encodedToken) {
        if (encodedToken == null) {
            throw new RuntimeException("Invalid token");
        }
        byte[] buff = Base64.decode(encodedToken);
        if (buff == null || buff.length == 0) {
            throw new RuntimeException("Invalid token");
        }
        byte tokenType = buff[0];
        switch (tokenType) {
            case 1: {
                return Token.decodeTokenV1(buff);
            }
        }
        throw new RuntimeException("Unknown token");
    }

    public String getEncoded() {
        return Base64.encode(this.getBuff());
    }

    public String getHash() {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            return Base64.encode(sha.digest(this.getBuff()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public BareJID getJid() {
        return this.jid;
    }

    public String getRandom() {
        return this.random;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    protected byte[] getBuff() {
        String j = Base64.encode(this.jid.toString().getBytes(Charset.forName("UTF-8")));
        String ts = String.valueOf(this.timestamp.getTime());
        int len = 1 + j.length() + 1 + ts.length() + 1 + this.random.length();
        byte[] buff = new byte[len];
        buff[0] = 1;
        int idx = 1;
        byte[] tmp = j.getBytes();
        System.arraycopy(tmp, 0, buff, idx, tmp.length);
        idx += tmp.length;
        buff[idx++] = 0;
        tmp = ts.getBytes();
        System.arraycopy(tmp, 0, buff, idx, tmp.length);
        idx += tmp.length;
        buff[idx++] = 0;
        tmp = this.random.getBytes();
        System.arraycopy(tmp, 0, buff, idx, tmp.length);
        idx += tmp.length;
        return buff;
    }
}

