/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.annotations.TigaseDeprecated;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.UserSessionEventWithProcessorResultWriter;
import tigase.util.Algorithms;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class RosterAbstract {
    public static final String CLIENT_XMLNS = "jabber:client";
    public static final String GROUP = "group";
    public static final String GROUPS = "groups";
    public static final String NAME = "name";
    public static final String ROSTER = "roster";
    public static final String ROSTER_XMLNS = "jabber:iq:roster";
    public static final String ROSTERHASH = "rosterhash";
    public static final String SUBSCRIPTION = "subscription";
    public static final String VER_ATT = "ver";
    public static final String XMLNS = "jabber:iq:roster";
    public static final String XMLNS_DYNAMIC = "jabber:iq:roster-dynamic";
    public static final String XMLNS_LOAD = "jabber:iq:roster-load";
    public static final EnumSet<SubscriptionType> TO_SUBSCRIBED = EnumSet.of(SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.both, SubscriptionType.to_pre_approved);
    public static final EnumSet<SubscriptionType> SUB_TO = EnumSet.of(SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to_pre_approved);
    public static final EnumSet<SubscriptionType> SUB_NONE = EnumSet.of(SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out_pre_approved);
    public static final EnumSet<SubscriptionType> SUB_FROM = EnumSet.of(SubscriptionType.from, SubscriptionType.from_pending_out);
    public static final EnumSet<SubscriptionType> SUB_BOTH = EnumSet.of(SubscriptionType.both);
    public static final EnumSet<SubscriptionType> PENDING_OUT = EnumSet.of(SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.from_pending_out, SubscriptionType.none_pending_out_pre_approved);
    public static final EnumSet<SubscriptionType> PENDING_IN = EnumSet.of(SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.to_pending_in);
    public static final EnumSet<StanzaType> INITIAL_PRESENCES = EnumSet.of(StanzaType.available, StanzaType.unavailable);
    public static final EnumSet<SubscriptionType> FROM_SUBSCRIBED = EnumSet.of(SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.both);
    public static final EnumSet<SubscriptionType> PRE_APPROVED = EnumSet.of(SubscriptionType.none_pre_approved, SubscriptionType.none_pending_out_pre_approved, SubscriptionType.to_pre_approved);
    public static final Element[] FEATURES = new Element[]{new Element("ver", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:rosterver"}), new Element("sub", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:pre-approval"})};
    public static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster"}), new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:roster-dynamic"})};
    private static final Logger log = Logger.getLogger(RosterAbstract.class.getName());
    protected static boolean emptyNameAllowed = false;
    protected static int maxRosterSize = new Long(Runtime.getRuntime().maxMemory() / 250000L).intValue();
    private static EnumMap<SubscriptionType, StateTransition> subsToStateMap = new EnumMap(SubscriptionType.class);
    private EventBus eventBus;

    public static int getMaxRosterSize() {
        return maxRosterSize;
    }

    public static void setMaxRosterSize(int maxRosterSize) {
        RosterAbstract.maxRosterSize = maxRosterSize;
    }

    public static SubscriptionType getStateTransition(SubscriptionType subscription, PresenceType presence) {
        StateTransition transition = subsToStateMap.get((Object)subscription);
        if (transition == null) {
            return RosterAbstract.getStateTransition(SubscriptionType.none, presence);
        }
        return transition.getStateTransition(presence);
    }

    public static boolean isEmptyNameAllowed() {
        return emptyNameAllowed;
    }

    public static void setEmptyNameAllowed(boolean emptyNameAllowed) {
        RosterAbstract.emptyNameAllowed = emptyNameAllowed;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        if (this.eventBus != null && this.eventBus != eventBus) {
            this.eventBus.unregisterAll(this);
        }
        this.eventBus = eventBus;
        if (this.eventBus != null) {
            this.eventBus.registerAll(this);
        }
    }

    public abstract void addBuddy(XMPPResourceConnection var1, JID var2, String var3, String[] var4, SubscriptionType var5, String var6) throws NotAuthorizedException, TigaseDBException, PolicyViolationException;

    @Deprecated
    @TigaseDeprecated(since="8.0.0", removeIn="9.0.0")
    public void addBuddy(XMPPResourceConnection session, JID jid, String name, String[] groups, String otherData) throws NotAuthorizedException, TigaseDBException, PolicyViolationException {
        this.addBuddy(session, jid, name, groups, null, otherData);
    }

    public abstract boolean addBuddyGroup(XMPPResourceConnection var1, JID var2, String[] var3) throws NotAuthorizedException, TigaseDBException;

    public abstract boolean containsBuddy(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public String groupNode(JID buddy) {
        return "roster/" + buddy.getBareJID();
    }

    public void init(UserRepository repo) throws TigaseDBException, TigaseDBException {
    }

    public abstract void logout(XMPPResourceConnection var1);

    public abstract boolean presenceSent(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract boolean removeBuddy(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public void updateBuddyChange(XMPPResourceConnection session, Queue<Packet> results, Element item) throws NotAuthorizedException, TigaseDBException, NoConnectionIdException {
        this.broadcastRosterChange(session.getParentSession(), item, results::offer);
        if (this.eventBus != null) {
            JID jid = JID.jidInstanceNS((String)item.getAttributeStaticStr("jid"));
            RosterElement rosterElement = this.getRosterElement(session, jid);
            if (rosterElement != null) {
                this.eventBus.fire(new RosterModifiedEvent(session.getJID().copyWithoutResource(), session.getJID().copyWithoutResource(), session.getParentSession(), rosterElement));
            } else {
                this.eventBus.fire(new RosterModifiedEvent(session.getJID().copyWithoutResource(), session.getJID().copyWithoutResource(), session.getParentSession(), jid, SubscriptionType.remove));
            }
        }
    }

    public boolean updateBuddySubscription(XMPPResourceConnection session, PresenceType presence, JID jid) throws NotAuthorizedException, TigaseDBException, PolicyViolationException {
        SubscriptionType current_subscription = this.getBuddySubscription(session, jid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "current_subscription={0} for jid={1}", new Object[]{current_subscription, jid});
        }
        if (current_subscription == null) {
            if (presence != PresenceType.in_unsubscribe && presence != PresenceType.out_unsubscribe) {
                this.addBuddy(session, jid, null, null, null, null);
            }
            current_subscription = SubscriptionType.none;
        }
        SubscriptionType new_subscription = RosterAbstract.getStateTransition(current_subscription, presence);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "new_subscription={0} for presence={1}", new Object[]{new_subscription, presence});
        }
        if (current_subscription == SubscriptionType.none_pending_in && (presence == PresenceType.out_unsubscribed || presence == PresenceType.in_unsubscribe)) {
            this.removeBuddy(session, jid);
            return false;
        }
        if (current_subscription != new_subscription) {
            this.setBuddySubscription(session, new_subscription, jid);
            return true;
        }
        return false;
    }

    public void updateRosterHash(String roster_str, XMPPResourceConnection session) {
        String roster_hash = null;
        try {
            roster_hash = Algorithms.hexDigest((String)"", (String)roster_str, (String)"MD5");
        }
        catch (Exception e) {
            roster_hash = null;
        }
        session.putCommonSessionData(ROSTERHASH, roster_hash);
    }

    public abstract JID[] getBuddies(XMPPResourceConnection var1) throws NotAuthorizedException, TigaseDBException;

    public JID[] getBuddies(XMPPResourceConnection session, EnumSet<SubscriptionType> subscrs) throws NotAuthorizedException, TigaseDBException {
        JID[] allBuddies = this.getBuddies(session);
        if (allBuddies == null) {
            return null;
        }
        ArrayList<JID> list = new ArrayList<JID>();
        for (JID buddy : allBuddies) {
            SubscriptionType subs = this.getBuddySubscription(session, buddy);
            if (!subscrs.contains((Object)subs)) continue;
            list.add(buddy);
        }
        return list.toArray(new JID[list.size()]);
    }

    public String getBuddiesHash(XMPPResourceConnection session) {
        String hash = (String)session.getCommonSessionData(ROSTERHASH);
        return hash != null ? hash : "";
    }

    public String getBuddiesHash(XMPPSession session) {
        String hash = (String)session.getCommonSessionData(ROSTERHASH);
        return hash != null ? hash : "";
    }

    public abstract String[] getBuddyGroups(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public Element getBuddyItem(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        String[] groups;
        SubscriptionType subscr = this.getBuddySubscription(session, buddy);
        if (subscr == null) {
            subscr = SubscriptionType.none;
            this.setBuddySubscription(session, subscr, buddy);
        }
        Element item = new Element("item");
        item.setAttribute("jid", buddy.toString());
        item.addAttributes(subscr.getSubscriptionAttr());
        String name = this.getBuddyName(session, buddy);
        if (name != null) {
            item.setAttribute(NAME, XMLUtils.escape((String)name));
        }
        if ((groups = this.getBuddyGroups(session, buddy)) != null) {
            for (String gr : groups) {
                Element group = new Element(GROUP);
                group.setCData(XMLUtils.escape((String)gr));
                item.addChild((XMLNodeIfc)group);
            }
        }
        return item;
    }

    public abstract String getBuddyName(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract SubscriptionType getBuddySubscription(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract Element getCustomChild(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public List<Element> getCustomChildren(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> result = new LinkedList<Element>();
        Element customChild = this.getCustomChild(session, buddy);
        if (customChild != null) {
            result.add(customChild);
        }
        return result;
    }

    public PresenceType getPresenceType(XMPPResourceConnection session, Packet packet) throws NotAuthorizedException {
        BareJID to = packet.getStanzaTo() != null ? packet.getStanzaTo().getBareJID() : null;
        StanzaType type = packet.getType();
        if (type == null) {
            type = StanzaType.available;
        } else if (type == StanzaType.error) {
            return PresenceType.error;
        }
        if (to == null || !session.isUserId(to)) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.out_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.out_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.out_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.out_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.out_unsubscribed;
            }
            if (type == StanzaType.probe) {
                return PresenceType.out_probe;
            }
        }
        if (to != null && session.isUserId(to)) {
            if (INITIAL_PRESENCES.contains((Object)type)) {
                return PresenceType.in_initial;
            }
            if (type == StanzaType.subscribe) {
                return PresenceType.in_subscribe;
            }
            if (type == StanzaType.unsubscribe) {
                return PresenceType.in_unsubscribe;
            }
            if (type == StanzaType.subscribed) {
                return PresenceType.in_subscribed;
            }
            if (type == StanzaType.unsubscribed) {
                return PresenceType.in_unsubscribed;
            }
            if (type == StanzaType.probe) {
                return PresenceType.in_probe;
            }
        }
        return null;
    }

    public abstract RosterElement getRosterElement(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public abstract Function<JID, RosterElement> rosterElementProvider(XMPPResourceConnection var1) throws NotAuthorizedException, TigaseDBException;

    public List<Element> getRosterItems(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> items = new LinkedList<Element>();
        JID[] buddies = this.getBuddies(session);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element buddy_item = this.getBuddyItem(session, buddy);
                items.add(buddy_item);
            }
        }
        return items;
    }

    public abstract boolean isRosterLoaded(XMPPResourceConnection var1);

    public abstract boolean isOnline(XMPPResourceConnection var1, JID var2) throws NotAuthorizedException, TigaseDBException;

    public boolean isPendingIn(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return PENDING_IN.contains((Object)subscr);
    }

    public boolean isSubscribedFrom(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public boolean isSubscribedFrom(SubscriptionType subscr) {
        return FROM_SUBSCRIBED.contains((Object)subscr);
    }

    public boolean isSubscribedTo(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return TO_SUBSCRIBED.contains((Object)subscr);
    }

    public boolean isPreApproved(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        SubscriptionType subscr = this.getBuddySubscription(session, jid);
        return PRE_APPROVED.contains((Object)subscr);
    }

    public abstract void setBuddyName(XMPPResourceConnection var1, JID var2, String var3) throws NotAuthorizedException, TigaseDBException;

    public abstract void setBuddySubscription(XMPPResourceConnection var1, SubscriptionType var2, JID var3) throws NotAuthorizedException, TigaseDBException;

    public abstract void setOnline(XMPPResourceConnection var1, JID var2, boolean var3) throws NotAuthorizedException, TigaseDBException;

    public abstract void setPresenceSent(XMPPResourceConnection var1, JID var2, boolean var3) throws NotAuthorizedException, TigaseDBException;

    public void setProperties(Map<String, Object> settings) {
        if (settings.get("empty_name_enabled") != null) {
            emptyNameAllowed = Boolean.valueOf((String)settings.get("empty_name_enabled"));
        }
        log.log(Level.CONFIG, "Configuring empty name allowed as: " + emptyNameAllowed);
        if (settings.get("max_roster_size") != null) {
            try {
                maxRosterSize = Integer.parseInt((String)settings.get("max_roster_size"));
            }
            catch (NumberFormatException e) {
                maxRosterSize = new Long(Runtime.getRuntime().maxMemory() / 250000L).intValue();
            }
        }
        log.log(Level.CONFIG, "Setting maximum number of roster items as: " + maxRosterSize);
    }

    @HandleEvent
    public void handleRosterModified(RosterModifiedEvent event) {
        SessionManager.ProcessorResultWriter writer = event.getPacketWriter();
        if (writer != null) {
            event.getSession().getActiveResources().stream().filter(conn -> conn.isAuthorized()).findFirst().ifPresent(conn -> {
                try {
                    XMPPSession xMPPSession = event.getSession();
                    synchronized (xMPPSession) {
                        this.updateRosterItem((XMPPResourceConnection)conn, event);
                    }
                    Element item = new Element("item");
                    item.setAttributes(event.getSubscription().getSubscriptionAttr());
                    item.setAttribute("jid", event.getJid().toString());
                    if (event.getName() != null) {
                        item.setAttribute(NAME, XMLUtils.escape((String)event.getName()));
                    }
                    if (event.getGroups() != null) {
                        Arrays.stream(event.getGroups()).map(XMLUtils::escape).map(group -> new Element(GROUP, group)).forEach(arg_0 -> ((Element)item).addChild(arg_0));
                    }
                    ArrayDeque<Packet> results = new ArrayDeque<Packet>();
                    this.broadcastRosterChange(event.getSession(), item, results::offer);
                    this.preparePresencePackets(event.getSession(), event.getJid(), event.getSubscription(), results::offer);
                    writer.write((Packet)results.peek(), (XMPPResourceConnection)conn, (Queue<Packet>)results);
                }
                catch (TigaseDBException | NoConnectionIdException | NotAuthorizedException ex) {
                    log.log(Level.FINEST, "Failed to update roster with changes from the other cluster node");
                }
            });
        }
    }

    protected void updateRosterItem(XMPPResourceConnection conn, RosterModifiedEvent event) throws NotAuthorizedException, TigaseDBException {
        List<Element> items = this.getRosterItems(conn);
        if (items != null) {
            StringBuilder sb = new StringBuilder(4096);
            for (Element item : items) {
                item.toString(sb);
            }
            this.updateRosterHash(sb.toString(), conn);
        }
    }

    private void preparePresencePackets(XMPPSession session, JID jid, SubscriptionType subscription, Consumer<Packet> consumer) {
        Stream<XMPPResourceConnection> sessions = session.getActiveResources().stream().filter(conn -> conn.isAuthorized()).filter(conn -> conn.getPresence() != null);
        switch (subscription) {
            case from: 
            case from_pending_out: 
            case both: {
                sessions.map(conn -> conn.getPresence()).filter(presence -> presence != null).map(elem -> Packet.packetInstance(elem, JID.jidInstanceNS((String)elem.getAttributeStaticStr("from")), jid)).forEach(consumer);
                break;
            }
            case to: 
            case none: {
                sessions.map(conn -> Packet.packetInstance(new Element("presence", new String[]{"type", "xmlns"}, new String[]{"unavailable", CLIENT_XMLNS}), conn.getjid(), jid)).forEach(consumer);
            }
        }
    }

    private void broadcastRosterChange(XMPPSession session, Element item, Consumer<Packet> consumer) throws NotAuthorizedException, NoConnectionIdException {
        Element update = new Element("iq");
        update.setXMLNS(CLIENT_XMLNS);
        update.setAttribute("type", StanzaType.set.toString());
        Element query = new Element("query");
        query.setXMLNS("jabber:iq:roster");
        query.addAttribute(VER_ATT, this.getBuddiesHash(session));
        query.addChild((XMLNodeIfc)item);
        update.addChild((XMLNodeIfc)query);
        for (XMPPResourceConnection conn : session.getActiveResources()) {
            Element conn_update = update.clone();
            conn_update.setAttribute("to", conn.getBareJID().toString());
            conn_update.setAttribute("id", "rst" + conn.nextStanzaId());
            Packet pack_update = Packet.packetInstance(conn_update, null, conn.getJID());
            pack_update.setPacketTo(conn.getConnectionId());
            consumer.accept(pack_update);
        }
    }

    static {
        subsToStateMap.put(SubscriptionType.none, StateTransition.none);
        subsToStateMap.put(SubscriptionType.none_pre_approved, StateTransition.none_pre_approved);
        subsToStateMap.put(SubscriptionType.none_pending_out, StateTransition.none_pending_out);
        subsToStateMap.put(SubscriptionType.none_pending_out_pre_approved, StateTransition.none_pending_out_pre_approved);
        subsToStateMap.put(SubscriptionType.none_pending_in, StateTransition.none_pending_in);
        subsToStateMap.put(SubscriptionType.none_pending_out_in, StateTransition.none_pending_out_in);
        subsToStateMap.put(SubscriptionType.to, StateTransition.to);
        subsToStateMap.put(SubscriptionType.to_pre_approved, StateTransition.to_pre_approved);
        subsToStateMap.put(SubscriptionType.to_pending_in, StateTransition.to_pending_in);
        subsToStateMap.put(SubscriptionType.from, StateTransition.from);
        subsToStateMap.put(SubscriptionType.from_pending_out, StateTransition.from_pending_out);
        subsToStateMap.put(SubscriptionType.both, StateTransition.both);
    }

    public static class RosterModifiedEvent
    extends UserSessionEventWithProcessorResultWriter {
        private String[] groups;
        private JID jid;
        private String name;
        private SubscriptionType subscription;

        public RosterModifiedEvent() {
        }

        public RosterModifiedEvent(JID sender, JID userJid, XMPPSession session, RosterElement rosterElement) {
            super(sender, userJid, session, null);
            this.jid = rosterElement.getJid();
            this.name = rosterElement.getName();
            this.subscription = rosterElement.getSubscription();
            this.groups = rosterElement.getGroups();
        }

        public RosterModifiedEvent(JID sender, JID userJid, XMPPSession session, JID jid, SubscriptionType subscription) {
            super(sender, userJid, session, null);
            this.jid = jid;
            this.name = null;
            this.subscription = subscription;
            this.groups = null;
        }

        public JID getJid() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public SubscriptionType getSubscription() {
            return this.subscription;
        }

        public String[] getGroups() {
            return this.groups;
        }
    }

    public static enum SubscriptionType {
        none("none"),
        none_pending_out("none", "subscribe"),
        none_pending_in("none"),
        none_pending_out_in("none", "subscribe"),
        to("to"),
        to_pending_in("to"),
        from("from"),
        from_pending_out("from", "subscribe"),
        both("both"),
        remove("remove"),
        none_pre_approved("none", null, true),
        none_pending_out_pre_approved("none", "subscribe", true),
        to_pre_approved("to", null, true);

        private Map<String, String> attrs = new LinkedHashMap<String, String>(2, 1.0f);

        private SubscriptionType(String subscr) {
            this(subscr, null, false);
        }

        private SubscriptionType(String subscr, String ask) {
            this(subscr, ask, false);
        }

        private SubscriptionType(String subscr, String ask, boolean approved) {
            this.attrs.put(RosterAbstract.SUBSCRIPTION, subscr);
            if (ask != null) {
                this.attrs.put("ask", ask);
            }
            if (approved) {
                this.attrs.put("approved", "true");
            }
        }

        public Map<String, String> getSubscriptionAttr() {
            return this.attrs;
        }
    }

    public static enum StateTransition {
        none(SubscriptionType.none_pre_approved, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_out(SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to, SubscriptionType.none, SubscriptionType.none_pending_out, SubscriptionType.none),
        none_pending_in(SubscriptionType.from, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none, SubscriptionType.none_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        none_pending_out_in(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_out, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.none_pending_out_in, SubscriptionType.none_pending_in),
        to(SubscriptionType.to_pre_approved, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to, SubscriptionType.none, SubscriptionType.to, SubscriptionType.none),
        to_pending_in(SubscriptionType.both, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.to, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in, SubscriptionType.to_pending_in, SubscriptionType.none_pending_in),
        from(SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.none, SubscriptionType.from, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        from_pending_out(SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.from_pending_out, SubscriptionType.none_pending_out, SubscriptionType.both, SubscriptionType.from, SubscriptionType.from_pending_out, SubscriptionType.from),
        both(SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.to, SubscriptionType.both, SubscriptionType.from, SubscriptionType.both, SubscriptionType.from),
        none_pre_approved(SubscriptionType.none_pre_approved, SubscriptionType.none, SubscriptionType.from, SubscriptionType.none_pre_approved, SubscriptionType.none_pre_approved, SubscriptionType.none_pre_approved, SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pre_approved),
        none_pending_out_pre_approved(SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pending_out, SubscriptionType.from_pending_out, SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pre_approved, SubscriptionType.none_pending_out_pre_approved, SubscriptionType.none_pre_approved),
        to_pre_approved(SubscriptionType.to_pre_approved, SubscriptionType.to, SubscriptionType.both, SubscriptionType.to_pre_approved, SubscriptionType.to_pre_approved, SubscriptionType.none_pre_approved, SubscriptionType.to_pre_approved, SubscriptionType.none_pre_approved);

        private EnumMap<PresenceType, SubscriptionType> stateTransition = new EnumMap(PresenceType.class);

        private StateTransition(SubscriptionType out_subscribed, SubscriptionType out_unsubscribed, SubscriptionType in_subscribe, SubscriptionType in_unsubscribe, SubscriptionType in_subscribed, SubscriptionType in_unsubscribed, SubscriptionType out_subscribe, SubscriptionType out_unsubscribe) {
            this.stateTransition.put(PresenceType.out_subscribed, out_subscribed);
            this.stateTransition.put(PresenceType.out_unsubscribed, out_unsubscribed);
            this.stateTransition.put(PresenceType.in_subscribe, in_subscribe);
            this.stateTransition.put(PresenceType.in_unsubscribe, in_unsubscribe);
            this.stateTransition.put(PresenceType.in_subscribed, in_subscribed);
            this.stateTransition.put(PresenceType.in_unsubscribed, in_unsubscribed);
            this.stateTransition.put(PresenceType.out_subscribe, out_subscribe);
            this.stateTransition.put(PresenceType.out_unsubscribe, out_unsubscribe);
        }

        public SubscriptionType getStateTransition(PresenceType pres_type) {
            SubscriptionType res = this.stateTransition.get((Object)pres_type);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("this=" + this.toString() + ", pres_type=" + (Object)((Object)pres_type) + ", res=" + (Object)((Object)res));
            }
            return res;
        }
    }

    public static enum PresenceType {
        out_initial,
        out_subscribe,
        out_unsubscribe,
        out_subscribed,
        out_unsubscribed,
        out_probe,
        in_initial,
        in_subscribe,
        in_unsubscribe,
        in_subscribed,
        in_unsubscribed,
        in_probe,
        error;

    }
}

