/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.setup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import tigase.conf.ConfigBuilder;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.server.ServerComponent;
import tigase.server.xmppsession.SessionManager;
import tigase.util.setup.BeanDefinition;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.jid.BareJID;

public class SetupHelper {
    public static BeanDefinition convertToBeanDefinition(Class<?> cls) {
        return new BeanDefinition(cls);
    }

    public static ConfigBuilder generateConfig(ConfigTypeEnum configType, String dbUri, boolean clusterMode, boolean acs, Optional<Set<String>> optionalComponentsOption, Optional<Set<String>> forceEnabledComponentsOptions, Optional<Set<String>> pluginsOption, String defaultVirtualHost, Optional<BareJID[]> admins, Optional<HttpSecurity> httpSecurity) {
        ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().with("config-type", configType.id().toLowerCase());
        if (clusterMode) {
            builder.with("cluster-mode", "true");
        }
        ((ConfigBuilder)((ConfigBuilder)builder.with("default-virtual-host", defaultVirtualHost)).with("admins", admins)).with("debug", Arrays.asList("server"));
        builder.withBean(ds -> {
            AbstractBeanConfigurator.BeanDefinition.Builder cfr_ignored_0 = (AbstractBeanConfigurator.BeanDefinition.Builder)ds.name("dataSource").withBean(def -> {
                AbstractBeanConfigurator.BeanDefinition.Builder cfr_ignored_0 = (AbstractBeanConfigurator.BeanDefinition.Builder)def.name("default").with("uri", dbUri);
            });
        });
        ArrayList<AbstractBeanConfigurator.BeanDefinition> sessManSubBeans = new ArrayList<AbstractBeanConfigurator.BeanDefinition>();
        if (pluginsOption.isPresent()) {
            Set<String> plugins = pluginsOption.get();
            sessManSubBeans.addAll(SetupHelper.getAvailableProcessors(SessionManager.class, XMPPImplIfc.class).stream().filter(def -> def.isActive() && !plugins.contains(def.getName()) || !def.isActive() && plugins.contains(def.getName())).map(def -> new AbstractBeanConfigurator.BeanDefinition.Builder().name(def.getName()).active(plugins.contains(def.getName())).build()).collect(Collectors.toList()));
        }
        if (acs) {
            sessManSubBeans.add(new AbstractBeanConfigurator.BeanDefinition.Builder().name("strategy").clazz("tigase.server.cluster.strategy.OnlineUsersCachingStrategy").build());
        }
        if (!sessManSubBeans.isEmpty()) {
            builder.withBean(sessMan -> {
                AbstractBeanConfigurator.BeanDefinition.Builder cfr_ignored_0 = (AbstractBeanConfigurator.BeanDefinition.Builder)sessMan.name("sess-man").with((AbstractBeanConfigurator.BeanDefinition[])sessManSubBeans.stream().toArray(AbstractBeanConfigurator.BeanDefinition[]::new));
            });
        }
        Set optionalComponents = optionalComponentsOption.orElse(SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).map(def -> def.getName()).collect(Collectors.toSet()));
        SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            if (optionalComponents.contains(def.getName())) {
                return !def.isActive() || ct != null && !Arrays.asList(ct.value()).contains((Object)configType) || forceEnabledComponentsOptions.isPresent() && ((Set)forceEnabledComponentsOptions.get()).contains(def.getName()) || "http".equals(def.getName()) && httpSecurity.isPresent() || "pubsub".equals(def.getName()) && optionalComponents.contains("http");
            }
            return def.isActive() && ct != null && Arrays.asList(ct.value()).contains((Object)configType);
        }).forEach(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            builder.withBean(b -> {
                b.name(def.getName()).active(optionalComponents.contains(def.getName())).clazz(ct != null && !Arrays.asList(ct.value()).contains((Object)configType) ? def.getClazz() : null);
                if ("http".equals(def.getName())) {
                    httpSecurity.ifPresent(sec -> {
                        if (sec.setupUser != null && !sec.setupUser.isEmpty() && sec.setupPassword != null && !sec.setupPassword.isEmpty()) {
                            b.withBean(setup -> {
                                AbstractBeanConfigurator.BeanDefinition.Builder cfr_ignored_0 = (AbstractBeanConfigurator.BeanDefinition.Builder)((AbstractBeanConfigurator.BeanDefinition.Builder)setup.name("setup").with("admin-user", sec.setupUser)).with("admin-password", sec.setupPassword);
                            });
                        }
                    });
                }
                if ("pubsub".equals(def.getName()) && optionalComponents.contains("http")) {
                    b.with("trusted", Arrays.asList("http@{clusterNode}"));
                }
            });
        });
        return builder;
    }

    public static List<BeanDefinition> getAvailableBeans(Class processorClazz) {
        return SetupHelper.getAvailableBeans(processorClazz, Kernel.class);
    }

    public static List<BeanDefinition> getAvailableBeans(Class processorClazz, Class componentClazz) {
        Kernel kernel = new Kernel();
        kernel.registerBean("beanSelector").asInstance(new ServerBeanSelector()).exportable().exec();
        return AbstractBeanConfigurator.getBeanClassesFromAnnotations(kernel, componentClazz).entrySet().stream().filter(e -> processorClazz.isAssignableFrom((Class)e.getValue())).map(e -> (Class)e.getValue()).map(SetupHelper::convertToBeanDefinition).collect(Collectors.toList());
    }

    public static List<BeanDefinition> getAvailableComponents() {
        return SetupHelper.getAvailableBeans(ServerComponent.class);
    }

    public static List<BeanDefinition> getAvailableProcessors(Class componentClazz, Class processorClazz) {
        return SetupHelper.getAvailableBeans(processorClazz, componentClazz);
    }

    public static class HttpSecurity {
        public String setupPassword;
        public String setupUser;
    }

    public static enum RestApiSecurity {
        forbidden,
        api_keys,
        open_access;

    }
}

