/*
 * Decompiled with CFR 0.152.
 */
package tigase.util.processing;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.util.processing.QueueItem;
import tigase.util.processing.WorkerThread;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class ProcessingThreads<E extends WorkerThread> {
    private static final Logger log = Logger.getLogger(ProcessingThreads.class.getName());
    private long droppedPackets = 0L;
    private String name = null;
    private int numWorkerThreads = 1;
    private ArrayList<E> workerThreads = null;

    public ProcessingThreads(E worker, int numWorkerThreads, int maxQueueSize, String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.numWorkerThreads = numWorkerThreads;
        this.workerThreads = new ArrayList(numWorkerThreads);
        this.name = name;
        for (int j = 0; j < numWorkerThreads; ++j) {
            WorkerThread t = ((WorkerThread)worker).getNewInstance();
            t.setQueueMaxSize(maxQueueSize);
            t.setDaemon(true);
            t.setName(name + " Queue Worker " + j);
            t.start();
            this.workerThreads.add(t);
            log.log(Level.FINEST, "Created worker thread: {0}, queueSize: {1}", new Object[]{t.getName(), maxQueueSize});
        }
    }

    public boolean addItem(XMPPProcessorIfc processor, Packet packet, XMPPResourceConnection conn) {
        boolean ret = false;
        QueueItem item = new QueueItem(processor, packet, conn);
        try {
            ret = item.getConn() != null && item.getConn().isAuthorized() ? ((WorkerThread)this.workerThreads.get(Math.abs(conn.getJID().getBareJID().hashCode()) % this.numWorkerThreads)).offer(item) : (packet.getPacketFrom() != null ? ((WorkerThread)this.workerThreads.get(Math.abs(packet.getPacketFrom().hashCode()) % this.numWorkerThreads)).offer(item) : (packet.getStanzaTo() != null ? ((WorkerThread)this.workerThreads.get(Math.abs(packet.getStanzaTo().getBareJID().hashCode()) % this.numWorkerThreads)).offer(item) : ((WorkerThread)this.workerThreads.get(Math.abs(packet.getTo().hashCode()))).offer(item)));
        }
        catch (Exception e) {
            ret = packet.getStanzaTo() != null ? ((WorkerThread)this.workerThreads.get(Math.abs(packet.getStanzaTo().getBareJID().hashCode()) % this.numWorkerThreads)).offer(item) : ((WorkerThread)this.workerThreads.get(Math.abs(packet.getTo().hashCode()) % this.numWorkerThreads)).offer(item);
        }
        if (!ret) {
            ++this.droppedPackets;
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Packet dropped due to queue overflow: {0}", packet);
            }
        }
        return ret;
    }

    public long getAverageProcessingTime() {
        long average = 0L;
        int counters = 0;
        for (WorkerThread workerThread : this.workerThreads) {
            if (workerThread.getAverageProcessingTime() <= 0L) continue;
            average += workerThread.getAverageProcessingTime();
            ++counters;
        }
        if (counters > 0) {
            return average / (long)counters;
        }
        return 0L;
    }

    public long getDroppedPackets() {
        return this.droppedPackets;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalQueueSize() {
        int ret = 0;
        for (WorkerThread pq : this.workerThreads) {
            ret += pq.size();
        }
        return ret;
    }

    public int getTotalRuns() {
        int ret = 0;
        for (WorkerThread workerThread : this.workerThreads) {
            ret = (int)((long)ret + workerThread.getRunsCounter());
        }
        return ret;
    }

    public void shutdown() {
        for (WorkerThread workerThread : this.workerThreads) {
            workerThread.shutdown();
        }
    }
}

