/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import tigase.conf.ConfiguratorAbstract;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.stats.ErrorsStatisticsProvider;
import tigase.stats.StatRecord;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProvider;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="stats", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class StatisticsCollector
extends AbstractComponentRegistrator<StatisticsContainer>
implements ShutdownHook,
RegistrarBean {
    public static final String ERRORS_STATISTICS_MBEAN_NAME = "tigase.stats:type=ErrorStatistics";
    public static final String STATISTICS_MBEAN_NAME = "tigase.stats:type=StatisticsProvider";
    public static final String STATS_HISTORY_SIZE_PROP_KEY = "stats-history-size";
    public static final int STATS_HISTORY_SIZE_PROP_VAL = 8640;
    public static final String STATS_UPDATE_INTERVAL_PROP_KEY = "stats-update-interval";
    public static final String STATS_HIGH_MEMORY_LEVEL_KEY = "stats-high-memory-level";
    private static final String STATS_XMLNS = "http://jabber.org/protocol/stats";
    private static final Logger log = Logger.getLogger(StatisticsCollector.class.getName());
    private final ArchivizerRunner arch_runner = new ArchivizerRunner();
    private final Timer everyX = new Timer("stats-timer", true);
    private final Timer statsArchivTasks = new Timer("stats-archivizer-tasks", true);
    private Map<StatisticsArchivizerIfc, TimerTask> archiverTasks = new ConcurrentHashMap<StatisticsArchivizerIfc, TimerTask>();
    @Inject(nullAllowed=true)
    private StatisticsArchivizerIfc[] archivizers = new StatisticsArchivizerIfc[0];
    private ErrorsStatisticsProvider esp = null;
    @ConfigField(desc="High memory level", alias="stats-high-memory-level")
    private int highMemoryLevel = 95;
    @ConfigField(desc="History size", alias="stats-history-size")
    private int historySize = 0;
    private TimerTask initializationCompletedTask = null;
    private ServiceEntity serviceEntity = null;
    private StatisticsProvider sp = null;
    private Level statsLevel = Level.INFO;
    @ConfigField(desc="Update interval", alias="stats-update-interval")
    private long updateInterval = 10L;

    @Override
    public void componentAdded(StatisticsContainer component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public void componentRemoved(StatisticsContainer component) {
    }

    @Override
    public void initializationCompleted() {
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
        try {
            this.sp = new StatisticsProvider(this, this.historySize, this.updateInterval, this.highMemoryLevel);
            String objName = STATISTICS_MBEAN_NAME;
            ObjectName on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.sp, on);
            ConfiguratorAbstract.putMXBean(objName, this.sp);
            this.esp = new ErrorsStatisticsProvider();
            objName = ERRORS_STATISTICS_MBEAN_NAME;
            on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.esp, on);
            ConfiguratorAbstract.putMXBean(objName, this.esp);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not install Statistics MXBean: ", ex);
        }
        TigaseRuntime.getTigaseRuntime().addShutdownHook(this);
        if (this.initializationCompletedTask != null) {
            this.initializationCompletedTask.run();
        }
        this.everyX.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsCollector.this.everySecond();
            }
        }, 1000L, 1000L);
        this.everyX.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsCollector.this.everyMinute();
            }
        }, 60000L, 60000L);
        this.everyX.schedule(new TimerTask(){

            @Override
            public void run() {
                StatisticsCollector.this.everyHour();
            }
        }, 3600000L, 3600000L);
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        Iq iqc;
        BareJID stanzaFromBare;
        JID stanzaFrom;
        if (!packet.isCommand() || packet.getType() == StanzaType.result) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} command received: {1}", new Object[]{packet.getCommand().name(), packet});
        }
        if (!this.isAdmin(stanzaFrom = JID.jidInstance((BareJID)(stanzaFromBare = (iqc = (Iq)packet).getStanzaFrom().getBareJID())))) {
            Packet result = iqc.commandResult(Command.DataType.result);
            Command.addTextField(result, "Error", "You do not have enough permissions to manage this domain");
            results.offer(result);
            return;
        }
        switch (iqc.getCommand()) {
            case GETSTATS: {
                Element query = new Element("query", STATS_XMLNS);
                StatisticsList stats = this.getAllStats();
                if (stats != null) {
                    for (StatRecord record : stats) {
                        Element item = new Element("stat");
                        item.addAttribute("name", record.getComponent() + "/" + record.getDescription());
                        item.addAttribute("value", record.getValue());
                        query.addChild((XMLNodeIfc)item);
                    }
                }
                Packet result = iqc.okResult(query, 0);
                results.offer(result);
                break;
            }
            case OTHER: {
                if (iqc.getStrCommand() == null) {
                    return;
                }
                String nick = iqc.getTo().getLocalpart();
                if (!this.getName().equals(nick)) {
                    return;
                }
                Command.Action action = Command.getAction(iqc);
                if (action == Command.Action.cancel) {
                    Packet result = iqc.commandResult(null);
                    results.offer(result);
                    return;
                }
                String tmp_val = Command.getFieldValue(iqc, "Stats level");
                Level statsLevel = this.statsLevel;
                if (tmp_val != null) {
                    statsLevel = Level.parse(tmp_val);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "statsLevel parsed to: {0}", statsLevel.getName());
                    }
                }
                StatisticsList list = new StatisticsList(statsLevel);
                if (iqc.getStrCommand().equals("stats")) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Getting all stats for level: {0}", statsLevel.getName());
                    }
                    this.getAllStats(list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "All stats for level loaded: {0}", statsLevel.getName());
                    }
                } else {
                    String[] spl = iqc.getStrCommand().split("/");
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Getting stats for component: {0}, level: {1}", new Object[]{spl[1], statsLevel.getName()});
                    }
                    this.getComponentStats(spl[1], list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Stats loaded for component: {0}, level: {1}", new Object[]{spl[1], statsLevel.getName()});
                    }
                }
                Packet result = iqc.commandResult(Command.DataType.form);
                for (StatRecord rec : list) {
                    Command.addFieldValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), XMLUtils.escape((String)rec.getValue()));
                }
                Command.addFieldValue(result, "Stats level", statsLevel.getName(), "Stats level", new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()}, new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()});
                results.offer(result);
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "Returning stats result: {0}", result);
                break;
            }
        }
    }

    @Override
    public void release() {
        super.release();
        this.sp.stop();
        this.statsArchivTasks.cancel();
    }

    @Override
    public String shutdown() {
        StatisticsList allStats = this.getAllStats();
        StringBuilder sb = new StringBuilder(4096);
        for (StatRecord statRecord : allStats) {
            sb.append(statRecord.toString()).append('\n');
        }
        return sb.toString();
    }

    public StatisticsList getAllStats() {
        StatisticsList list = new StatisticsList(Level.ALL);
        this.getAllStats(list);
        return list;
    }

    public void getAllStats(StatisticsList list) {
        for (StatisticsContainer comp : this.components.values()) {
            this.getComponentStats(comp.getName(), list);
        }
        this.getStatistics(list);
        int totalQueuesWait = 0;
        long totalQueuesOverflow = 0L;
        for (StatisticsContainer comp : this.components.values()) {
            totalQueuesWait += list.getValue(comp.getName(), "Total queues wait", 0);
            totalQueuesOverflow += list.getValue(comp.getName(), "Total queues overflow", 0L);
        }
        list.add("total", "Total queues wait", totalQueuesWait, Level.INFO);
        list.add("total", "Total queues overflow", totalQueuesOverflow, Level.INFO);
    }

    public List<String> getComponentsNames() {
        return new ArrayList<String>(this.components.keySet());
    }

    public void getComponentStats(String name, StatisticsList list) {
        StatisticsContainer stats = (StatisticsContainer)this.components.get(name);
        if (stats != null) {
            stats.getStatistics(list);
        }
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart()) && this.isAdmin(from)) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.isAdmin(from)) {
            if (this.getName().equals(jid.getLocalpart()) || this.getComponentId().equals((Object)jid)) {
                List<Element> items = this.serviceEntity.getDiscoItems(node, jid.toString());
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing discoItems for node: {0}, result: {1}", new Object[]{node, items == null ? null : items.toString()});
                }
                return items;
            }
            if (node == null) {
                Element item = this.serviceEntity.getDiscoItem(null, BareJID.toString((String)this.getName(), (String)jid.toString()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing discoItems, result: {0}", item == null ? null : item.toString());
                }
                return Arrays.asList(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "stats", "Server statistics");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "stats", "Server statistics"), new ServiceIdentity("automation", "command-node", "All statistics"), new ServiceIdentity("automation", "command-list", "Statistics retrieving commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof StatisticsContainer;
    }

    @Override
    public void register(Kernel kernel) {
    }

    @Override
    public void unregister(Kernel kernel) {
    }

    public void setArchivizers(StatisticsArchivizerIfc[] archivizers) {
        if (archivizers == null) {
            archivizers = new StatisticsArchivizerIfc[]{};
        }
        List<StatisticsArchivizerIfc> newArchivizers = Arrays.asList(archivizers);
        Arrays.stream(this.archivizers).filter(it -> !newArchivizers.contains(it)).forEach(it -> {
            TimerTask tt = this.archiverTasks.get(it);
            if (tt != null) {
                tt.cancel();
            }
        });
        List<StatisticsArchivizerIfc> oldArchivizers = Arrays.asList(this.archivizers);
        this.archivizers = archivizers;
        Arrays.stream(this.archivizers).filter(it -> !oldArchivizers.contains(it)).filter(it -> it.getFrequency() > 0L).forEach(it -> {
            TimerTask tt = new TimerTask((StatisticsArchivizerIfc)it){
                final /* synthetic */ StatisticsArchivizerIfc val$it;
                {
                    this.val$it = statisticsArchivizerIfc;
                }

                @Override
                public void run() {
                    this.val$it.execute(StatisticsCollector.this.sp);
                }
            };
            this.statsArchivTasks.schedule(tt, it.getFrequency() * 1000L, it.getFrequency() * 1000L);
            this.archiverTasks.put((StatisticsArchivizerIfc)it, tt);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statsUpdated() {
        ArchivizerRunner archivizerRunner = this.arch_runner;
        synchronized (archivizerRunner) {
            this.arch_runner.notifyAll();
        }
        this.esp.update(this.sp);
    }

    private class ArchivizerRunner
    extends Thread {
        private boolean stopped;

        private ArchivizerRunner() {
            super("stats-archivizer");
            this.stopped = false;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    ArchivizerRunner archivizerRunner = this;
                    synchronized (archivizerRunner) {
                        this.wait();
                    }
                    Arrays.stream(StatisticsCollector.this.archivizers).filter(archiv -> archiv.getFrequency() <= 0L).forEach(archiv -> archiv.execute(StatisticsCollector.this.sp));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

