/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.eventbus.events.ShutdownEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigAlias;
import tigase.kernel.beans.config.ConfigAliases;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.net.SocketType;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.xmppclient.C2SIOService;
import tigase.server.xmppclient.ClientTrustManagerFactory;
import tigase.server.xmppclient.IPMonitor;
import tigase.server.xmppclient.RegistrationThrottling;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.server.xmppclient.XMPPIOProcessor;
import tigase.util.Base64;
import tigase.util.common.TimerTask;
import tigase.util.routing.RoutingsContainer;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.StreamError;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="c2s", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.ConnectionManagersMode})
@ClusterModeRequired(active=false)
@ConfigAliases(value={@ConfigAlias(field="delayPortListening", alias="client-port-delay-listening")})
public class ClientConnectionManager
extends ConnectionManager<XMPPIOService<Object>> {
    protected static final String FORCE_REDIRECT_TO_KEY = "force-redirect-to";
    private static final Element FEATURE_PIPELINING = new Element("pipelining ", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:pipelining"});
    private static final Logger log = Logger.getLogger(ClientConnectionManager.class.getName());
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final long SOCKET_CLOSE_WAIT_PROP_DEF = 1L;
    private static final String SOCKET_CLOSE_WAIT_PROP_KEY = "socket-close-wait";
    private static final String TLS_WANT_CLIENT_AUTH_ENABLED_KEY = "tls-want-client-auth-enabled";
    private static final String XMLNS = "jabber:client";
    private static final boolean TLS_WANT_CLIENT_AUTH_ENABLED_DEF = false;
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private final ShutdownTask shutdownTask = new ShutdownTask();
    private final ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private final ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    @Inject
    protected EventBus eventBus;
    @Inject
    protected RoutingsContainer.RoutingComputer routings = null;
    @Inject(nullAllowed=true)
    protected SeeOtherHostIfc see_other_host_strategy = null;
    @Inject
    private ClientTrustManagerFactory clientTrustManagerFactory;
    @ConfigField(desc="Support for pipelining")
    private boolean pipelining = false;
    private IPMonitor ipMonitor = new IPMonitor();
    @Inject(bean="registration-throttling", nullAllowed=true)
    private RegistrationThrottling registrationThrottling;
    private long socket_close_wait_time = 1L;

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getPacketFrom() != null && this.getComponentId().getBareJID().equals((Object)packet.getPacketFrom().getBareJID())) {
            return packet.getPacketFrom().hashCode();
        }
        return packet.getTo().hashCode();
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Processing packet: {0}", packet.toStringSecure());
        }
        if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
            this.processCommand(packet);
        } else if (!this.writePacketToSocket(packet)) {
            this.processUndeliveredPacket(packet, null, "The user connection is no longer active.");
            if (packet.getType() != StanzaType.unavailable && packet.getPacketFrom() != null) {
                if (packet.getStanzaTo() != null) {
                    Packet command2 = Command.STREAM_CLOSED_UPDATE.getPacket(packet.getStanzaTo(), packet.getPacketFrom(), StanzaType.set, UUID.randomUUID().toString());
                    command2.setPacketFrom(packet.getPacketTo());
                    command2.setPacketTo(packet.getPacketFrom());
                    this.addOutPacket(command2);
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Sending a command to close the remote session for non-existen {0} connection: {1}", new Object[]{this.getName(), command2.toStringSecure()});
                    }
                } else if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.FINE, "Stream close update without an user JID, skipping for packet: {0}", new Object[]{packet});
                }
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        JID id = serv.getConnectionId();
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Processing socket data: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
            }
            if (p.getAttributeStaticStr("xmlns") == null) {
                p.setXMLNS(XMLNS);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "XMLNS set for packet: {0} from connection: {1}", new Object[]{p.toStringSecure(), id});
                }
            }
            if (p.getStanzaFrom() != null) {
                p.initVars(null, p.getStanzaTo());
            }
            p.setPacketFrom(id);
            JID receiver = serv.getDataReceiver();
            if (receiver != null) {
                p.setPacketTo(serv.getDataReceiver());
                this.addOutPacket(p);
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Hm, receiver is not set yet stream open was not send by a client or server misconfiguration..., ignoring: {0}, connection: {1}", new Object[]{p.toStringSecure(), serv});
        }
        return null;
    }

    @Override
    public boolean processUndeliveredPacket(Packet packet, Long stamp, String errorMessage) {
        try {
            if (packet.getType() == StanzaType.error || packet.getType() == StanzaType.result) {
                return false;
            }
            if (packet.getElemName() == "presence") {
                return false;
            }
            if (packet.getElemName() == "message") {
                Packet result = C2SDeliveryErrorProcessor.makeDeliveryError(packet, stamp);
                this.processOutPacket(result);
                return true;
            }
            this.processOutPacket(Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, errorMessage, true));
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINER, "exception prepareing request for returning error, data = {0}", packet);
        }
        return true;
    }

    @Override
    public void reconnectionFailed(Map<String, Object> port_props) {
    }

    @Override
    public void serviceStarted(XMPPIOService<Object> service) {
        super.serviceStarted(service);
        String id = this.getUniqueId(service);
        JID connectionId = this.getFromAddress(id);
        service.setConnectionId(connectionId);
        service.setProcessors(this.processors);
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> service) {
        boolean result = super.serviceStopped(service);
        this.xmppStreamClosed(service);
        return result;
    }

    public void setRegistrationThrottling(RegistrationThrottling throttling) {
        if (this.registrationThrottling != null) {
            this.registrationThrottling.stopFor(this.kernel);
        }
        if (throttling != null) {
            throttling.startFor(this.kernel);
        }
        this.registrationThrottling = throttling;
    }

    @Override
    public void start() {
        super.start();
        this.ipMonitor = new IPMonitor();
        this.ipMonitor.start();
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        this.eventBus.unregisterAll(this);
        super.stop();
        this.ipMonitor.stopThread();
    }

    @Override
    public void tlsHandshakeCompleted(XMPPIOService<Object> serv) {
        this.sendTlsHandshakeCompletedToSessionManager(serv);
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream closed: {0}", serv.getConnectionId());
        }
        if (serv.getXMLNS() == XMLNS && serv.getSessionData().get("stream-closed") == null) {
            serv.getSessionData().put("stream-closed", "stream-closed");
            this.ipMonitor.addDisconnect(serv.getRemoteAddress());
            if (serv.getDataReceiver() != null) {
                Packet command2 = Command.STREAM_CLOSED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                String userJid = serv.getUserJid();
                if (userJid != null) {
                    Command.addFieldValue(command2, "user-jid", userJid);
                }
                this.addOutPacketWithTimeout(command2, this.stoppedHandler, 120L, TimeUnit.SECONDS);
                log.log(Level.FINE, "Service stopped, sending packet: {0}", command2);
                this.processSocketData(serv);
                if (userJid != null) {
                    command2 = Command.STREAM_FINISHED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                    this.addOutPacket(command2);
                }
            } else {
                log.fine("Service stopped, before stream:stream received");
            }
            serv.stop();
        }
    }

    @Override
    public String[] xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        BareJID see_other_host;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Stream opened: {0}", attribs);
        }
        String lang = attribs.get("xml:lang");
        String hostname = attribs.get("to");
        String from = attribs.get("from");
        BareJID fromJID = null;
        if (from != null) {
            try {
                fromJID = BareJID.bareJIDInstance((String)from);
            }
            catch (TigaseStringprepException ex) {
                log.log(Level.CONFIG, "From JID violates RFC6122 (XMPP:Address Format): ", ex);
                return this.prepareStreamError(serv, StreamError.ImproperAddressing, null);
            }
        }
        if (lang == null) {
            lang = "en";
        }
        if (hostname == null) {
            return this.prepareStreamError(serv, StreamError.ImproperAddressing, null);
        }
        if (!this.isLocalDomain(hostname)) {
            return this.prepareStreamError(serv, StreamError.HostUnknown, hostname);
        }
        if (!this.isAllowed(serv, hostname)) {
            return this.prepareStreamError(serv, StreamError.PolicyViolation, hostname);
        }
        Integer redirect_port = (Integer)serv.getSessionData().get(FORCE_REDIRECT_TO_KEY);
        if (fromJID != null && this.see_other_host_strategy != null && this.see_other_host_strategy.isEnabled(this.vHostManager.getVHostItem(fromJID.getDomain()), SeeOtherHostIfc.Phase.OPEN) && (see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName())) != null && (redirect_port != null || this.see_other_host_strategy.isRedirectionRequired(this.getDefHostName(), see_other_host))) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Sending redirect for {0} to host {1}, connection {2}.", new Object[]{fromJID, see_other_host, serv});
            }
            return this.prepareSeeOtherHost(serv, fromJID.getDomain(), see_other_host);
        }
        String id = (String)serv.getSessionData().get("sessionID");
        if (id == null) {
            id = UUID.randomUUID().toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "No Session ID, generating a new one: {0}", id);
            }
            serv.getSessionData().put("sessionID", id);
            serv.setXMLNS(XMLNS);
            serv.getSessionData().put("hostname-key", hostname);
            serv.setDataReceiver(JID.jidInstanceNS((String)this.routings.computeRouting(hostname)));
            String streamOpenData = this.prepareStreamOpen(serv, id, hostname);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Writing raw data to the socket: {0}", streamOpenData);
            }
            this.writeRawData(serv, streamOpenData);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "DONE");
            }
            Packet streamOpen = Command.STREAM_OPENED.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, this.newPacketId("c2s-"), Command.DataType.submit);
            Command.addFieldValue(streamOpen, "session-id", id);
            Command.addFieldValue(streamOpen, "hostname", hostname);
            Command.addFieldValue(streamOpen, "xml:lang", lang);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Sending a system command to SM: {0}", streamOpen);
            }
            if (serv instanceof C2SIOService) {
                ((C2SIOService)serv).waitForResponse();
            }
            this.addOutPacketWithTimeout(streamOpen, this.startedHandler, 45L, TimeUnit.SECONDS);
            this.sendTlsHandshakeCompletedToSessionManager(serv);
            log.log(Level.FINER, "DONE 2");
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Session ID is: {0}", id);
            }
            if (serv instanceof C2SIOService && ((C2SIOService)serv).shouldQueueStreamOpened()) {
                String localId = id;
                ((C2SIOService)serv).queueTask(() -> {
                    this.writeRawData(serv, this.prepareStreamOpen(serv, localId, hostname));
                    SocketType socket = (SocketType)((Object)((Object)serv.getSessionData().get("socket")));
                    boolean ssl = socket.equals((Object)SocketType.ssl);
                    ((C2SIOService)serv).waitForResponse();
                    this.addOutPacket(Command.GETFEATURES.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.get, (ssl ? "ssl_" : "") + UUID.randomUUID().toString(), null));
                });
            } else {
                this.writeRawData(serv, this.prepareStreamOpen(serv, id, hostname));
                SocketType socket = (SocketType)((Object)serv.getSessionData().get("socket"));
                boolean ssl = socket.equals((Object)SocketType.ssl);
                if (serv instanceof C2SIOService) {
                    ((C2SIOService)serv).waitForResponse();
                }
                this.addOutPacket(Command.GETFEATURES.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.get, (ssl ? "ssl_" : "") + UUID.randomUUID().toString(), null));
            }
        }
        return null;
    }

    @Override
    public String xmppStreamError(XMPPIOService<Object> serv, List<Element> err_el) {
        return this.prepareStreamError(serv, err_el);
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Client connection manager";
    }

    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHost";
        }
        if (see_other_host_class.equals("none")) {
            return null;
        }
        try {
            this.see_other_host_strategy = (SeeOtherHostIfc)Class.forName(see_other_host_class).newInstance();
            this.setSee_other_host_strategy(this.see_other_host_strategy);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate see_other_host strategy for class: " + see_other_host_class, e);
        }
        return this.see_other_host_strategy;
    }

    public void setSee_other_host_strategy(SeeOtherHostIfc see_other_host_strategy) {
        if (see_other_host_strategy != null) {
            this.see_other_host_strategy = see_other_host_strategy;
            see_other_host_strategy.setNodes(this.getNodesConnectedWithLocal());
        }
    }

    @Override
    public int schedulerThreads() {
        return 2;
    }

    public ClientTrustManagerFactory getClientTrustManagerFactory() {
        return this.clientTrustManagerFactory;
    }

    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        if (serv != null) {
            String serv_sessionId = (String)serv.getSessionData().get("sessionID");
            if (serv_sessionId.equals(command_sessionId)) {
                JID old_receiver = serv.getDataReceiver();
                serv.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.log(Level.WARNING, "Incorrect session ID, ignoring data redirect for: {0}, expected: {1}, received: {2}", new Object[]{newAddress, serv_sessionId, command_sessionId});
        }
        return null;
    }

    protected boolean isAllowed(XMPPIOService<Object> serv, String hostname) {
        int[] allowedPorts;
        VHostItem vhost = this.vHostManager.getVHostItem(hostname);
        return vhost == null || (allowedPorts = vhost.getC2SPortsAllowed()) == null || Arrays.binarySearch(allowedPorts, serv.getLocalPort()) >= 0;
    }

    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    protected ReceiverTimeoutHandler newStoppedHandler() {
        return new StoppedHandler();
    }

    @HandleEvent
    protected void nodeShutdown(ShutdownEvent event) {
        if (event.getNode() == null || !this.getComponentId().getDomain().equals(event.getNode())) {
            return;
        }
        this.addTimerTask(this.shutdownTask, event.getDelay() * 1000L);
    }

    protected void processCommand(Packet packet) {
        Object serv = this.getXMPPIOService(packet);
        Iq iqc = (Iq)packet;
        switch (iqc.getCommand()) {
            case GETFEATURES: {
                if (iqc.getType() != StanzaType.result) break;
                List<Element> features = this.getFeatures((XMPPIOService)serv);
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(features);
                elem_features.addChildren(Command.getData(iqc));
                this.preprocessStreamFeatures((XMPPIOService<Object>)serv, elem_features);
                Packet result = Packet.packetInstance(elem_features, null, null);
                result.setPacketTo(iqc.getTo());
                this.writePacketToSocket(result);
                break;
            }
            case USER_LOGIN: {
                String jid = Command.getFieldValue(iqc, "user-jid");
                if (jid != null) {
                    if (serv != null) {
                        BareJID fromJID = null;
                        try {
                            fromJID = BareJID.bareJIDInstance((String)jid);
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                        if (fromJID != null && this.see_other_host_strategy != null && this.see_other_host_strategy.isEnabled(this.vHostManager.getVHostItem(fromJID.getDomain()), SeeOtherHostIfc.Phase.LOGIN)) {
                            BareJID see_other_host = this.see_other_host_strategy.findHostForJID(fromJID, this.getDefHostName());
                            Integer redirect_port = (Integer)((IOService)serv).getSessionData().get(FORCE_REDIRECT_TO_KEY);
                            if (see_other_host != null && (redirect_port != null || this.see_other_host_strategy.isRedirectionRequired(this.getDefHostName(), see_other_host))) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINEST, "Sending redirect for {0} to host {1}, connection {2}.", new Object[]{fromJID, see_other_host, serv});
                                }
                                String[] redirectMessages = this.prepareSeeOtherHost((XMPPIOService<Object>)serv, fromJID.getDomain(), see_other_host);
                                try {
                                    SocketThread.removeSocketService(serv);
                                    for (String redirectMessage : redirectMessages) {
                                        ((XMPPIOService)serv).writeRawData(redirectMessage);
                                    }
                                    ((XMPPIOService)serv).processWaitingPackets();
                                    Thread.sleep(this.socket_close_wait_time);
                                    ((XMPPIOService)serv).stop();
                                }
                                catch (Exception exception) {}
                                break;
                            }
                            ((XMPPIOService)serv).setUserJid(jid);
                            break;
                        }
                        ((XMPPIOService)serv).setUserJid(jid);
                        break;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    log.log(Level.FINE, "Missing XMPPIOService for USER_LOGIN command: {0}", iqc);
                    break;
                }
                log.log(Level.WARNING, "Missing user-jid for USER_LOGIN command: {0}", iqc);
                break;
            }
            case STARTZLIB: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting zlib compression: {0}", serv);
                    }
                    try {
                        Element compressed = Command.getData(iqc, "compressed", null);
                        Packet p_compressed = Packet.packetInstance(compressed, null, null);
                        SocketThread.removeSocketService(serv);
                        ((XMPPIOService)serv).addPacketToSend(p_compressed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startZLib(9);
                        SocketThread.addSocketService(serv);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Problem enabling zlib compression on the connection: ", ex);
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTZLIB command: {0}", iqc);
                break;
            }
            case STARTTLS: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Starting TLS for connection: {0}", serv);
                    }
                    try {
                        Element proceed = Command.getData(iqc, "proceed", null);
                        Packet p_proceed = Packet.packetInstance(proceed, null, null);
                        SocketThread.removeSocketService(serv);
                        String hostname = (String)((IOService)serv).getSessionData().get("hostname-key");
                        VHostItem vhost = this.getVHostItem(hostname);
                        TrustManager[] x = this.clientTrustManagerFactory.getManager(vhost);
                        boolean wantClientAuth = this.clientTrustManagerFactory.isTlsWantClientAuthEnabled(vhost);
                        boolean needClientAuth = this.clientTrustManagerFactory.isTlsNeedClientAuthEnabled(vhost);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "TLS: wantClientAuth=" + wantClientAuth + "; needClientAuth=" + needClientAuth + " for connection {0}", serv);
                        }
                        ((IOService)serv).setX509TrustManagers(x);
                        ((XMPPIOService)serv).addPacketToSend(p_proceed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startTLS(false, wantClientAuth, needClientAuth);
                        SocketThread.addSocketService(serv);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error starting TLS: {0}", e);
                        ((XMPPIOService)serv).forceStop();
                    }
                    break;
                }
                log.log(Level.WARNING, "Can't find sevice for STARTTLS command: {0}", iqc);
                break;
            }
            case REDIRECT: {
                String command_sessionId = Command.getFieldValue(iqc, "session-id");
                JID newAddress = iqc.getFrom();
                JID old_receiver = this.changeDataReceiver(iqc, newAddress, command_sessionId, (XMPPIOService<Object>)serv);
                if (old_receiver != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Redirecting data for sessionId: {0}, to: {1}", new Object[]{command_sessionId, newAddress});
                    }
                    Packet response = null;
                    response = iqc.commandResult(null);
                    Command.addFieldValue(response, "session-id", command_sessionId);
                    Command.addFieldValue(response, "action", "activate");
                    response.getElement().setAttribute("to", newAddress.toString());
                    this.addOutPacket(response);
                    break;
                }
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "Connection for REDIRECT command does not exist, ignoring packet: {0}", iqc.toStringSecure());
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                if (serv != null) {
                    String streamClose = this.prepareStreamClose((XMPPIOService<Object>)serv);
                    List err_el = packet.getElement().getChildrenStaticStr(Iq.IQ_COMMAND_PATH);
                    boolean moreToSend = false;
                    if (err_el != null && err_el.size() > 0) {
                        streamClose = this.prepareStreamError((XMPPIOService<Object>)serv, err_el) + streamClose;
                        moreToSend = true;
                    }
                    try {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Sending stream close to the client: {0}", streamClose);
                        }
                        ((IOService)serv).getSessionData().put("stream-closing", true);
                        ((XMPPIOService)serv).writeRawData(streamClose);
                        if (moreToSend) {
                            Thread.sleep(this.socket_close_wait_time);
                        }
                    }
                    catch (Exception needClientAuth) {
                        // empty catch block
                    }
                    ((XMPPIOService)serv).stop();
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", iqc);
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (serv != null) {
                    this.addOutPacket(iqc.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.log(Level.INFO, "Error packet is not really expected here: {0}", iqc.toStringSecure());
                }
                break;
            }
            case STREAM_MOVED: {
                if (this.processors == null) break;
                for (XMPPIOProcessor processor : this.processors) {
                    processor.processCommand((XMPPIOService)serv, packet);
                }
                break;
            }
            default: {
                this.writePacketToSocket(iqc);
            }
        }
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5222};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return new int[]{5223};
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        if (this.pipelining) {
            return new C2SIOService<Object>();
        }
        return new XMPPIOService<Object>();
    }

    protected String prepareStreamClose(XMPPIOService<Object> serv) {
        return "</stream:stream>";
    }

    protected String prepareStreamOpen(XMPPIOService<Object> serv, String id, String hostname) {
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "' id='" + id + "' version='1.0' xml:lang='en'>";
    }

    protected String prepareStreamError(XMPPIOService<Object> serv, List<Element> err_el) {
        StreamError streamError = StreamError.getByCondition(err_el.get(0).getName());
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, streamError);
        }
        return "<stream:error>" + err_el.get(0).toString() + "</stream:error>";
    }

    protected String[] prepareStreamError(XMPPIOService<Object> serv, StreamError streamError, String hostname) {
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, streamError);
        }
        return new String[]{"<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + (hostname != null ? hostname : this.getDefVHostItem()) + "' version='1.0' xml:lang='en'><stream:error><" + streamError.getCondition() + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error></stream:stream>"};
    }

    protected String[] prepareSeeOtherHost(XMPPIOService<Object> serv, String hostname, BareJID see_other_host) {
        for (XMPPIOProcessor proc : this.processors) {
            proc.streamError(serv, StreamError.SeeOtherHost);
        }
        Integer redirect_port = (Integer)serv.getSessionData().get(FORCE_REDIRECT_TO_KEY);
        return new String[]{"<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + (hostname != null ? hostname : this.getDefVHostItem()) + "' version='1.0' xml:lang='en'>" + this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", see_other_host, redirect_port).toString() + "</stream:stream>"};
    }

    protected void preprocessStreamFeatures(XMPPIOService<Object> serv, Element elem_features) {
    }

    @Override
    protected void socketAccepted(XMPPIOService serv, SocketType type) {
        if (type == SocketType.ssl) {
            ClientTrustManagerFactory factory = this.getClientTrustManagerFactory();
            TrustManager[] x = factory.getManager(serv);
            serv.setX509TrustManagers(x);
        }
    }

    private void sendTlsHandshakeCompletedToSessionManager(XMPPIOService<Object> serv) {
        String id = (String)serv.getSessionData().get("sessionID");
        if (id == null) {
            return;
        }
        boolean send = false;
        Packet command2 = Command.TLS_HANDSHAKE_COMPLETE.getPacket(serv.getConnectionId(), serv.getDataReceiver(), StanzaType.set, this.newPacketId("c2s-"), Command.DataType.submit);
        Command.addFieldValue(command2, "session-id", id);
        if (serv.getLocalCertificate() != null) {
            try {
                String encodedLocalCertificate = Base64.encode((byte[])serv.getLocalCertificate().getEncoded());
                Command.addFieldValue(command2, "local-certificate", encodedLocalCertificate);
                send = true;
            }
            catch (CertificateEncodingException e) {
                log.log(Level.WARNING, "Can't encode certificate", e);
            }
        }
        if (serv.getTlsUniqueId() != null) {
            String data = Base64.encode((byte[])serv.getTlsUniqueId());
            Command.addFieldValue(command2, "tls-unique-id", data);
            send = true;
        }
        if (serv.getPeerCertificate() != null) {
            try {
                String encodedPeerCertificate = Base64.encode((byte[])serv.getPeerCertificate().getEncoded());
                Command.addFieldValue(command2, "peer-certificate", encodedPeerCertificate);
                send = true;
            }
            catch (CertificateEncodingException e) {
                log.log(Level.WARNING, "Can't encode certificate", e);
            }
        }
        if (send) {
            this.addOutPacket(command2);
        }
    }

    private List<Element> getFeatures(XMPPIOService service) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPIOProcessor proc : this.processors) {
            Element[] features = proc.supStreamFeatures(service);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        if (this.pipelining) {
            results.add(FEATURE_PIPELINING);
        }
        return results;
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName().getDomain(), (String)id);
    }

    private XMPPResourceConnection getXMPPSession(Packet p) {
        Object serv = this.getXMPPIOService(p);
        return serv == null ? null : (XMPPResourceConnection)((IOService)serv).getSessionData().get("xmpp-session");
    }

    private class StoppedHandler
    implements ReceiverTimeoutHandler {
        private StoppedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response for stop received...");
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}; RETRYING", packet.toStringSecure());
            ClientConnectionManager.this.addOutPacketWithTimeout(packet, ClientConnectionManager.this.stoppedHandler, 60L, TimeUnit.SECONDS);
        }
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            XMPPIOService serv = ClientConnectionManager.this.getXMPPIOService(response);
            if (serv != null) {
                if (packet.getType() == StanzaType.error && Authorization.SERVICE_UNAVAILABLE.getCondition().equals(packet.getErrorCondition())) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "could not contact SessionManager, stopping client connection {0}...", serv);
                    }
                    serv.forceStop();
                    return;
                }
                SocketType socket = (SocketType)((Object)serv.getSessionData().get("socket"));
                boolean ssl = socket.equals((Object)SocketType.ssl);
                ClientConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, (ssl ? "ssl_" : "") + UUID.randomUUID().toString(), null));
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.log(Level.INFO, "No response within time limit received for a packet: {0}", packet.toStringSecure());
            Object serv = ClientConnectionManager.this.getXMPPIOService(packet.getFrom().toString());
            if (serv != null) {
                ((XMPPIOService)serv).stop();
            } else {
                log.log(Level.FINE, "Attempt to stop non-existen service for packet: {0}, Service already stopped?", packet);
            }
        }
    }

    private class ShutdownTask
    extends TimerTask {
        private ShutdownTask() {
        }

        @Override
        public void run() {
            Element shudownError = new Element("system-shutdown", new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-streams"});
            ClientConnectionManager.this.doForAllServices(service -> {
                if (service.getUserJid() == null) {
                    return;
                }
                BareJID userJid = BareJID.bareJIDInstanceNS((String)service.getUserJid());
                BareJID seeHost = ClientConnectionManager.this.see_other_host_strategy.findHostForJID(userJid, ClientConnectionManager.this.getDefHostName());
                Element error = null;
                if (seeHost == null || seeHost.getDomain().equals(ClientConnectionManager.this.getComponentId().getDomain())) {
                    error = shudownError.clone();
                } else {
                    Integer redirect_port = (Integer)service.getSessionData().get(ClientConnectionManager.FORCE_REDIRECT_TO_KEY);
                    error = ClientConnectionManager.this.see_other_host_strategy.getStreamError("urn:ietf:params:xml:ns:xmpp-streams", seeHost, redirect_port).getChild("see-other-host");
                }
                Packet packet = Command.CLOSE.getPacket(ClientConnectionManager.this.getComponentId(), service.getConnectionId(), StanzaType.set, "shutdown");
                Element command2 = packet.getElement().findChild(Iq.IQ_COMMAND_PATH);
                command2.addChild((XMLNodeIfc)error);
                ClientConnectionManager.this.addPacket(packet);
            });
        }
    }
}

