/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.DSLBeanConfigurator;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigReader;
import tigase.conf.ConfiguratorAbstract;
import tigase.conf.LoggingBean;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.MDPoolBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.KernelException;
import tigase.kernel.beans.Autostart;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyGrapher;
import tigase.kernel.core.Kernel;
import tigase.net.ConnectionOpenThread;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.MessageRouter;
import tigase.server.XMPPServer;
import tigase.server.monitor.MonitorRuntime;
import tigase.sys.ShutdownHook;
import tigase.util.dns.DNSResolverDefault;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.dns.DNSResolverIfc;
import tigase.util.reflection.ClassUtilBean;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;

public class Bootstrap {
    private static final Logger log = Logger.getLogger(Bootstrap.class.getCanonicalName());
    private final Kernel kernel;
    private final ShutdownHook shutdownHook = new BootstrapShutdownHook();
    private ConfigHolder config = new ConfigHolder();
    private Map<String, String> loggingSetup = new LinkedHashMap<String, String>(10);

    public Bootstrap() {
        this.kernel = new Kernel("root");
    }

    private void configureLogManager() {
        Map<String, Object> cfg = this.prepareLogManagerConfiguration(this.config.getProperties());
        this.setupLogManager(cfg);
    }

    public <T> T getInstance(String beanName) {
        return this.kernel.getInstance(beanName);
    }

    public <T> T getInstance(Class<T> clazz) {
        return this.kernel.getInstance(clazz);
    }

    protected Kernel getKernel() {
        return this.kernel;
    }

    public void init(String[] args) throws ConfigReader.ConfigException, IOException {
        this.config.loadConfiguration(args);
        this.configureLogManager();
    }

    private void initializeAutostartBeans(Kernel kernel) {
        log.config("Starting 'autostart' beans in kernel " + kernel.getName());
        for (BeanConfig bc : kernel.getDependencyManager().getBeanConfigs()) {
            Kernel sk;
            if (Kernel.class.isAssignableFrom(bc.getClazz()) && (sk = (Kernel)kernel.getInstance(bc.getBeanName())) != kernel) {
                this.initializeAutostartBeans(sk);
                continue;
            }
            Autostart autostart = bc.getClazz().getAnnotation(Autostart.class);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Checking for autostart " + bc.getKernel().getName() + "." + bc.getBeanName() + ":: state=" + (Object)((Object)bc.getState()) + "; autostart=" + (autostart != null));
            }
            if (bc.getState() != BeanConfig.State.registered && bc.getState() != BeanConfig.State.initialized || autostart == null) continue;
            log.config("Autostarting bean " + bc);
            kernel.getInstance(bc.getBeanName());
        }
    }

    private void initializeDnsResolver() {
        Map resolverConfig = (Map)this.config.getProperties().get("dns-resolver");
        if (resolverConfig != null) {
            DNSResolverIfc resolver;
            String resolverClass = (String)resolverConfig.get("tigase-resolver-class");
            if (resolverClass != null) {
                DNSResolverFactory.setDnsResolverClassName((String)resolverClass);
            }
            if ((resolver = DNSResolverFactory.getInstance()) instanceof DNSResolverDefault) {
                String host;
                Object config = resolverConfig.get("tigase-primary-address");
                if (config instanceof ConfigReader.AbstractEnvironmentPropertyVariable) {
                    config = ((ConfigReader.AbstractEnvironmentPropertyVariable)config).calculateValue();
                }
                if ((host = (String)config) != null && !host.isEmpty()) {
                    ((DNSResolverDefault)resolver).setPrimaryHost(host);
                }
                if ((config = resolverConfig.get("tigase-secondary-address")) instanceof ConfigReader.AbstractEnvironmentPropertyVariable) {
                    config = ((ConfigReader.AbstractEnvironmentPropertyVariable)config).calculateValue();
                }
                if ((host = (String)config) != null && !host.isEmpty()) {
                    ((DNSResolverDefault)resolver).setSecondaryHost(host);
                }
            }
        }
    }

    private Map<String, Object> prepareLogManagerConfiguration(Map<String, Object> params) {
        String[] packs;
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        String levelStr = ".level";
        defaults.put("logging/" + levelStr, "CONFIG");
        defaults.put("logging/handlers", "java.util.logging.ConsoleHandler java.util.logging.FileHandler");
        defaults.put("logging/java.util.logging.ConsoleHandler.formatter", "tigase.util.log.LogFormatter");
        defaults.put("logging/java.util.logging.ConsoleHandler.level", "WARNING");
        defaults.put("logging/java.util.logging.FileHandler.append", "true");
        defaults.put("logging/java.util.logging.FileHandler.count", "5");
        defaults.put("logging/java.util.logging.FileHandler.formatter", "tigase.util.log.LogFormatter");
        defaults.put("logging/java.util.logging.FileHandler.limit", "10000000");
        defaults.put("logging/java.util.logging.FileHandler.pattern", "logs/tigase.log");
        defaults.put("logging/tigase.useParentHandlers", "true");
        defaults.put("logging/java.util.logging.FileHandler.level", "ALL");
        defaults.put("logging/tigase.kernel.core.Kernel.level", "CONFIG");
        if (params.get("--debug") != null) {
            for (String pack : packs = ((String)params.get("--debug")).split(",")) {
                defaults.put("logging/tigase." + pack + ".level", "ALL");
            }
        }
        if (params.get("--debug-packages") != null) {
            for (String pack : packs = ((String)params.get("--debug-packages")).split(",")) {
                defaults.put("logging/" + pack + ".level", "ALL");
            }
        }
        return defaults;
    }

    public void setProperties(Map<String, Object> props) {
        this.config.setProperties(props);
    }

    private void setupLogManager(Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> entries = properties.entrySet();
        StringBuilder buff = new StringBuilder(200);
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getKey().startsWith("logging/")) continue;
            String key = entry.getKey().substring("logging/".length());
            this.loggingSetup.put(key, entry.getValue().toString());
        }
        for (String key : this.loggingSetup.keySet()) {
            File log_path;
            String entry = this.loggingSetup.get(key);
            buff.append(key).append("=").append(entry).append("\n");
            if (!key.equals("java.util.logging.FileHandler.pattern") || (log_path = new File(entry).getParentFile()).exists()) continue;
            log_path.mkdirs();
        }
        ConfiguratorAbstract.loadLogManagerConfig(buff.toString());
        log.config("DONE");
    }

    public void start() {
        DataSourceBean dataSource;
        this.initializeDnsResolver();
        Object clusterMode = this.config.getProperties().getOrDefault("cluster-mode", this.config.getProperties().getOrDefault("--cluster-mode", Boolean.FALSE));
        if (clusterMode instanceof ConfigReader.Variable && (clusterMode = ((ConfigReader.Variable)clusterMode).calculateValue()) == null) {
            clusterMode = Boolean.FALSE;
        }
        if (clusterMode instanceof String) {
            clusterMode = Boolean.parseBoolean((String)clusterMode);
        }
        if (((Boolean)clusterMode).booleanValue()) {
            System.setProperty("tigase.cache", "false");
            log.log(Level.WARNING, "Tigase cache turned off");
        }
        this.config.getProperties().put("cluster-mode", clusterMode);
        Optional.ofNullable((String)this.config.getProperties().get("stringprep-processor")).ifPresent(val -> BareJID.useStringprepProcessor((String)val));
        for (Map.Entry<String, Object> e : this.config.getProperties().entrySet()) {
            if (!e.getKey().startsWith("--")) continue;
            String key = e.getKey().substring(2);
            Object value = e.getValue();
            if (value instanceof ConfigReader.Variable) {
                value = ((ConfigReader.Variable)value).calculateValue();
            }
            System.setProperty(key, value.toString());
        }
        try {
            ClassUtilBean classUtilBean = null;
            classUtilBean = XMPPServer.isOSGi() ? (ClassUtilBean)Class.forName("tigase.osgi.util.ClassUtilBean").newInstance() : (ClassUtilBean)Class.forName("tigase.util.reflection.ClassUtilBean").newInstance();
            classUtilBean.initialize(ClassUtilBean.getPackagesToSkip(null));
            this.kernel.registerBean("classUtilBean").asInstance(classUtilBean).exportable().exec();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        this.kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        this.kernel.registerBean("eventBus").asInstance(EventBusFactory.getInstance()).exportable().exec();
        DSLBeanConfigurator configurator = this.kernel.getInstance(DSLBeanConfigurator.class);
        configurator.setConfigHolder(this.config);
        ModulesManagerImpl.getInstance().setBeanConfigurator(configurator);
        this.kernel.registerBean("logging").asClass(LoggingBean.class).setActive(true).setPinned(true).exec();
        this.kernel.getInstance("logging");
        this.kernel.registerBean("beanSelector").asInstance(new ServerBeanSelector()).exportable().exec();
        this.kernel.registerBean(RosterFactory.Bean.class).setPinned(true).exec();
        this.kernel.getInstance(RosterFactory.Bean.class);
        configurator.registerBeans(null, null, this.config.getProperties());
        DependencyGrapher dg = new DependencyGrapher();
        dg.setKernel(this.kernel);
        log.log(Level.CONFIG, dg.getDependencyGraph());
        if (ServerBeanSelector.getConfigType(this.kernel) != ConfigTypeEnum.SetupMode && ((dataSource = this.kernel.getInstance(DataSourceBean.class)) == null || dataSource.getDataSourceNames().isEmpty())) {
            throw new KernelException("Failed to initialize data sources!");
        }
        MessageRouter mr = (MessageRouter)this.kernel.getInstance("message-router");
        log.info("Starting MessageRouter");
        mr.start();
        try {
            log.fine("Dump configuration");
            File f = new File("etc/config-dump.properties");
            if (f.exists()) {
                f.delete();
            }
            configurator.dumpConfiguration(f);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "failed to dump configuration to file etc/config-dump.properties");
        }
        MonitorRuntime.getMonitorRuntime().addShutdownHook(this.shutdownHook);
        this.initializeAutostartBeans(this.kernel);
    }

    public void stop() {
        this.kernel.shutdown((bc1, bc2) -> {
            if (MDPoolBean.class.isAssignableFrom(bc1.getClazz())) {
                return Integer.MIN_VALUE;
            }
            if (MDPoolBean.class.isAssignableFrom(bc2.getClazz())) {
                return Integer.MIN_VALUE;
            }
            return 0;
        });
    }

    public class BootstrapShutdownHook
    implements ShutdownHook {
        @Override
        public String getName() {
            return "bootstrap-shutdown";
        }

        @Override
        public String shutdown() {
            ConnectionOpenThread.getInstance().stop();
            long start = System.currentTimeMillis();
            try {
                Bootstrap.this.stop();
            }
            catch (Throwable ex) {
                System.out.println("Warning: failed to shutdown Tigase Kernel with error: " + ex.getMessage());
                ex.printStackTrace();
                return ex.getMessage();
            }
            long end = System.currentTimeMillis();
            return "Tigase Kernel stopped in " + (end - start) + "ms";
        }
    }
}

