/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import tigase.io.CertificateContainerIfc;
import tigase.io.SSLContextContainerIfc;
import tigase.kernel.beans.Inject;

public abstract class SSLContextContainerAbstract
implements SSLContextContainerIfc {
    private static final Logger log = Logger.getLogger(SSLContextContainerAbstract.class.getCanonicalName());
    @Inject
    private final CertificateContainerIfc certificateContainer;
    private SecureRandom secureRandom = new SecureRandom();

    public static <T> T find(Map<String, T> data, String key) {
        String asteriskKey;
        T value;
        if (data.containsKey(key)) {
            return data.get(key);
        }
        int idx = key.indexOf(".");
        if (idx >= 0 && (value = data.get(asteriskKey = "*" + key.substring(idx))) != null) {
            data.put(key, value);
            return value;
        }
        return null;
    }

    public SSLContextContainerAbstract(CertificateContainerIfc certContainer) {
        this.certificateContainer = certContainer;
    }

    @Override
    public void addCertificates(Map<String, String> params) throws CertificateParsingException {
        this.certificateContainer.addCertificates(params);
    }

    protected KeyManager[] createCertificate(String alias) throws Exception {
        return this.certificateContainer.createCertificate(alias);
    }

    protected SSLHolder createContextHolder(String protocol, String hostname, String alias, boolean clientMode, TrustManager[] tms) throws Exception {
        SSLContext sslContext = null;
        KeyManager[] kms = this.getKeyManagers(hostname);
        if (kms == null) {
            if (clientMode) {
                sslContext = SSLContext.getInstance(protocol);
                sslContext.init(null, tms, this.secureRandom);
                return new SSLHolder(tms, sslContext, null);
            }
            kms = this.createCertificate(alias);
        }
        X509Certificate crt = null;
        if (kms.length > 0 && kms[0] instanceof X509KeyManager) {
            X509KeyManager km = (X509KeyManager)kms[0];
            X509Certificate[] zzz = km.getCertificateChain(hostname);
            crt = zzz.length == 0 ? null : zzz[zzz.length - 1];
        }
        sslContext = SSLContext.getInstance(protocol);
        sslContext.init(kms, tms, this.secureRandom);
        return new SSLHolder(tms, sslContext, crt);
    }

    protected String getDefCertAlias() {
        return this.certificateContainer.getDefCertAlias();
    }

    protected KeyManager[] getKeyManagers(String hostname) {
        return this.certificateContainer.getKeyManagers(hostname);
    }

    @Override
    public SSLContext getSSLContext(String protocol, String hostname, boolean clientMode) {
        return this.getSSLContext(protocol, hostname, clientMode, null);
    }

    protected TrustManager[] getTrustManagers() {
        return this.certificateContainer.getTrustManagers();
    }

    @Override
    public KeyStore getTrustStore() {
        return this.certificateContainer != null ? this.certificateContainer.getTrustStore() : null;
    }

    protected class SSLHolder {
        final X509Certificate domainCertificate;
        final SSLContext sslContext;
        final TrustManager[] tms;

        public SSLHolder(TrustManager[] tms, SSLContext sslContext, X509Certificate domainCertificate) {
            this.tms = tms;
            this.sslContext = sslContext;
            this.domainCertificate = domainCertificate;
        }

        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        public boolean isValid(TrustManager[] tms) {
            return tms == this.tms;
        }
    }
}

