/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterConnectionManager;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.eventbus.EventListener;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.ServiceChecker;
import tigase.server.bosh.BoshConnectionManager;
import tigase.server.xmppclient.SeeOtherHostIfc;
import tigase.util.common.TimerTask;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.jid.JID;

@Bean(name="bosh", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.ConnectionManagersMode})
@ClusterModeRequired(active=true)
public class BoshConnectionClustered
extends BoshConnectionManager
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(BoshConnectionClustered.class.getName());
    private EventListener<ClusterConnectionManager.ClusterInitializedEvent> clusterEventHandler = null;

    public BoshConnectionClustered() {
        this.delayPortListening = true;
    }

    @Override
    public void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        List<JID> connectedNodes = this.getNodesConnectedWithLocal();
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(connectedNodes);
        }
        final String hostname = jid.getDomain();
        this.doForAllServices(new ServiceChecker<XMPPIOService<Object>>(){

            @Override
            public void check(XMPPIOService<Object> service) {
                JID dataReceiver = service.getDataReceiver();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Checking service for dataReceiver: {0}", dataReceiver);
                }
                if (dataReceiver != null && dataReceiver.getDomain().equals(hostname)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Stopping service because corresponding cluster node stopped.");
                    }
                    service.stop();
                }
            }
        });
    }

    @Override
    public String getDiscoDescription() {
        return super.getDiscoDescription() + " clustered";
    }

    @Override
    public SeeOtherHostIfc getSeeOtherHostInstance(String see_other_host_class) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Configuring see_other_host clustered strategy for: " + see_other_host_class);
        }
        if (see_other_host_class == null) {
            see_other_host_class = "tigase.server.xmppclient.SeeOtherHostHashed";
        }
        this.see_other_host_strategy = super.getSeeOtherHostInstance(see_other_host_class);
        List<JID> connectedNodes = this.getNodesConnectedWithLocal();
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(connectedNodes);
        }
        return this.see_other_host_strategy;
    }

    @Override
    public void start() {
        super.start();
        if (this.clusterEventHandler == null) {
            this.clusterEventHandler = event -> {
                this.connectWaitingTasks();
                log.log(Level.WARNING, "Starting listening on ports of component: {0}", this.getName());
                this.eventBus.removeListener(this.clusterEventHandler);
            };
        }
        this.eventBus.addListener(ClusterConnectionManager.ClusterInitializedEvent.class, this.clusterEventHandler);
        if (this.delayPortListening) {
            this.addTimerTask(new TimerTask(){

                @Override
                public void run() {
                    log.log(Level.FINE, "Cluster synchronization timed-out, starting pending connections for " + BoshConnectionClustered.this.getName());
                    BoshConnectionClustered.this.connectWaitingTasks();
                }
            }, this.connectionDelay * 30L);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.eventBus.removeListener(this.clusterEventHandler);
        this.clusterEventHandler = null;
    }

    @Override
    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        List<JID> connectedNodes = this.getNodesConnectedWithLocal();
        if (this.see_other_host_strategy != null) {
            this.see_other_host_strategy.setNodes(connectedNodes);
        }
    }
}

