/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.SessionAware;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.auth.credentials.Credentials;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.db.AuthRepository;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public class PlainCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
DomainAware,
SessionAware {
    protected String domain;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected AuthRepository repo;
    private XMPPResourceConnection session;
    private boolean accountDisabled = false;
    private String username;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        if (this.accountDisabled) {
            authCallback.setAuthorized(false);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "User {0} is disabled", this.jid);
            }
            return;
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        authCallback.setAuthorized(true);
        this.session.removeSessionData("authentication-jid");
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof RealmCallback) {
            this.handleRealmCallback((RealmCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof AuthorizationIdCallback) {
            this.handleAuthorizationIdCallback((AuthorizationIdCallback)callback);
        } else if (callback instanceof VerifyPasswordCallback) {
            this.handleVerifyPasswordCallback((VerifyPasswordCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        this.username = "default";
        this.setJid(BareJID.bareJIDInstanceNS((String)nc.getDefaultName(), (String)this.domain));
        nc.setName(this.jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", this.username);
        }
    }

    protected void handleRealmCallback(RealmCallback rc) throws IOException {
        String realm = this.domain;
        if (realm != null) {
            rc.setText(realm);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "RealmCallback: {0}", realm);
        }
    }

    protected void handleVerifyPasswordCallback(VerifyPasswordCallback pc) throws IOException {
        String password = pc.getPassword();
        try {
            Credentials credentials = this.repo.getCredentials(this.jid, this.username);
            Credentials.Entry entry = credentials.getEntryForMechanism("PLAIN");
            if (entry == null) {
                entry = credentials.getFirst();
            }
            this.accountDisabled = credentials.isAccountDisabled();
            pc.setVerified(entry != null && entry.verifyPlainPassword(password));
        }
        catch (Exception e) {
            pc.setVerified(false);
            throw new IOException("Password verification problem.", e);
        }
    }

    private void handleAuthorizationIdCallback(AuthorizationIdCallback callback) {
        if (!AbstractSasl.isAuthzIDIgnored() && callback.getAuthzId() != null && !callback.getAuthzId().equals(this.jid.toString())) {
            try {
                this.username = this.jid.getLocalpart();
                this.setJid(BareJID.bareJIDInstance((String)callback.getAuthzId()));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            this.username = "default";
            callback.setAuthzId(this.jid.toString());
        }
    }

    private void setJid(BareJID jid) {
        this.jid = jid;
        if (jid != null) {
            this.session.putSessionData("authentication-jid", jid);
        }
    }
}

