/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.adhoc;

import tigase.auth.adhoc.AbstractCredentialsCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.TigaseDBException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.server.xmppsession.SessionManager;
import tigase.xmpp.jid.BareJID;

@Bean(name="auth-credentials-delete", parent=SessionManager.class, active=true)
public class DeleteUserCredentials
extends AbstractCredentialsCommand {
    public static final String NODE = "auth-credentials-delete";

    @Override
    public String getName() {
        return "Delete user credentials";
    }

    @Override
    public String getNode() {
        return NODE;
    }

    @Override
    protected void processForm(Form form, AdhHocRequest request, AdHocResponse response) throws TigaseDBException, AdHocCommandException {
        BareJID jid = BareJID.bareJIDInstanceNS((String)form.getAsString("jid"));
        this.checkIfCanModifyJID(request, jid);
        String username = form.getAsString("username");
        if (username == null || username.trim().isEmpty()) {
            username = "default";
        }
        Form resp = new Form("result", null, null);
        this.authRepository.removeCredential(jid, username.trim());
        resp.addField(Field.fieldFixed((String)"OK"));
        response.getElements().add(resp.getElement());
        response.completeSession();
    }

    @Override
    protected void processNoForm(AdhHocRequest request, AdHocResponse response) {
        Form form = new Form("form", this.getName(), null);
        form.addField(Field.fieldJidSingle((String)"jid", null, (String)"The Jabber ID for the account"));
        form.addField(Field.fieldJidSingle((String)"username", null, (String)"Username"));
        response.startSession();
        response.getElements().add(form.getElement());
    }
}

