/*
 * Decompiled with CFR 0.152.
 */
package tigase.auditlog;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auditlog.Entry;
import tigase.auditlog.LogRepository;
import tigase.auditlog.LogSearchableRepository;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"jdbc:mysql:.*"})
@Repository.SchemaId(id="auditlog", name="Tigase AuditLog Component")
public class JDBCRepository
implements LogRepository,
LogSearchableRepository<DataRepository>,
RepositoryVersionAware {
    private static final Logger a = Logger.getLogger(JDBCRepository.class.getCanonicalName());
    private static final String b = "append-entry-query";
    private static final String c = "get-active-connections-query";
    private static final String d = "get-last-connections-query";
    private static final String e = "get-connections-stats-query";
    private static final String f = "get-connections-states-query";
    private static final String g = "get-connected-users-query";
    private static final String h = "get-disconnected-users-query";
    private static final String i = "mark-users-from-cluster-node-as-disconnected-query";
    @ConfigField(desc="Append entry query", alias="append-entry-query")
    private String appendQuery = "{ call Tig_AuditLog_Append(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?) }";
    private DataRepository j;
    @ConfigField(desc="Get active connections query", alias="get-active-connections-query")
    private String getActiveConnectionsQuery = "{ call Tig_AuditLog_GetActiveConnections(?,?) }";
    @ConfigField(desc="Get connected users query", alias="get-connected-users-query")
    private String getConnectedUsersQuery = "{ call Tig_AuditLog_GetConnectedUsers(?,?) }";
    @ConfigField(desc="Get connections states query", alias="get-connections-states-query")
    private String getConnectionsStatesQuery = "{ call Tig_AuditLog_GetConnectionsStates(?,?,?,?) }";
    @ConfigField(desc="Get connections statistics query", alias="get-connections-stats-query")
    private String getConnectionsStatsQuery = "{ call Tig_AuditLog_GetConnectionsStatistics(?,?,?) }";
    @ConfigField(desc="Get disconnected users query", alias="get-disconnected-users-query")
    private String getDisconnectedUsersQuery = "{ call Tig_AuditLog_GetDisconnectedUsers(?,?) }";
    @ConfigField(desc="Get last connections query", alias="get-last-connections-query")
    private String getLastConnectionsQuery = "{ call Tig_AuditLog_GetLastConnections(?,?) }";
    @ConfigField(desc="Mark users from cluster node as disconnected query", alias="mark-users-from-cluster-node-as-disconnected-query")
    private String markUsersFromClusterNodeAsDisconnectedQuery = "{ call Tig_AuditLog_ClusterNodeShutdown(?,?) }";
    @ConfigField(desc="Repository name")
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public void setDataSource(DataRepository dataSource) throws RepositoryException {
        try {
            dataSource.initPreparedStatement(b, this.appendQuery);
            dataSource.initPreparedStatement(c, this.getActiveConnectionsQuery);
            dataSource.initPreparedStatement(d, this.getLastConnectionsQuery);
            dataSource.initPreparedStatement(e, this.getConnectionsStatsQuery);
            dataSource.initPreparedStatement(f, this.getConnectionsStatesQuery);
            dataSource.initPreparedStatement(g, this.getConnectedUsersQuery);
            dataSource.initPreparedStatement(h, this.getDisconnectedUsersQuery);
            dataSource.initPreparedStatement(i, this.markUsersFromClusterNodeAsDisconnectedQuery);
            this.j = dataSource;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Failed to initialize " + this.getClass().getCanonicalName(), (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Entry entry) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "adding entry for jid: {0}, session: {1}, ip: {2}, time: {3}, cluster node: {4}, type: {5}, subtype: {6}", new Object[]{entry.getUserJID(), entry.getSessionId(), entry.getClientIP(), entry.getWhen(), entry.getClusterNode(), entry.getType(), entry.getSubtype()});
            }
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(entry.hashCode(), b);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, entry.getId());
                preparedStatement.setString(2, entry.getSessionId());
                preparedStatement.setString(3, entry.getClientIP());
                preparedStatement.setString(4, entry.getClusterNode());
                preparedStatement.setString(5, entry.getDomain());
                JID jID = entry.getUserJID();
                if (jID != null) {
                    preparedStatement.setString(6, jID.getBareJID().toString());
                    preparedStatement.setString(7, jID.getResource());
                } else {
                    preparedStatement.setString(6, null);
                    preparedStatement.setString(7, null);
                }
                preparedStatement.setTimestamp(8, new Timestamp(entry.getWhen().getTime()));
                preparedStatement.setString(9, entry.getType());
                preparedStatement.setString(10, entry.getSubtype());
                preparedStatement.setString(11, entry.getStanzaId());
                preparedStatement.setString(12, entry.getConversationId());
                preparedStatement.setString(13, entry.getErrorCondition());
                preparedStatement.setString(14, entry.getErrorMessage());
                preparedStatement.execute();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not append entry to auditlog", (Throwable)sQLException);
        }
    }

    @Override
    public List<Entry> getCachedEntries(int offset, int limit) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogSearchableRepository.ConnectionHistory> getActiveConnections(BareJID userJID) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering active connections of user " + userJID);
            }
            ArrayList<LogSearchableRepository.ConnectionHistory> arrayList = new ArrayList<LogSearchableRepository.ConnectionHistory>();
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(userJID, c);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, userJID.toString());
                preparedStatement.setNull(2, 12);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        arrayList.add(ConnectionHistoryImpl.d(resultSet));
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of active connections", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogSearchableRepository.ConnectionHistory> getLastConnections(BareJID userJID) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering last active connections of user " + userJID);
            }
            ArrayList<LogSearchableRepository.ConnectionHistory> arrayList = new ArrayList<LogSearchableRepository.ConnectionHistory>();
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(userJID, d);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, userJID.toString());
                preparedStatement.setNull(2, 12);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        arrayList.add(ConnectionHistoryImpl.f(resultSet));
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of last connections", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LogSearchableRepository.ConnectionStatistics getConnectionStatistics(BareJID userJID, Date from, Date to) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering connection statistics of user {0} between {1} and {2}", new Object[]{userJID, from, to});
            }
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(userJID, e);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, userJID.toString());
                preparedStatement.setTimestamp(2, new Timestamp(from.getTime()));
                preparedStatement.setTimestamp(3, new Timestamp(to.getTime()));
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        LogSearchableRepository.ConnectionStatistics connectionStatistics = ConnectionStatisticsImpl.b(resultSet);
                        return connectionStatistics;
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
                return null;
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve connection statistics", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogSearchableRepository.ConnectionHistory> getConnectionHistory(BareJID userJID, Date from, Date to) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering connections history of user {0} between {1} and {2}", new Object[]{userJID, from, to});
            }
            ArrayList<LogSearchableRepository.ConnectionHistory> arrayList = new ArrayList<LogSearchableRepository.ConnectionHistory>();
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(userJID, f);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, userJID.toString());
                preparedStatement.setNull(2, 12);
                preparedStatement.setTimestamp(3, new Timestamp(from.getTime()));
                preparedStatement.setTimestamp(4, new Timestamp(to.getTime()));
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        arrayList.add(ConnectionHistoryImpl.e(resultSet));
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of last connections", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogSearchableRepository.ConnectionEntry> getConnectedUsers(String domain, String userLike) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering list of connected users for domain {0} matching filter {1}", new Object[]{domain, userLike});
            }
            ArrayList<LogSearchableRepository.ConnectionEntry> arrayList = new ArrayList<LogSearchableRepository.ConnectionEntry>();
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(domain.hashCode(), g);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, domain);
                preparedStatement.setString(2, userLike);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        arrayList.add(ConnectionEntryImpl.b(resultSet));
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of connected users", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogSearchableRepository.ConnectionEntry> getDisconnectedUsers(String domain, String userLike) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "quering list of disconnected users for domain {0} matching filter {1}", new Object[]{domain, userLike});
            }
            ArrayList<LogSearchableRepository.ConnectionEntry> arrayList = new ArrayList<LogSearchableRepository.ConnectionEntry>();
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(domain.hashCode(), h);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, domain);
                preparedStatement.setString(2, userLike);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        arrayList.add(ConnectionEntryImpl.b(resultSet));
                    }
                }
                finally {
                    this.j.release(null, resultSet);
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of disconnected users", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markUsersAsDisconnected(String clusterNode, Date timestamp) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "marking all users connected to cluster node {0} as disconnected with timestamp {1}", new Object[]{clusterNode, timestamp});
            }
            PreparedStatement preparedStatement2 = preparedStatement = this.j.getPreparedStatement(clusterNode.hashCode(), i);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, clusterNode);
                preparedStatement.setTimestamp(2, new Timestamp(timestamp.getTime()));
                preparedStatement.execute();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("could not retrieve list of disconnected users", (Throwable)sQLException);
        }
    }

    public static class ConnectionStatisticsImpl
    implements LogSearchableRepository.ConnectionStatistics {
        private Double a;
        private int b;
        private int c;
        private int d;

        private static LogSearchableRepository.ConnectionStatistics b(ResultSet resultSet) throws SQLException {
            ConnectionStatisticsImpl connectionStatisticsImpl = new ConnectionStatisticsImpl();
            connectionStatisticsImpl.b = resultSet.getInt(1);
            connectionStatisticsImpl.c = resultSet.getInt(2);
            connectionStatisticsImpl.d = resultSet.getInt(3);
            connectionStatisticsImpl.a = resultSet.getDouble(4);
            return connectionStatisticsImpl;
        }

        @Override
        public int getNumberOfConnections() {
            return this.b;
        }

        @Override
        public int getNumberOfDisconnections() {
            return this.c;
        }

        @Override
        public int getNumberOfConnectionFailures() {
            return this.d;
        }

        @Override
        public Double getAvgConnectionDuration() {
            return this.a;
        }
    }

    public static class ConnectionHistoryImpl
    implements LogSearchableRepository.ConnectionHistory {
        private String a;
        private String b;
        private Double c;
        private String d;
        private String e;
        private String f;
        private String g;
        private Date h;
        private String i;
        private BareJID j;

        private static LogSearchableRepository.ConnectionHistory d(ResultSet resultSet) throws SQLException {
            ConnectionHistoryImpl connectionHistoryImpl = new ConnectionHistoryImpl();
            connectionHistoryImpl.f = resultSet.getString(1);
            connectionHistoryImpl.h = resultSet.getTimestamp(2);
            connectionHistoryImpl.a = resultSet.getString(3);
            connectionHistoryImpl.b = resultSet.getString(4);
            connectionHistoryImpl.c = resultSet.getDouble(5);
            return connectionHistoryImpl;
        }

        private static LogSearchableRepository.ConnectionHistory e(ResultSet resultSet) throws SQLException {
            ConnectionHistoryImpl connectionHistoryImpl = new ConnectionHistoryImpl();
            connectionHistoryImpl.f = resultSet.getString(1);
            connectionHistoryImpl.h = resultSet.getTimestamp(2);
            Optional.ofNullable(resultSet.getString(3)).map(BareJID::bareJIDInstanceNS).ifPresent(connectionHistoryImpl::a);
            connectionHistoryImpl.i = resultSet.getString(4);
            connectionHistoryImpl.g = resultSet.getString(5);
            connectionHistoryImpl.a = resultSet.getString(6);
            connectionHistoryImpl.b = resultSet.getString(7);
            connectionHistoryImpl.c = resultSet.getDouble(8);
            connectionHistoryImpl.d = resultSet.getString(9);
            connectionHistoryImpl.e = resultSet.getString(10);
            return connectionHistoryImpl;
        }

        private static LogSearchableRepository.ConnectionHistory f(ResultSet resultSet) throws SQLException {
            ConnectionHistoryImpl connectionHistoryImpl = new ConnectionHistoryImpl();
            connectionHistoryImpl.f = resultSet.getString(1);
            connectionHistoryImpl.h = resultSet.getTimestamp(2);
            connectionHistoryImpl.a = resultSet.getString(3);
            connectionHistoryImpl.b = resultSet.getString(4);
            connectionHistoryImpl.c = resultSet.getDouble(5);
            return connectionHistoryImpl;
        }

        @Override
        public String getSessionId() {
            return this.f;
        }

        @Override
        public Date getTimestamp() {
            return this.h;
        }

        @Override
        public String getClientIP() {
            return this.a;
        }

        @Override
        public String getClusterNode() {
            return this.b;
        }

        @Override
        public Double getDuration() {
            return this.c;
        }

        @Override
        public BareJID getUserJID() {
            return this.j;
        }

        private void a(BareJID bareJID) {
            this.j = bareJID;
        }

        @Override
        public String getType() {
            return this.i;
        }

        @Override
        public String getSubtype() {
            return this.g;
        }

        @Override
        public String getErrorConditon() {
            return this.d;
        }

        @Override
        public String getErrorMessage() {
            return this.e;
        }
    }

    public static class ConnectionEntryImpl
    implements LogSearchableRepository.ConnectionEntry {
        private BareJID a;
        private Date b;
        private Double c;

        private static LogSearchableRepository.ConnectionEntry b(ResultSet resultSet) throws SQLException {
            ConnectionEntryImpl connectionEntryImpl = new ConnectionEntryImpl();
            Optional.ofNullable(resultSet.getString(1)).map(BareJID::bareJIDInstanceNS).ifPresent(connectionEntryImpl::a);
            connectionEntryImpl.b = resultSet.getTimestamp(2);
            connectionEntryImpl.c = resultSet.getDouble(3);
            return connectionEntryImpl;
        }

        @Override
        public BareJID getUserJID() {
            return this.a;
        }

        private void a(BareJID bareJID) {
            this.a = bareJID;
        }

        @Override
        public Date getFrom() {
            return this.b;
        }

        @Override
        public Double getDuration() {
            return this.c;
        }
    }
}

