/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories;

import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.repositories.InMemoryPushRepository;
import tigase.xmpp.jid.BareJID;

@Bean(name="pushRepository", parent=PushNotificationsComponent.class, active=true)
public class PushRepositoryMDBean
extends MDRepositoryBeanWithStatistics<IPushRepository>
implements IPushRepository {
    public PushRepositoryMDBean() {
        super(new Class[]{IPushRepository.class});
    }

    public Class<?> getDefaultBeanClass() {
        return PushRepositoryConfigBean.class;
    }

    @Override
    public IPushSettings registerDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException {
        return ((IPushRepository)this.getRepository(serviceJid.getDomain())).registerDevice(serviceJid, userJid, provider, deviceId);
    }

    @Override
    public IPushSettings unregisterDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException, ComponentException {
        return ((IPushRepository)this.getRepository(serviceJid.getDomain())).unregisterDevice(serviceJid, userJid, provider, deviceId);
    }

    @Override
    public IPushSettings getNodeSettings(BareJID serviceJid, String node) throws RepositoryException {
        return ((IPushRepository)this.getRepository(serviceJid.getDomain())).getNodeSettings(serviceJid, node);
    }

    @Override
    public IPushSettings getNodeSettings(BareJID userJid, String provider, String deviceId) throws RepositoryException {
        return this.getNodeSettings(provider, deviceId).filter(iPushSettings -> iPushSettings.getOwenerJid().equals((Object)userJid)).findFirst().orElse(null);
    }

    @Override
    public Stream<IPushSettings> getNodeSettings(String provider, String deviceId) throws RepositoryException {
        return this.getRepositories().values().stream().flatMap(iPushRepository -> {
            Stream<Object> stream;
            try {
                stream = iPushRepository.getNodeSettings(provider, deviceId);
            }
            catch (RepositoryException repositoryException) {
                stream = Stream.empty();
            }
            return stream;
        });
    }

    public void setDataSource(DataSource dataSource) {
    }

    protected Class<? extends IPushRepository> findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(IPushRepository.class, (String)dataSource.getResourceUri());
    }

    public static class PushRepositoryConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<IPushRepository> {
        protected Class<?> getRepositoryClassName() throws DBInitException, ClassNotFoundException {
            String string = this.getCls();
            if (string == null) {
                string = "default";
            }
            switch (string) {
                case "memory": {
                    return InMemoryPushRepository.class;
                }
            }
            return super.getRepositoryClassName();
        }
    }
}

