/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.push.Device;
import tigase.push.PushSettings;
import tigase.push.api.IPushSettings;
import tigase.push.repositories.AbstractPushRepository;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:.*"})
@Repository.SchemaId(id="push", name="Tigase Push Component")
public class JDBCPushRepository
extends AbstractPushRepository<DataRepository>
implements RepositoryVersionAware {
    private static final Logger a = Logger.getLogger(JDBCPushRepository.class.getCanonicalName());
    protected DataRepository repo;
    @ConfigField(desc="Query to retrieve settings for a node with provider and device id", alias="get-node-settings-by-device-query")
    private String getNodeSettingsByDeviceQuery = "{ call Tig_Push_GetNodeSettingsByDevice(?,?) }";
    @ConfigField(desc="Query to retrieve settings for a node with service jid and node", alias="get-node-settings-by-node-query")
    private String getNodeSettingsByNodeQuery = "{ call Tig_Push_GetNodeSettingsByNode(?,?) }";
    @ConfigField(desc="Query to register device", alias="register-device-query")
    private String registerDeviceQuery = "{ call Tig_Push_RegisterDevice(?,?,?,?,?) }";
    @ConfigField(desc="Query to unregister device", alias="unregister-device-query")
    private String unregisterDeviceQuery = "{ call Tig_Push_UnregisterDevice(?,?,?,?,?) }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPushSettings registerDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException {
        String string = this.calculateNode(serviceJid, userJid);
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.repo.getPreparedStatement(userJid, this.registerDeviceQuery);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, serviceJid.toString());
                preparedStatement.setString(2, userJid.toString());
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, provider);
                preparedStatement.setString(5, deviceId);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not register device", (Throwable)sQLException);
        }
        return this.getNodeSettings(serviceJid, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPushSettings unregisterDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException, ComponentException {
        Object object;
        String string = this.calculateNode(serviceJid, userJid);
        IPushSettings iPushSettings = this.getNodeSettings(serviceJid, string);
        if (iPushSettings != null) {
            object = new Device(provider, deviceId);
            iPushSettings = iPushSettings.removeDevice((IPushSettings.IDevice)object);
        }
        if (iPushSettings == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Device is not registered");
        }
        try {
            Object object2 = object = this.repo.getPreparedStatement(userJid, this.unregisterDeviceQuery);
            synchronized (object2) {
                object.setString(1, serviceJid.toString());
                object.setString(2, userJid.toString());
                object.setString(3, string);
                object.setString(4, provider);
                object.setString(5, deviceId);
                object.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not unregister device", (Throwable)sQLException);
        }
        return iPushSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPushSettings getNodeSettings(BareJID serviceJid, String node) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.repo.getPreparedStatement(node.hashCode(), this.getNodeSettingsByNodeQuery);
            synchronized (preparedStatement2) {
                PushSettings pushSettings;
                ResultSet resultSet;
                block8: {
                    resultSet = null;
                    preparedStatement.setString(1, serviceJid.toString());
                    preparedStatement.setString(2, node);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) break block8;
                    IPushSettings iPushSettings = null;
                    this.repo.release(null, resultSet);
                    return iPushSettings;
                }
                try {
                    int n = 1;
                    BareJID bareJID = BareJID.bareJIDInstanceNS((String)resultSet.getString(n++));
                    ArrayList<IPushSettings.IDevice> arrayList = new ArrayList<IPushSettings.IDevice>();
                    do {
                        arrayList.add(this.readDevice(resultSet, n));
                    } while (resultSet.next());
                    pushSettings = new PushSettings(serviceJid, node, bareJID, arrayList);
                }
                catch (Throwable throwable) {
                    this.repo.release(null, resultSet);
                    throw throwable;
                }
                this.repo.release(null, resultSet);
                return pushSettings;
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not retrieve setting by service jid and node", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stream<IPushSettings> getNodeSettings(String provider, String deviceId) throws RepositoryException {
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.repo.getPreparedStatement(deviceId.hashCode(), this.getNodeSettingsByDeviceQuery);
            synchronized (preparedStatement2) {
                Object object;
                ResultSet resultSet;
                block8: {
                    resultSet = null;
                    preparedStatement.setString(1, provider);
                    preparedStatement.setString(2, deviceId);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) break block8;
                    Stream<IPushSettings> stream = null;
                    this.repo.release(null, resultSet);
                    return stream;
                }
                try {
                    ArrayList<IPushSettings> arrayList = new ArrayList<IPushSettings>();
                    do {
                        object = BareJID.bareJIDInstanceNS((String)resultSet.getString(1));
                        BareJID bareJID = BareJID.bareJIDInstanceNS((String)resultSet.getString(2));
                        String string = resultSet.getString(3);
                        IPushSettings iPushSettings = arrayList.stream().filter(arg_0 -> JDBCPushRepository.a((BareJID)object, bareJID, string, arg_0)).findFirst().orElseGet(() -> JDBCPushRepository.a((BareJID)object, string, bareJID));
                        arrayList.remove(iPushSettings);
                        arrayList.add(iPushSettings.addDevice(this.readDevice(resultSet, 4)));
                    } while (resultSet.next());
                    object = arrayList.stream();
                }
                catch (Throwable throwable) {
                    this.repo.release(null, resultSet);
                    throw throwable;
                }
                this.repo.release(null, resultSet);
                return object;
            }
        }
        catch (SQLException sQLException) {
            throw new RepositoryException("Could not retrieve setting by provider and device id", (Throwable)sQLException);
        }
    }

    public void setDataSource(DataRepository dataSource) {
        try {
            this.initRepo(dataSource);
            this.repo = dataSource;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to initialize access to SQL database for JDBCPushRepository", sQLException);
        }
    }

    protected IPushSettings.IDevice readDevice(ResultSet rs, int i) throws SQLException {
        String string = rs.getString(i++);
        String string2 = rs.getString(i++);
        return new Device(string, string2);
    }

    protected void initRepo(DataRepository repo) throws SQLException {
        repo.initPreparedStatement(this.registerDeviceQuery, this.registerDeviceQuery);
        repo.initPreparedStatement(this.unregisterDeviceQuery, this.unregisterDeviceQuery);
        repo.initPreparedStatement(this.getNodeSettingsByNodeQuery, this.getNodeSettingsByNodeQuery);
        repo.initPreparedStatement(this.getNodeSettingsByDeviceQuery, this.getNodeSettingsByDeviceQuery);
    }

    private static /* synthetic */ IPushSettings a(BareJID bareJID, String string, BareJID bareJID2) {
        return new PushSettings(bareJID, string, bareJID2, Collections.emptyList());
    }

    private static /* synthetic */ boolean a(BareJID bareJID, BareJID bareJID2, String string, IPushSettings iPushSettings) {
        return iPushSettings.getServiceJid().equals((Object)bareJID) && iPushSettings.getOwenerJid().equals((Object)bareJID2) && iPushSettings.getNode().equals(string);
    }
}

