/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.push.Device;
import tigase.push.PushSettings;
import tigase.push.api.IPushSettings;
import tigase.push.repositories.AbstractPushRepository;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

public class InMemoryPushRepository
extends AbstractPushRepository {
    private final ConcurrentHashMap<Key, IPushSettings> a = new ConcurrentHashMap();

    @Override
    public IPushSettings registerDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException {
        String string = this.calculateNode(serviceJid, userJid);
        Key key2 = new Key(serviceJid, string);
        Device device = new Device(provider, deviceId);
        return this.a.compute(key2, (key, iPushSettings) -> (iPushSettings == null ? new PushSettings(serviceJid, string, userJid, new ArrayList<IPushSettings.IDevice>()) : iPushSettings).addDevice(device));
    }

    @Override
    public IPushSettings unregisterDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId) throws RepositoryException, ComponentException {
        Device device = new Device(provider, deviceId);
        String string = this.calculateNode(serviceJid, userJid);
        Key key2 = new Key(serviceJid, string);
        IPushSettings iPushSettings2 = this.a.computeIfPresent(key2, (key, iPushSettings) -> iPushSettings.removeDevice(device));
        if (iPushSettings2 == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Device is not registered");
        }
        if (iPushSettings2.getDevices().isEmpty()) {
            this.a.remove(key2, iPushSettings2);
        }
        return iPushSettings2;
    }

    @Override
    public IPushSettings getNodeSettings(BareJID serviceJid, String node) {
        return this.a.get(new Key(serviceJid, node));
    }

    @Override
    public Stream<IPushSettings> getNodeSettings(String provider, String deviceId) throws RepositoryException {
        Device device = new Device(provider, deviceId);
        return this.a.values().stream().filter(iPushSettings -> iPushSettings.getDevices().contains(device));
    }

    public void setDataSource(DataSource dataSource) {
    }

    public static class Key {
        private final String a;
        private final BareJID b;

        public Key(BareJID serviceJid, String node) {
            this.b = serviceJid;
            this.a = node;
        }

        public int hashCode() {
            return this.b.hashCode() * 31 + this.a.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.b.equals((Object)((Key)obj).b) && this.a.equals(((Key)obj).a);
        }

        public String toString() {
            return "NodeKey[serviceJid = " + this.b.toString() + ", node = " + this.a + "]";
        }
    }
}

