/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import groovy.json.JsonSlurper;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.JaxmppCore;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XMPPException;
import tigase.jaxmpp.core.client.XmppModule;
import tigase.jaxmpp.core.client.criteria.Criteria;
import tigase.jaxmpp.core.client.criteria.ElementCriteria;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.stanzas.Message;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.j2se.Jaxmpp;
import tigase.push.fcm.FcmProvider;

public class FcmConnection
implements JaxmppCore.LoggedInHandler,
JaxmppCore.LoggedOutHandler {
    private static final Logger a = Logger.getLogger(FcmConnection.class.getCanonicalName());
    private static final String b = "fcm-xmpp.googleapis.com";
    private Jaxmpp c = new Jaxmpp();
    private FcmProvider d = null;

    public FcmConnection(String serverKey, String senderId, boolean testing) {
        this.c.getModulesManager().register((XmppModule)new FcmModule(this));
        this.c.getEventBus().addHandler(JaxmppCore.LoggedInHandler.LoggedInEvent.class, (EventHandler)this);
        this.c.getEventBus().addHandler(JaxmppCore.LoggedOutHandler.LoggedOutEvent.class, (EventHandler)this);
        this.c.getConnectionConfiguration().setUserJID(BareJID.bareJIDInstance((String)senderId, (String)b));
        this.c.getConnectionConfiguration().setUserPassword(serverKey);
        this.c.getConnectionConfiguration().setServer(b);
        this.c.getConnectionConfiguration().setPort(testing ? 5236 : 5235);
        this.c.getSessionObject().setUserProperty("USE_PLAIN_SSL_KEY", (Object)true);
        this.c.getSessionObject().setUserProperty("LOGIN_USER_NAME", (Object)(senderId + "@gcm.googleapis.com"));
        this.c.getSessionObject().setUserProperty("SASL#FORCE_AUTHZID", (Object)false);
    }

    public void setProvider(FcmProvider handler) {
        this.d = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            Jaxmpp jaxmpp = this.c;
            synchronized (jaxmpp) {
                if (this.c.getConnector().getState() == Connector.State.disconnected) {
                    this.c.login();
                }
            }
        }
        catch (JaxmppException jaxmppException) {
            this.c.getEventBus().fire((Event)new JaxmppCore.LoggedOutHandler.LoggedOutEvent(this.c.getSessionObject()));
        }
    }

    public void stop() {
        try {
            this.c.disconnect();
        }
        catch (JaxmppException jaxmppException) {
            a.log(Level.FINEST, "Could not stop connection to FCM", jaxmppException);
        }
    }

    public void onLoggedIn(SessionObject sessionObject) {
        if (this.d != null) {
            this.d.connected(this);
        }
    }

    public void onLoggedOut(SessionObject sessionObject) {
        if (this.d != null) {
            this.d.disconnected(this);
            this.start();
        }
    }

    public void sendNotification(String payload) throws JaxmppException {
        if (!this.c.isConnected()) {
            this.start();
            throw new JaxmppException("Connection to FCM server not ready");
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "sending notification, data = " + payload);
        }
        Element element = ElementFactory.create((String)"gcm", (String)payload, (String)"google:mobile:data");
        Message message = Message.createMessage();
        message.addChild(element);
        this.c.send((Stanza)message);
    }

    private void a(String string) {
        if (this.d != null) {
            this.d.unregisterDevice(string);
        }
    }

    public static class FcmModule
    implements XmppModule {
        private static final Criteria a = ElementCriteria.name((String)"message");
        private FcmConnection b;

        public FcmModule(FcmConnection conn) {
            this.b = conn;
        }

        public Criteria getCriteria() {
            return a;
        }

        public String[] getFeatures() {
            return new String[0];
        }

        public void process(Element message) throws XMPPException, XMLException, JaxmppException {
            Element element = message.getFirstChild("gcm");
            if (element == null || !"google:mobile:data".equals(element.getXMLNS())) {
                return;
            }
            String string = element.getValue();
            try {
                Map map = (Map)new JsonSlurper().parse(string.getBytes("UTF-8"));
                Object v = map.get("message_type");
                if (v == null) {
                    a.log(Level.FINEST, "Received upstream message, ignoring...");
                    return;
                }
                switch (v.toString()) {
                    case "ack": {
                        this.a(map);
                        break;
                    }
                    case "nack": {
                        this.b(map);
                        break;
                    }
                    case "receipt": {
                        a.log(Level.FINEST, "Received upstream message of type receipt, data = " + string);
                        break;
                    }
                    case "control": {
                        this.c(map);
                    }
                    default: {
                        a.log(Level.FINER, "Received upstream message of unknown type, type " + v + ", data = " + string);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Exception processing message received from FCM, data = " + string, exception);
            }
        }

        private void a(Map<String, Object> map) {
        }

        private void b(Map<String, Object> map) {
            String string = (String)map.get("error");
            if (string == null) {
                a.log(Level.FINEST, "Received NACK without an error code!");
                return;
            }
            switch (string) {
                case "BAD_REGISTRATION": 
                case "DEVICE_UNREGISTERED": {
                    String string2 = (String)map.get("registration_id");
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "Received NACK with type " + string + ", unregistering device id " + string2);
                    }
                    this.b.a(string2);
                    break;
                }
                default: {
                    a.log(Level.FINER, "Received NACK with error = " + string + ", message = " + map.get("error_description"));
                }
            }
        }

        private void c(Map<String, Object> map) {
            String string = (String)map.get("control_type");
            if ("CONNECTION_DRAINING".equals(string)) {
                this.b.stop();
            } else {
                a.log(Level.FINEST, "Received control packet with unknown type = " + string + ", data = " + map);
            }
        }
    }
}

