/*
 * Decompiled with CFR 0.152.
 */
package tigase.push;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.MsgRepositoryIfc;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.OfflineMessages;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:push:0", parent=SessionManager.class, active=false, exportable=true)
@Id(value="urn:xmpp:push:0")
@DiscoFeatures(value={"urn:xmpp:push:0"})
@Handles(value={@Handle(path={"iq", "enable"}, xmlns="urn:xmpp:push:0"), @Handle(path={"iq", "disable"}, xmlns="urn:xmpp:push:0")})
public class PushNotifications
extends AnnotatedXMPPProcessor
implements XMPPProcessorIfc,
OfflineMessages.Notifier {
    protected static final String XMLNS = "urn:xmpp:push:0";
    protected static final String ID = "urn:xmpp:push:0";
    private static final Logger a = Logger.getLogger(PushNotifications.class.getCanonicalName());
    private static final String b = "jabber:x:data";
    private static final String c = "urn:xmpp:push:0:summary";
    private static final SimpleParser d = SingletonFactory.getParserInstance();
    @Inject
    private MsgRepositoryIfc msgRepository;
    @Inject
    private UserRepository userRepository;

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository nonAuthUserRepository, Queue<Packet> results, Map<String, Object> map) throws XMPPException {
        try {
            if (session == null || !session.getConnectionId().equals((Object)packet.getPacketFrom())) {
                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, null, true));
                return;
            }
            Element element2 = packet.getElement().findChild(element -> element.getXMLNS() == "urn:xmpp:push:0");
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Processing PUSH registration, jid: {0}, actionEl: {1}", new Object[]{session.getjid(), element2});
            }
            if (element2 != null) {
                String string = element2.getAttributeStaticStr("jid");
                if (string == null) {
                    throw new TigaseStringprepException("JID is NULL!");
                }
                JID jID = JID.jidInstance((String)element2.getAttributeStaticStr("jid"));
                String string2 = element2.getAttributeStaticStr("node");
                switch (element2.getName()) {
                    case "enable": {
                        this.enableNotifications(session, jID, string2, element2, element2.findChild(element -> element.getXMLNS() == b && element.getName() == "x"));
                        break;
                    }
                    case "disable": {
                        this.disableNotifications(session, jID, string2);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
                        return;
                    }
                }
                results.offer(packet.okResult((Element)null, 0));
            }
        }
        catch (NotAuthorizedException notAuthorizedException) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Session is not authorized", true));
        }
        catch (TigaseDBException tigaseDBException) {
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true));
        }
        catch (TigaseStringprepException tigaseStringprepException) {
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Attribute 'jid' is not valid JID of Push Notifications service", true));
        }
    }

    public void notifyNewOfflineMessage(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> map) {
        if (packet.getElemName() != "message") {
            return;
        }
        try {
            this.a(packet, results);
        }
        catch (UserNotFoundException userNotFoundException) {
            a.log(Level.FINEST, "Could not send push notification for message " + packet, userNotFoundException);
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Could not send push notification for message " + packet, tigaseDBException);
        }
    }

    public void notifyOfflineMessagesRetrieved(XMPPResourceConnection session, Queue<Packet> results) {
        try {
            BareJID bareJID = session.getBareJID();
            Map<String, Element> map = this.a(bareJID);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Offline messages retrieved push notifications for JID: {0}, pushServices: {1}", new Object[]{bareJID, map});
            }
            if (map.isEmpty()) {
                return;
            }
            this.notifyOfflineMessagesRetrieved(bareJID, map.values(), results::offer);
        }
        catch (UserNotFoundException | NotAuthorizedException throwable) {
            a.log(Level.FINEST, "Could not send push notification about offline message retrieval by " + session, throwable);
        }
        catch (TigaseDBException tigaseDBException) {
            a.log(Level.WARNING, "Could not send push notification about offline message retrieval by " + session, tigaseDBException);
        }
    }

    protected void notifyOfflineMessagesRetrieved(BareJID userJid, Collection<Element> pushServices, Consumer<Packet> results) {
        Element element = new Element("notification", new String[]{"xmlns"}, new String[]{"urn:xmpp:push:0"});
        Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{b});
        element.addChild((XMLNodeIfc)element2);
        DataForm.addFieldValue((Element)element, (String)"message-count", (String)String.valueOf(0L));
        this.sendPushNotification(userJid, pushServices, element, results);
    }

    protected void enableNotifications(XMPPResourceConnection session, JID jid, String node, Element enableElem, Element optionsForm) throws NotAuthorizedException, TigaseDBException {
        Element element = this.createSettingsElement(jid, node, enableElem, optionsForm);
        this.enableNotifications(session, jid, node, element);
    }

    protected Element createSettingsElement(JID jid, String node, Element enableElem, Element optionsForm) {
        Element element = new Element("settings", new String[]{"jid", "node"}, new String[]{jid.toString(), node.toString()});
        if (optionsForm != null) {
            element.addChild((XMLNodeIfc)optionsForm);
        }
        return element;
    }

    protected void enableNotifications(XMPPResourceConnection session, JID jid, String node, Element settings) throws NotAuthorizedException, TigaseDBException {
        String string = jid.toString() + "/" + node;
        session.setData("urn:xmpp:push:0", string, settings.toString());
        Map<String, Element> map = this.getPushServices(session);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Enabled push notifications for JID: {0}, node: {1}, settings: {2}", new Object[]{jid, node, settings.toString()});
        }
        map.put(string, settings);
    }

    protected void disableNotifications(XMPPResourceConnection session, JID jid, String node) throws NotAuthorizedException, TigaseDBException {
        Map<String, Element> map = this.getPushServices(session);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Disabled push notifications for JID: {0}, node: {1}, pushServices: {2}", new Object[]{jid, node, map});
        }
        if (map != null) {
            if (node != null) {
                String string = jid.toString() + "/" + node;
                map.remove(string);
                session.removeData("urn:xmpp:push:0", string);
            } else {
                String string = jid.toString() + "/";
                ArrayList arrayList = new ArrayList();
                map.keySet().removeIf(string2 -> {
                    if (string2.startsWith(string)) {
                        arrayList.add(string2);
                        return true;
                    }
                    return false;
                });
                for (String string3 : arrayList) {
                    session.removeData("urn:xmpp:push:0", string3);
                }
            }
        }
    }

    protected Map<String, Element> getPushServices(XMPPResourceConnection session) {
        return (Map)session.computeCommonSessionDataIfAbsent("urn:xmpp:push:0", string -> {
            ConcurrentHashMap<String, Element> concurrentHashMap = new ConcurrentHashMap<String, Element>();
            try {
                concurrentHashMap.putAll(this.a(session.getBareJID()));
            }
            catch (UserNotFoundException | NotAuthorizedException throwable) {
                a.log(Level.FINEST, "Could not load push services for session " + session, throwable);
            }
            catch (TigaseDBException tigaseDBException) {
                a.log(Level.WARNING, "Could not load push services for session " + session, tigaseDBException);
            }
            return concurrentHashMap;
        });
    }

    protected Element prepareNotificationPayload(Packet packet, long msgCount) {
        Element element = new Element("notification", new String[]{"xmlns"}, new String[]{"urn:xmpp:push:0"});
        Element element2 = new Element("x", new String[]{"xmlns"}, new String[]{b});
        element.addChild((XMLNodeIfc)element2);
        DataForm.addFieldValue((Element)element, (String)"FORM_TYPE", (String)c);
        DataForm.addFieldValue((Element)element, (String)"message-count", (String)String.valueOf(msgCount));
        DataForm.addFieldValue((Element)element, (String)"last-message-sender", (String)packet.getStanzaFrom().toString());
        DataForm.addFieldValue((Element)element, (String)"last-message-body", (String)packet.getElemCDataStaticStr(Message.MESSAGE_BODY_PATH));
        return element;
    }

    protected void sendPushNotification(BareJID userJid, Collection<Element> pushServices, Element notification, Consumer<Packet> results) {
        pushServices.forEach(element3 -> {
            try {
                JID jID = JID.jidInstance((String)element3.getAttributeStaticStr("jid"));
                String string = element3.getAttributeStaticStr("node");
                Element element4 = element3.findChild(element -> element.getXMLNS() == b && element.getName() == "x");
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Push notifications for JID: {0}, notification: {1}, pushServices: {2}", new Object[]{userJid, notification, jID});
                }
                this.a(userJid, notification, jID, string, element4, results);
            }
            catch (Exception exception) {
                a.log(Level.FINE, "Could not publish notification for " + userJid + " to " + element3.getAttributeStaticStr("jid") + " at " + element3.getAttributeStaticStr("node"));
            }
        });
    }

    private Map<String, Element> a(BareJID bareJID) throws TigaseDBException {
        String[] stringArray = this.userRepository.getKeys(bareJID, "urn:xmpp:push:0");
        if (stringArray == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        for (String string : stringArray) {
            String string2 = this.userRepository.getData(bareJID, "urn:xmpp:push:0", string);
            if (string2 == null) continue;
            Element element = this.a(string2);
            hashMap.put(string, element);
        }
        return hashMap;
    }

    private Element a(Packet packet) throws TigaseDBException {
        Map map = this.msgRepository.getMessagesCount(packet.getStanzaTo());
        return this.prepareNotificationPayload(packet, map.getOrDefault(MsgRepository.MSG_TYPES.message, 0L));
    }

    private void a(Packet packet, Queue<Packet> queue) throws TigaseDBException {
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        Map<String, Element> map = this.a(bareJID);
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Sending push notifications for JID: {0}, packet: {1}, pushServices: {2}", new Object[]{bareJID, packet, map});
        }
        if (map.isEmpty()) {
            return;
        }
        Element element = this.a(packet);
        this.sendPushNotification(bareJID, map.values(), element, queue::offer);
    }

    private void a(BareJID bareJID, Element element, JID jID, String string, Element element2, Consumer<Packet> consumer) {
        Element element3 = new Element("iq", new String[]{"xmlns", "type"}, new String[]{"jabber:client", StanzaType.set.name()});
        element3.setAttribute("id", "" + System.nanoTime());
        Element element4 = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        element3.addChild((XMLNodeIfc)element4);
        Element element5 = new Element("publish", new String[]{"node"}, new String[]{string});
        element4.addChild((XMLNodeIfc)element5);
        Element element6 = new Element("item");
        element5.addChild((XMLNodeIfc)element6);
        element6.addChild((XMLNodeIfc)element);
        if (element2 != null) {
            Element element7 = new Element("publish-options");
            element7.addChild((XMLNodeIfc)element2);
            element4.addChild((XMLNodeIfc)element7);
        }
        consumer.accept((Packet)new Iq(element3, JID.jidInstance((BareJID)bareJID), jID));
    }

    private Element a(String string) {
        DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
        d.parse((SimpleHandler)domBuilderHandler, string.toCharArray(), 0, string.length());
        Queue queue = domBuilderHandler.getParsedElements();
        return queue == null ? null : (Element)queue.poll();
    }
}

