/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.server.Packet;
import tigase.spam.ResultsAwareSpamFilter;
import tigase.spam.SpamFilter;
import tigase.spam.SpamProcessor;
import tigase.spam.filters.AbstractSpamFilter;
import tigase.stats.StatisticsList;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="known-spammers", parent=SpamProcessor.class, active=true)
public class KnownSpammersFilter
extends AbstractSpamFilter
implements ResultsAwareSpamFilter,
ConfigurationChangedAware,
Initializable {
    protected static final String ID = "known-spammers";
    private static final Logger log = Logger.getLogger(KnownSpammersFilter.class.getCanonicalName());
    @ConfigField(desc="Ban time", alias="ban-time")
    private long banTime = 15L;
    @ConfigField(desc="Cache time", alias="cache-time")
    private long cacheTime = 10080L;
    private TimerTask cleanUpTimerTask;
    private boolean disableAccount = true;
    private double disableAccountProbability = 1.0;
    private long disabledAccounts = 0L;
    private long localSpammers = 0L;
    @ConfigField(desc="Print spammers", alias="print-spammers")
    private boolean printSpammers = false;
    @ConfigField(desc="Print spammers frequency", alias="print-spammers-frequency")
    private long printSpammersFrequency = 1440L;
    private TimerTask printSpammersTimerTask;
    private long remoteSpammers = 0L;
    private ConcurrentHashMap<BareJID, Spammer> spammers = new ConcurrentHashMap();
    private Timer timer;

    @Override
    public void identifiedSpam(Packet packet, XMPPResourceConnection session, SpamFilter filter) {
        JID from = packet.getStanzaFrom();
        if (from == null && session != null) {
            from = session.getjid();
        }
        if (from == null) {
            return;
        }
        Spammer spammer = this.spammers.computeIfAbsent(from.getBareJID(), this::createSpammer);
        if (filter != this) {
            spammer.spamDetected(filter);
        }
        try {
            if (session != null && session.isAuthorized() && session.isUserId(from.getBareJID())) {
                spammer.localUser();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Local user {0} was detected as a spammer, closing session for this user...", new Object[]{from});
                }
                session.putSessionData("error-key", (Object)"policy-violation");
                session.logout();
                if (spammer.hasProbabilityReached(this.disableAccountProbability)) {
                    try {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "Disabling account {0} as it is most likely a spammer, probability > {1}", new Object[]{from, this.disableAccountProbability});
                        }
                        session.getAuthRepository().setAccountStatus(from.getBareJID(), AuthRepository.AccountStatus.disabled);
                        ++this.disabledAccounts;
                    }
                    catch (TigaseDBException ex) {
                        log.log(Level.WARNING, "Failed to disable spammer account " + from + " due to repository exception", ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Could not logout user " + from, ex);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public double getSpamProbability() {
        return 0.0;
    }

    public void beanConfigurationChanged(Collection<String> collection) {
        if (this.cleanUpTimerTask != null) {
            this.cleanUpTimerTask.cancel();
            this.timer.purge();
        }
        if (this.printSpammersTimerTask != null) {
            this.printSpammersTimerTask.cancel();
            this.timer.purge();
        }
        if (this.timer != null) {
            this.cleanUpTimerTask = new TimerTask(){

                @Override
                public void run() {
                    KnownSpammersFilter.this.cleanUp();
                }
            };
            this.timer.schedule(this.cleanUpTimerTask, 60000L, 60000L);
            this.printSpammersTimerTask = new TimerTask(){

                @Override
                public void run() {
                    KnownSpammersFilter.this.printSpammers();
                }
            };
            this.timer.schedule(this.printSpammersTimerTask, this.printSpammersFrequency * 60L * 1000L, this.printSpammersFrequency * 60L * 1000L);
        }
    }

    public void initialize() {
        this.timer = new Timer(ID, true);
        this.beanConfigurationChanged(Collections.emptyList());
    }

    @Override
    public void getStatistics(String name, StatisticsList list) {
        super.getStatistics(name, list);
        if (list.checkLevel(Level.FINE)) {
            list.add(name, this.getId() + "/Known spammers", this.spammers.size(), Level.FINE);
            list.add(name, this.getId() + "/Known local spammers", this.localSpammers, Level.FINE);
            list.add(name, this.getId() + "/Known remote spammers", this.remoteSpammers, Level.FINE);
            list.add(name, this.getId() + "/Disabled accounts", this.disabledAccounts, Level.FINE);
        }
    }

    @Override
    protected boolean filterPacket(Packet packet, XMPPResourceConnection session) {
        JID from = packet.getStanzaFrom();
        if (from == null) {
            return true;
        }
        Spammer spammer = this.spammers.get(from.getBareJID());
        return spammer == null || spammer.hasTimeoutPassed(this.banTime * 60L * 1000L);
    }

    private Spammer createSpammer(BareJID spammerJid) {
        return new Spammer(spammerJid);
    }

    private void cleanUp() {
        if (!this.spammers.isEmpty()) {
            this.spammers.entrySet().stream().filter(e -> ((Spammer)e.getValue()).hasProbabilityReached(this.disableAccountProbability)).map(e -> (BareJID)e.getKey()).forEach(this.spammers::remove);
            this.spammers.entrySet().stream().filter(e -> ((Spammer)e.getValue()).hasTimeoutPassed(this.cacheTime * 60L * 1000L)).map(e -> (BareJID)e.getKey()).forEach(this.spammers::remove);
        }
    }

    private void printSpammers() {
        if (log.isLoggable(Level.FINEST) || this.printSpammers) {
            Map grouped = this.spammers.values().stream().collect(Collectors.groupingBy(spammer -> spammer.isLocalUser(), Collectors.toList()));
            List<Spammer> list = grouped.getOrDefault(true, Collections.emptyList());
            this.localSpammers = list.size();
            this.printSpammersGroup(this.printSpammers ? Level.INFO : Level.FINEST, true, list);
            list = grouped.getOrDefault(false, Collections.emptyList());
            this.remoteSpammers = list.size();
            this.printSpammersGroup(this.printSpammers ? Level.INFO : Level.FINEST, false, list);
        }
    }

    private void printSpammersGroup(Level level, boolean local, List<Spammer> spammers) {
        String name = local ? "local" : "remote";
        Map spammersByDomain = spammers.stream().collect(Collectors.groupingBy(spammer -> spammer.getJID().getDomain(), Collectors.toList()));
        List<String> sortedDomains = spammersByDomain.keySet().stream().sorted().collect(Collectors.toList());
        log.log(level, "Detected {0} {3} spammers for {1} domains {2}", new Object[]{spammers.size(), spammersByDomain.size(), sortedDomains, name});
        sortedDomains.forEach(domain -> log.log(level, "For {3} domain {0} detected {1} spammers: {2}", new Object[]{domain, ((List)spammersByDomain.get(domain)).size(), ((List)spammersByDomain.get(domain)).stream().sorted().map(spammer -> spammer.toString()).collect(Collectors.joining(", ")), name}));
    }

    public class Spammer
    implements Comparable<Spammer> {
        private final BareJID jid;
        private long counter = 0L;
        private long lastSpamTimestamp = System.currentTimeMillis();
        private boolean localUser;
        private double probability = 0.0;

        public Spammer(BareJID jid) {
            this.jid = jid;
        }

        public BareJID getJID() {
            return this.jid;
        }

        public void spamDetected(SpamFilter reporter) {
            this.lastSpamTimestamp = System.currentTimeMillis();
            ++this.counter;
            this.probability += reporter.getSpamProbability();
        }

        public boolean hasTimeoutPassed(long timeout) {
            return System.currentTimeMillis() - this.lastSpamTimestamp > timeout;
        }

        public boolean hasProbabilityReached(double value) {
            return this.probability >= value;
        }

        public void localUser() {
            this.localUser = true;
        }

        public boolean isLocalUser() {
            return this.localUser;
        }

        @Override
        public int compareTo(Spammer o) {
            return this.jid.compareTo(o.jid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.jid.toString()).append("[last_at: ").append(this.lastSpamTimestamp).append(", count: ").append(this.counter).append(", probability: ").append(this.probability).append(", banned: ").append(!this.hasTimeoutPassed(KnownSpammersFilter.this.banTime * 60L * 1000L)).append("]");
            return sb.toString();
        }
    }
}

