/*
 * Decompiled with CFR 0.152.
 */
package tigase.workgroupqueues.data.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.workgroupqueues.data.Store;
import tigase.workgroupqueues.data.WorkgroupQueueEntity;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:.*"})
@Repository.SchemaId(id="workgroup", name="Tigase Workgroup Queues Component")
public class JDBCWorkgroupQueuesRepository
implements RepositoryVersionAware,
Store {
    public static final String ADD_QUEUEY_KEY = "ADD_QUEUEY_KEY";
    public static final String GET_QUEUEY_KEY = "GET_QUEUEY_KEY";
    public static final String DELETE_QUEUEY_KEY = "DELETE_QUEUEY_KEY";
    public static final String UPDATE_QUEUEY_KEY = "UPDATE_QUEUEY_KEY";
    public static final String GET_QUEUES_KEY = "GET_QUEUES_KEY";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected DataRepository dataRepository;

    private static String a(BareJID[] bareJIDArray) {
        if (bareJIDArray == null) {
            return "";
        }
        int n = bareJIDArray.length - 1;
        if (n == -1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            stringBuilder.append(String.valueOf(bareJIDArray[n2]));
            if (n2 == n) {
                return stringBuilder.toString();
            }
            stringBuilder.append(",");
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWorkgroupQueue(BareJID queueJid) {
        PreparedStatement preparedStatement = null;
        try {
            PreparedStatement preparedStatement2 = preparedStatement = this.dataRepository.getPreparedStatement(null, DELETE_QUEUEY_KEY);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, queueJid.toString());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            this.log.log(Level.WARNING, "Can't remove Workgroup Queue to database", sQLException);
            throw new RuntimeException(sQLException);
        }
        finally {
            this.dataRepository.release(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkgroupQueue(WorkgroupQueueEntity queue) {
        PreparedStatement preparedStatement = null;
        try {
            PreparedStatement preparedStatement2 = preparedStatement = this.dataRepository.getPreparedStatement(null, ADD_QUEUEY_KEY);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, queue.getJid().toString());
                preparedStatement.setString(2, queue.getDescription());
                preparedStatement.setString(3, queue.getMucDomain());
                preparedStatement.setDate(4, new Date(queue.getCreationDate().getTime()));
                preparedStatement.setString(5, queue.getCreatorJid().toString());
                preparedStatement.setString(6, JDBCWorkgroupQueuesRepository.a(queue.getAgents()));
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            this.log.log(Level.WARNING, "Can't add Workgroup Queue to database", sQLException);
            throw new RuntimeException(sQLException);
        }
        finally {
            this.dataRepository.release(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public WorkgroupQueueEntity getWorkgroupQueue(BareJID queueJID) {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block8: {
            PreparedStatement preparedStatement2;
            resultSet = null;
            preparedStatement = preparedStatement2 = this.dataRepository.getPreparedStatement(null, GET_QUEUEY_KEY);
            // MONITORENTER : preparedStatement
            preparedStatement2.setString(1, queueJID.toString());
            resultSet = preparedStatement2.executeQuery();
            if (!resultSet.next()) break block8;
            WorkgroupQueueEntity workgroupQueueEntity = this.a(resultSet);
            // MONITOREXIT : preparedStatement
            this.dataRepository.release(null, resultSet);
            return workgroupQueueEntity;
        }
        try {
            // MONITOREXIT : preparedStatement
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            try {
                this.log.log(Level.WARNING, "Can't get Workgroup Queue from database", sQLException);
                throw new RuntimeException(sQLException);
            }
            catch (Throwable throwable) {
                this.dataRepository.release(null, resultSet);
                throw throwable;
            }
        }
        this.dataRepository.release(null, resultSet);
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<WorkgroupQueueEntity> getWorkgroupQueues() {
        ArrayList<WorkgroupQueueEntity> arrayList = new ArrayList<WorkgroupQueueEntity>();
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = preparedStatement = this.dataRepository.getPreparedStatement(null, GET_QUEUES_KEY);
            synchronized (preparedStatement2) {
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    arrayList.add(this.a(resultSet));
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.log(Level.WARNING, "Can't get Workgroup Queues from database", sQLException);
                throw new RuntimeException(sQLException);
            }
            catch (Throwable throwable) {
                this.dataRepository.release(null, resultSet);
                throw throwable;
            }
        }
        this.dataRepository.release(null, resultSet);
        return arrayList;
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
    }

    public void setDataSource(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
        try {
            this.initPreparedStatements(dataRepository);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Cannot initialize database", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkgroupQueue(WorkgroupQueueEntity queue) {
        PreparedStatement preparedStatement = null;
        try {
            PreparedStatement preparedStatement2 = preparedStatement = this.dataRepository.getPreparedStatement(null, UPDATE_QUEUEY_KEY);
            synchronized (preparedStatement2) {
                preparedStatement.setString(1, queue.getDescription());
                preparedStatement.setString(2, queue.getMucDomain());
                preparedStatement.setString(3, JDBCWorkgroupQueuesRepository.a(queue.getAgents()));
                preparedStatement.setString(4, queue.getJid().toString());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            this.log.log(Level.WARNING, "Can't update Workgroup Queue to database", sQLException);
            throw new RuntimeException(sQLException);
        }
        finally {
            this.dataRepository.release(null, null);
        }
    }

    protected void initPreparedStatements(DataRepository dataRepository) throws SQLException {
        String string = "INSERT INTO tig_workgroup_queue (jid, description, muc_domain, creation_date, creator_jid, agents) VALUES (?, ?, ?, ?, ?, ?)";
        dataRepository.initPreparedStatement(ADD_QUEUEY_KEY, string);
        string = "UPDATE tig_workgroup_queue SET description=?, muc_domain=?, agents=? WHERE jid=?";
        dataRepository.initPreparedStatement(UPDATE_QUEUEY_KEY, string);
        string = "SELECT * FROM tig_workgroup_queue";
        dataRepository.initPreparedStatement(GET_QUEUES_KEY, string);
        string = "SELECT * FROM tig_workgroup_queue WHERE jid=?";
        dataRepository.initPreparedStatement(GET_QUEUEY_KEY, string);
        string = "DELETE FROM tig_workgroup_queue WHERE jid = ?";
        dataRepository.initPreparedStatement(DELETE_QUEUEY_KEY, string);
    }

    private WorkgroupQueueEntity a(ResultSet resultSet) throws SQLException {
        BareJID bareJID = BareJID.bareJIDInstanceNS((String)resultSet.getString("jid"));
        WorkgroupQueueEntity workgroupQueueEntity = new WorkgroupQueueEntity(bareJID);
        workgroupQueueEntity.setDescription(resultSet.getString("description"));
        String string = resultSet.getString("muc_domain");
        if (string != null && !string.trim().isEmpty()) {
            workgroupQueueEntity.setMucDomain(string);
        }
        workgroupQueueEntity.setCreationDate(resultSet.getDate("creation_date"));
        workgroupQueueEntity.setCreatorJid(BareJID.bareJIDInstanceNS((String)resultSet.getString("creator_jid")));
        string = resultSet.getString("agents");
        if (string != null && !string.trim().isEmpty()) {
            String[] stringArray = string.split(",");
            workgroupQueueEntity.setAgents(new BareJID[stringArray.length]);
            for (int i = 0; i < stringArray.length; ++i) {
                workgroupQueueEntity.getAgents()[i] = BareJID.bareJIDInstanceNS((String)stringArray[i]);
            }
        }
        return workgroupQueueEntity;
    }
}

