/*
 * Decompiled with CFR 0.152.
 */
package tigase.jaxmpp.j2se.connectors.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ServerOnlyTlsAuthentication;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import tigase.jaxmpp.core.client.BareJID;
import tigase.jaxmpp.core.client.Connector;
import tigase.jaxmpp.core.client.Context;
import tigase.jaxmpp.core.client.PacketWriter;
import tigase.jaxmpp.core.client.SessionObject;
import tigase.jaxmpp.core.client.XmppModulesManager;
import tigase.jaxmpp.core.client.XmppSessionLogic;
import tigase.jaxmpp.core.client.connector.StreamError;
import tigase.jaxmpp.core.client.eventbus.Event;
import tigase.jaxmpp.core.client.eventbus.EventHandler;
import tigase.jaxmpp.core.client.eventbus.JaxmppEvent;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.jaxmpp.core.client.factory.UniversalFactory;
import tigase.jaxmpp.core.client.xml.Element;
import tigase.jaxmpp.core.client.xml.ElementFactory;
import tigase.jaxmpp.core.client.xml.XMLException;
import tigase.jaxmpp.core.client.xmpp.modules.StreamFeaturesModule;
import tigase.jaxmpp.core.client.xmpp.stanzas.Stanza;
import tigase.jaxmpp.core.client.xmpp.stanzas.StreamPacket;
import tigase.jaxmpp.core.client.xmpp.stream.XMPPStream;
import tigase.jaxmpp.j2se.DNSResolver;
import tigase.jaxmpp.j2se.connectors.socket.DefaultHostnameVerifier;
import tigase.jaxmpp.j2se.connectors.socket.JaxmppHostnameVerifier;
import tigase.jaxmpp.j2se.connectors.socket.OutputStreamFlushWrap;
import tigase.jaxmpp.j2se.connectors.socket.Reader;
import tigase.jaxmpp.j2se.connectors.socket.SocketInBandRegistrationXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.SocketXmppSessionLogic;
import tigase.jaxmpp.j2se.connectors.socket.TextStreamReader;
import tigase.jaxmpp.j2se.connectors.socket.Worker;

public class SocketConnector
implements Connector {
    public static final String COMPRESSION_DISABLED_KEY = "COMPRESSION_DISABLED";
    public static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 2048;
    public static final String HOSTNAME_VERIFIER_DISABLED_KEY = "HOSTNAME_VERIFIER_DISABLED_KEY";
    public static final String HOSTNAME_VERIFIER_KEY = "HOSTNAME_VERIFIER_KEY";
    public static final String KEY_MANAGERS_KEY = "KEY_MANAGERS_KEY";
    public static final String SASL_EXTERNAL_ENABLED_KEY = "SASL_EXTERNAL_ENABLED_KEY";
    public static final String SERVER_HOST = "socket#ServerHost";
    public static final String SERVER_PORT = "socket#ServerPort";
    public static final String USE_PLAIN_SSL_KEY = "USE_PLAIN_SSL_KEY";
    public static final int DEFAULT_SOCKET_TIMEOUT = 0;
    public static final String SSL_SOCKET_FACTORY_KEY = "socket#SSLSocketFactory";
    public static final String TLS_DISABLED_KEY = "TLS_DISABLED";
    public static final String SSL_SOCKET_TIMEOUT_KEY = "SSL_SOCKET_TIMEOUT_KEY";
    public static final String PLAIN_SOCKET_TIMEOUT_KEY = "PLAIN_SOCKET_TIMEOUT_KEY";
    public static final String KEEP_ALIVE_DELAY_KEY = "KEEP_ALIVE_DELAY_KEY";
    public static final String TLS_SESSION_ID_KEY = "TLS_SESSION_ID_KEY";
    public static final String TLS_PEER_CERTIFICATE_KEY = "TLS_PEER_CERTIFICATE_KEY";
    public static final String USE_BOUNCYCASTLE_KEY = "USE_BOUNCYCASTLE_KEY";
    private static final Charset UTF_CHARSET = Charset.forName("UTF-8");
    private static final byte[] EMPTY_BYTEARRAY = new byte[0];
    private final Object ioMutex = new Object();
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Timer closeTimer;
    private Context context;
    private TimerTask pingTask;
    private volatile Reader reader;
    private Socket socket;
    private Timer timer;
    private Worker worker;
    private OutputStream writer;

    public static boolean isTLSAvailable(SessionObject sessionObject) throws XMLException {
        Element sf = StreamFeaturesModule.getStreamFeatures((SessionObject)sessionObject);
        if (sf == null) {
            return false;
        }
        Element m = sf.getChildrenNS("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        return m != null;
    }

    public static boolean isZLibAvailable(SessionObject sessionObject) throws XMLException {
        Element sf = StreamFeaturesModule.getStreamFeatures((SessionObject)sessionObject);
        if (sf == null) {
            return false;
        }
        Element m = sf.getChildrenNS("compression", "http://jabber.org/features/compress");
        if (m == null) {
            return false;
        }
        for (Element method : m.getChildren("method")) {
            if (!"zlib".equals(method.getValue())) continue;
            return true;
        }
        return false;
    }

    public SocketConnector(Context context) {
        this.context = context;
    }

    private void closeSocket() {
        if (this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.log.log(Level.FINEST, "Problem with closing socket (oid=" + this.hashCode() + ")", ex);
            }
        }
    }

    private X509Certificate[] convertChain(Certificate certificates) throws CertificateException, IOException {
        X509Certificate[] result = new X509Certificate[certificates.getLength()];
        for (int i = 0; i < certificates.getLength(); ++i) {
            TlsCertificate cert = certificates.getCertificateAt(i);
            java.security.cert.Certificate jsCert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            result[i] = (X509Certificate)jsCert;
        }
        return result;
    }

    public XmppSessionLogic createSessionLogic(XmppModulesManager modulesManager, PacketWriter writer) {
        if (this.context.getSessionObject().getProperty("IN_BAND_REGISTRATION_MODE_KEY") == Boolean.TRUE) {
            this.log.info("Using XEP-0077 mode!!!!");
            return new SocketInBandRegistrationXmppSessionLogic(this, modulesManager, this.context);
        }
        return new SocketXmppSessionLogic(this, modulesManager, this.context);
    }

    private Socket createSocket(Entry serverHost) throws IOException {
        Socket socket;
        InetAddress x = InetAddress.getByName(serverHost.getHostname());
        this.log.info("Opening connection to " + x + ":" + serverHost.getPort());
        if (this.context.getSessionObject().getProperty("PROXY_HOST_KEY") != null) {
            String proxyHost = (String)this.context.getSessionObject().getProperty("PROXY_HOST_KEY");
            int proxyPort = (Integer)this.context.getSessionObject().getProperty("PROXY_PORT_KEY");
            Proxy.Type proxyType = (Proxy.Type)((Object)this.context.getSessionObject().getProperty("PROXY_TYPE_KEY"));
            if (proxyType == null) {
                proxyType = Proxy.Type.HTTP;
            }
            this.log.info("Using " + (Object)((Object)proxyType) + " proxy: " + proxyHost + ":" + proxyPort);
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
            Proxy proxy = new Proxy(proxyType, addr);
            socket = new Socket(proxy);
        } else {
            socket = new Socket();
        }
        Integer soTimeout = this.getTimeout(PLAIN_SOCKET_TIMEOUT_KEY, 0);
        if (soTimeout != null) {
            socket.setSoTimeout(soTimeout);
        }
        socket.setKeepAlive(false);
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(x, (int)serverHost.getPort()));
        return socket;
    }

    protected void fireOnConnected(SessionObject sessionObject) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.context.getEventBus().fire((Event)new Connector.ConnectedHandler.ConnectedEvent(sessionObject));
    }

    protected void fireOnError(Element response, Throwable caught, SessionObject sessionObject) throws JaxmppException {
        Iterator iterator;
        List es;
        StreamError streamError = null;
        if (response != null && (es = response.getChildrenNS("urn:ietf:params:xml:ns:xmpp-streams")) != null && (iterator = es.iterator()).hasNext()) {
            Element element = (Element)iterator.next();
            String n = element.getName();
            streamError = StreamError.getByElementName((String)n);
        }
        this.context.getEventBus().fire((Event)new Connector.ErrorHandler.ErrorEvent(sessionObject, streamError, caught));
    }

    protected void fireOnStanzaReceived(StreamPacket response, SessionObject sessionObject) throws JaxmppException {
        this.context.getEventBus().fire((Event)new Connector.StanzaReceivedHandler.StanzaReceivedEvent(sessionObject, response));
    }

    protected void fireOnTerminate(SessionObject sessionObject) throws JaxmppException {
        this.context.getEventBus().fire((Event)new Connector.StreamTerminatedHandler.StreamTerminatedEvent(sessionObject));
    }

    protected String getAuthType(TlsKeyExchange tlsKeyExchange) {
        try {
            Field keyExchangeField = AbstractTlsKeyExchange.class.getDeclaredField("keyExchange");
            keyExchangeField.setAccessible(true);
            Object v = keyExchangeField.get(tlsKeyExchange);
            int i = Integer.valueOf(v.toString());
            switch (i) {
                case 0: {
                    return "NULL";
                }
                case 1: {
                    return "RSA";
                }
                case 2: {
                    return "RSA_EXPORT";
                }
                case 3: {
                    return "DHE_DSS";
                }
                case 4: {
                    return "DHE_DSS_EXPORT";
                }
                case 5: {
                    return "DHE_RSA";
                }
                case 6: {
                    return "DHE_RSA_EXPORT";
                }
                case 7: {
                    return "DH_DSS";
                }
                case 8: {
                    return "DH_DSS_EXPORT";
                }
                case 9: {
                    return "DH_RSA";
                }
                case 10: {
                    return "DH_RSA_EXPORT";
                }
                case 11: {
                    return "DH_anon";
                }
                case 12: {
                    return "DH_anon_EXPORT";
                }
                case 13: {
                    return "PSK";
                }
                case 14: {
                    return "DHE_PSK";
                }
                case 15: {
                    return "RSA_PSK";
                }
                case 16: {
                    return "ECDH_ECDSA";
                }
                case 17: {
                    return "ECDHE_ECDSA";
                }
                case 18: {
                    return "ECDH_RSA";
                }
                case 19: {
                    return "ECDHE_RSA";
                }
                case 20: {
                    return "ECDH_anon";
                }
                case 21: {
                    return "SRP";
                }
                case 22: {
                    return "SRP_DSS";
                }
                case 23: {
                    return "SRP_RSA";
                }
                case 24: {
                    return "ECDHE_PSK";
                }
            }
            return "UNKNOWN " + i;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private Entry getHostFromSessionObject() {
        String serverHost = (String)this.context.getSessionObject().getProperty(SERVER_HOST);
        Integer port = (Integer)this.context.getSessionObject().getProperty(SERVER_PORT);
        if (serverHost == null) {
            return null;
        }
        return new Entry(serverHost, port == null ? 5222 : port);
    }

    protected String getHostname() {
        String hostname = this.context.getSessionObject().getProperty("userBareJid") != null ? ((BareJID)this.context.getSessionObject().getProperty("userBareJid")).getDomain() : (this.context.getSessionObject().getProperty("domainName") != null ? (String)this.context.getSessionObject().getProperty("domainName") : null);
        return hostname;
    }

    protected KeyManager[] getKeyManagers() throws NoSuchAlgorithmException {
        KeyManager[] result = (KeyManager[])this.context.getSessionObject().getProperty(KEY_MANAGERS_KEY);
        return result == null ? new KeyManager[]{} : result;
    }

    private java.security.cert.Certificate getPeerCertificate(SSLSession session) throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] certificates = session.getPeerCertificates();
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        return certificates[0];
    }

    public Connector.State getState() {
        if (this.context == null) {
            return Connector.State.disconnected;
        }
        Connector.State st = (Connector.State)this.context.getSessionObject().getProperty("CONNECTOR#STAGE_KEY");
        return st == null ? Connector.State.disconnected : st;
    }

    protected Integer getTimeout(String propertyName, int defaultValue) {
        Integer v = (Integer)this.context.getSessionObject().getProperty(propertyName);
        int result = v == null ? defaultValue : v;
        return result < 0 ? null : Integer.valueOf(result);
    }

    public boolean isCompressed() {
        return this.context.getSessionObject().getProperty("CONNECTOR#COMPRESSED_KEY") == Boolean.TRUE;
    }

    public boolean isSecure() {
        return this.context.getSessionObject().getProperty("CONNECTOR#ENCRYPTED_KEY") == Boolean.TRUE;
    }

    public void keepalive() throws JaxmppException {
        if (this.context.getSessionObject().getProperty("CONNECTOR#DISABLEKEEPALIVE") == Boolean.TRUE) {
            return;
        }
        if (this.getState() == Connector.State.connected) {
            this.send(new byte[]{32});
        }
    }

    protected void onError(Element response, Throwable caught) throws JaxmppException {
        Element seeOtherHost;
        if (response != null && (seeOtherHost = response.getChildrenNS("see-other-host", "urn:ietf:params:xml:ns:xmpp-streams")) != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Received see-other-host=" + seeOtherHost.getValue());
            }
            this.reconnect(seeOtherHost.getValue());
            return;
        }
        this.terminateAllWorkers();
        this.fireOnError(response, caught, this.context.getSessionObject());
    }

    protected void onErrorInThread(Exception e) throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.terminateAllWorkers();
        this.fireOnError(null, e, this.context.getSessionObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResponse(Element response) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if ("error".equals(response.getName()) && response.getXMLNS() != null && response.getXMLNS().equals("http://etherx.jabber.org/streams")) {
                this.onError(response, null);
            } else {
                Object p = Stanza.canBeConverted((Element)response) ? Stanza.create((Element)response) : new StreamPacket(response){};
                p.setXmppStream((XMPPStream)this.context.getStreamsManager().getDefaultStream());
                this.fireOnStanzaReceived((StreamPacket)p, this.context.getSessionObject());
            }
        }
    }

    protected void onStreamStart(Map<String, String> attribs) {
    }

    protected void onStreamTerminate() throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnected);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Stream terminated");
        }
        this.terminateAllWorkers();
        this.fireOnTerminate(this.context.getSessionObject());
    }

    public void onTLSStanza(Element elem) throws JaxmppException {
        if (elem.getName().equals("proceed")) {
            this.proceedTLS();
        } else if (elem.getName().equals("failure")) {
            this.log.info("TLS Failure");
        }
    }

    public void onZLibStanza(Element elem) throws JaxmppException {
        if (elem.getName().equals("compressed") && "http://jabber.org/protocol/compress".equals(elem.getXMLNS())) {
            this.proceedZLib();
        } else if (elem.getName().equals("failure")) {
            this.log.info("ZLIB Failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedBCTLS() throws JaxmppException {
        this.log.fine("Proceeding TLS with Bouncycastle");
        try {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            final TrustManager[] trustManagers = (TrustManager[])this.context.getSessionObject().getProperty("TRUST_MANAGERS_KEY");
            BcTlsCrypto tlsCrypto = new BcTlsCrypto(new SecureRandom());
            final String hostname = this.getHostname();
            TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(this.socket.getInputStream(), this.socket.getOutputStream());
            DefaultTlsClient tlsClient = new DefaultTlsClient((TlsCrypto)tlsCrypto){

                public TlsAuthentication getAuthentication() throws IOException {
                    return new ServerOnlyTlsAuthentication(){

                        public void notifyServerCertificate(Certificate certificate) throws IOException {
                            try {
                                Object object;
                                X509Certificate[] certChain = SocketConnector.this.convertChain(certificate);
                                TlsAuthentication a = this.getAuthentication();
                                System.out.println(a);
                                TlsSession b = this.getSessionToResume();
                                System.out.println(b);
                                TlsKeyExchange c = this.getKeyExchange();
                                System.out.println(c);
                                Vector z = this.getSupportedSignatureAlgorithms();
                                for (Object e : z) {
                                    System.out.println("++>" + e + "  " + e.getClass());
                                }
                                String authType = SocketConnector.this.getAuthType(this.getKeyExchange());
                                System.out.println("AUTH_TYPE=" + authType);
                                if (trustManagers != null) {
                                    for (TrustManager trustManager : trustManagers) {
                                        if (!(trustManager instanceof X509TrustManager)) continue;
                                        ((X509TrustManager)trustManager).checkServerTrusted(certChain, authType);
                                    }
                                }
                                if ((object = SocketConnector.this.context.getSessionObject().getProperty(SocketConnector.HOSTNAME_VERIFIER_KEY)) != null && object instanceof JaxmppHostnameVerifier) {
                                    if (!((JaxmppHostnameVerifier)object).verify(hostname, certChain[0])) {
                                        throw new SSLHandshakeException("Cerificate hostname doesn't match domain name you want to connect.");
                                    }
                                } else if (object != null && object instanceof HostnameVerifier) {
                                    throw new SSLHandshakeException("javax.net.ssl.HostnameVerifier is not supported! Use tigase.jaxmpp.j2se.connectors.socket.JaxmppHostnameVerifier instead.");
                                }
                                SocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, SocketConnector.TLS_PEER_CERTIFICATE_KEY, (Object)certChain[0]);
                            }
                            catch (SSLHandshakeException e) {
                                e.printStackTrace();
                                throw new IOException("Cannot peer validate certificate", e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }

                public void notifyHandshakeComplete() throws IOException {
                    SocketConnector.this.log.info("TLS completed ");
                    super.notifyHandshakeComplete();
                    byte[] cb = this.context.exportChannelBinding(1);
                    SocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, SocketConnector.TLS_SESSION_ID_KEY, (Object)cb);
                    SocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#ENCRYPTED_KEY", (Object)Boolean.TRUE);
                    SocketConnector.this.context.getEventBus().fire((Event)new Connector.EncryptionEstablishedHandler.EncryptionEstablishedEvent(SocketConnector.this.context.getSessionObject()));
                }
            };
            tlsClientProtocol.connect((TlsClient)tlsClient);
            this.writer = tlsClientProtocol.getOutputStream();
            this.reader = new TextStreamReader(tlsClientProtocol.getInputStream());
            this.restartStream();
        }
        catch (SSLHandshakeException e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        finally {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedJCETLS() throws JaxmppException {
        this.log.fine("Proceeding TLS");
        try {
            SSLSocketFactory factory;
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            TrustManager[] trustManagers = (TrustManager[])this.context.getSessionObject().getProperty("TRUST_MANAGERS_KEY");
            if (trustManagers == null) {
                factory = this.context.getSessionObject().getProperty(SSL_SOCKET_FACTORY_KEY) != null ? (SSLSocketFactory)this.context.getSessionObject().getProperty(SSL_SOCKET_FACTORY_KEY) : (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object sslEngine = null;
            } else {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(this.getKeyManagers(), trustManagers, new SecureRandom());
                factory = ctx.getSocketFactory();
                SSLEngine sslEngine = ctx.createSSLEngine();
            }
            SSLSocket s1 = (SSLSocket)factory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
            Integer sslSoTimeout = this.getTimeout(SSL_SOCKET_TIMEOUT_KEY, 0);
            if (sslSoTimeout != null) {
                s1.setSoTimeout(sslSoTimeout);
            }
            s1.setKeepAlive(false);
            s1.setTcpNoDelay(true);
            s1.setUseClientMode(true);
            s1.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent arg0) {
                    SocketConnector.this.log.info("TLS completed " + arg0);
                    SocketConnector.this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#ENCRYPTED_KEY", (Object)Boolean.TRUE);
                    SocketConnector.this.context.getEventBus().fire((Event)new Connector.EncryptionEstablishedHandler.EncryptionEstablishedEvent(SocketConnector.this.context.getSessionObject()));
                    try {
                        java.security.cert.Certificate[] certs = arg0.getPeerCertificates();
                        java.security.cert.Certificate certificate = certs == null || certs.length == 0 ? null : certs[0];
                    }
                    catch (Exception e) {
                        SocketConnector.this.log.log(Level.WARNING, "Cannot extract peer certificate", e);
                    }
                }
            });
            this.writer = null;
            this.reader = null;
            this.log.fine("Start handshake");
            String hostname = this.getHostname();
            s1.startHandshake();
            Object hnv = this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_KEY);
            if (hnv != null && hnv instanceof HostnameVerifier && !((HostnameVerifier)hnv).verify(hostname, s1.getSession())) {
                throw new SSLHandshakeException("Cerificate hostname doesn't match domain name you want to connect.");
            }
            if (hnv != null && hnv instanceof JaxmppHostnameVerifier && !((JaxmppHostnameVerifier)hnv).verify(hostname, this.getPeerCertificate(s1.getSession()))) {
                throw new SSLHandshakeException("Cerificate hostname doesn't match domain name you want to connect.");
            }
            this.socket = s1;
            this.writer = this.socket.getOutputStream();
            this.reader = new TextStreamReader(this.socket.getInputStream());
            this.restartStream();
        }
        catch (SSLHandshakeException e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish encrypted connection", e);
            this.onError(null, e);
        }
        finally {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    protected void proceedTLS() throws JaxmppException {
        if (this.context.getSessionObject().getProperty(USE_BOUNCYCASTLE_KEY) == Boolean.TRUE) {
            this.proceedBCTLS();
        } else {
            this.proceedJCETLS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedZLib() throws JaxmppException {
        this.log.fine("Proceeding ZLIB");
        try {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.TRUE);
            this.writer = null;
            this.reader = null;
            this.log.fine("Start ZLIB compression");
            Deflater compressor = new Deflater(9, false);
            try {
                Field f = compressor.getClass().getDeclaredField("flushParm");
                if (f != null) {
                    f.setAccessible(true);
                    f.setInt(compressor, 2);
                    this.writer = new DeflaterOutputStream(this.socket.getOutputStream(), compressor);
                }
            }
            catch (NoSuchFieldException ex) {
                try {
                    Constructor flushable = DeflaterOutputStream.class.getConstructor(OutputStream.class, Deflater.class, Boolean.TYPE);
                    this.writer = new OutputStreamFlushWrap((OutputStream)flushable.newInstance(this.socket.getOutputStream(), compressor, true));
                }
                catch (NoSuchMethodException ex1) {
                    this.writer = new DeflaterOutputStream(this.socket.getOutputStream(), compressor){

                        @Override
                        public void write(byte[] data) throws IOException {
                            super.write(data);
                            super.write(EMPTY_BYTEARRAY);
                            this.def.setLevel(0);
                            super.deflate();
                            this.def.setLevel(9);
                            super.deflate();
                        }
                    };
                }
            }
            Inflater decompressor = new Inflater(false);
            InflaterInputStream is = new InflaterInputStream(this.socket.getInputStream(), decompressor);
            this.reader = new TextStreamReader(is);
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#COMPRESSED_KEY", (Object)true);
            this.log.info("ZLIB compression started");
            this.restartStream();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Can't establish compressed connection", e);
            this.onError(null, e);
        }
        finally {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
        }
    }

    public void processElement(Element elem) throws JaxmppException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Recv (oid=" + this.hashCode() + "): " + elem.getAsString());
        }
        if (elem != null && elem.getXMLNS() != null && elem.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-tls")) {
            this.onTLSStanza(elem);
        } else if (elem != null && elem.getXMLNS() != null && "http://jabber.org/protocol/compress".equals(elem.getXMLNS())) {
            this.onZLibStanza(elem);
        } else {
            this.onResponse(elem);
        }
    }

    private void reconnect(String newHost) {
        this.log.info("See other host: " + newHost);
        try {
            this.context.getSessionObject().setProperty("s:reconnecting", (Object)Boolean.TRUE);
            this.terminateAllWorkers();
            this.context.getSessionObject().clear(new SessionObject.Scope[]{SessionObject.Scope.stream});
            this.context.getSessionObject().setProperty(SERVER_HOST, (Object)newHost);
            this.worker = null;
            this.reader = null;
            this.writer = null;
            this.context.getSessionObject().setProperty("s:reconnecting", (Object)Boolean.TRUE);
            this.log.finest("Waiting for workers termination");
        }
        catch (JaxmppException e) {
            this.log.log(Level.WARNING, "Error on recconnect", e);
        }
    }

    public void restartStream() throws JaxmppException {
        String to;
        StringBuilder sb = new StringBuilder();
        sb.append("<stream:stream ");
        BareJID from = (BareJID)this.context.getSessionObject().getProperty("userBareJid");
        Boolean seeOtherHost = (Boolean)this.context.getSessionObject().getProperty("BOSH#SEE_OTHER_HOST_KEY");
        if (from != null && (seeOtherHost == null || seeOtherHost.booleanValue())) {
            to = from.getDomain();
            sb.append("from='").append(from.toString()).append("' ");
        } else {
            to = (String)this.context.getSessionObject().getProperty("domainName");
        }
        if (to != null) {
            sb.append("to='").append(to).append("' ");
        }
        sb.append("xmlns='jabber:client' ");
        sb.append("xmlns:stream='http://etherx.jabber.org/streams' ");
        sb.append("version='1.0'>");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Restarting XMPP Stream");
        }
        this.send(sb.toString().getBytes(UTF_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] buffer) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Send (oid=" + this.hashCode() + "): " + new String(buffer));
                    }
                    this.writer.write(buffer);
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new JaxmppException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Element stanza) throws JaxmppException {
        Object object = this.ioMutex;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    String t = stanza.getAsString();
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Send (oid=" + this.hashCode() + "): " + t);
                    }
                    try {
                        this.context.getEventBus().fire((Event)new Connector.StanzaSendingHandler.StanzaSendingEvent(this.context.getSessionObject(), stanza));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.writer.write(t.getBytes(UTF_CHARSET));
                }
                catch (IOException e) {
                    this.terminateAllWorkers();
                    throw new JaxmppException((Throwable)e);
                }
            }
        }
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException e) {
            this.log.warning("Thread can't sleep. Insomnia?");
        }
    }

    protected void setStage(Connector.State state) throws JaxmppException {
        if (this.context == null) {
            return;
        }
        Connector.State s = (Connector.State)this.context.getSessionObject().getProperty("CONNECTOR#STAGE_KEY");
        this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#STAGE_KEY", (Object)state);
        if (s != state) {
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#CONNECTOR_STAGE_TIMESTAMP_KEY", (Object)new Date());
            this.log.fine("Connector (oid=" + this.hashCode() + ") state changed: " + s + "->" + state);
            this.context.getEventBus().fire((Event)new Connector.StateChangedHandler.StateChangedEvent(this.context.getSessionObject(), s, state));
            if (state == Connector.State.disconnected) {
                this.fireOnTerminate(this.context.getSessionObject());
            }
        }
    }

    public void start() throws JaxmppException {
        this.log.fine("Start connector (oid=" + this.hashCode() + ").");
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.timer = new Timer("SocketConnectorTimer", true);
        if (this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_DISABLED_KEY) == Boolean.TRUE) {
            this.context.getSessionObject().setProperty(HOSTNAME_VERIFIER_KEY, null);
        } else if (this.context.getSessionObject().getProperty(HOSTNAME_VERIFIER_KEY) == null) {
            this.context.getSessionObject().setProperty(HOSTNAME_VERIFIER_KEY, (Object)DEFAULT_HOSTNAME_VERIFIER);
        }
        this.setStage(Connector.State.connecting);
        try {
            ArrayList<Entry> hosts = new ArrayList<Entry>();
            Entry serverHost = this.getHostFromSessionObject();
            if (serverHost != null) {
                this.log.info("DNS entry stored in session object: " + serverHost);
                hosts.add(serverHost);
            }
            if (hosts.isEmpty()) {
                String x = (String)this.context.getSessionObject().getProperty("domainName");
                this.log.info("Resolving SRV record of domain '" + (String)x + "'");
                DnsResolver dnsResolver = (DnsResolver)UniversalFactory.createInstance((String)DnsResolver.class.getName());
                if (dnsResolver != null) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Using resolver provided by user: " + dnsResolver);
                    }
                    hosts.addAll(dnsResolver.resolve(x));
                } else {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Using built-in resolver");
                    }
                    hosts.addAll(DNSResolver.resolve(x));
                }
            }
            this.context.getSessionObject().setProperty(SessionObject.Scope.stream, "CONNECTOR#DISABLEKEEPALIVE", (Object)Boolean.FALSE);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Preparing connection to " + hosts);
            }
            for (Entry host : hosts) {
                try {
                    this.socket = this.createSocket(host);
                    break;
                }
                catch (NoRouteToHostException | UnknownHostException e) {
                    this.log.fine(e.getMessage() + ". Trying next.");
                }
            }
            if (this.socket == null) {
                throw new JaxmppException("Cannot create socket.");
            }
            this.writer = this.socket.getOutputStream();
            this.reader = new TextStreamReader(this.socket.getInputStream());
            this.worker = new Worker(this){

                @Override
                protected Reader getReader() {
                    return SocketConnector.this.reader;
                }

                @Override
                protected void onErrorInThread(Exception e) throws JaxmppException {
                    SocketConnector.this.onErrorInThread(e);
                }

                @Override
                protected void onStreamStart(Map<String, String> attribs) {
                    SocketConnector.this.onStreamStart(attribs);
                }

                @Override
                protected void onStreamTerminate() throws JaxmppException {
                    SocketConnector.this.onStreamTerminate();
                }

                @Override
                protected void processElement(Element elem) throws JaxmppException {
                    SocketConnector.this.processElement(elem);
                }

                @Override
                protected void workerTerminated() {
                    SocketConnector.this.workerTerminated(this);
                }
            };
            this.log.finest("Starting worker...");
            Boolean plainSSL = (Boolean)this.context.getSessionObject().getProperty(USE_PLAIN_SSL_KEY);
            if (plainSSL != null && plainSSL.booleanValue()) {
                this.proceedTLS();
                this.worker.start();
            } else {
                this.worker.start();
                this.restartStream();
            }
            this.setStage(Connector.State.connected);
            this.pingTask = new TimerTask(){

                @Override
                public void run() {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                SocketConnector.this.keepalive();
                            }
                            catch (JaxmppException e) {
                                SocketConnector.this.log.log(Level.SEVERE, "Can't ping!", e);
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            };
            if (this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY") == null || !((Boolean)this.context.getSessionObject().getProperty("CONNECTOR#EXTERNAL_KEEPALIVE_KEY")).booleanValue()) {
                Integer defaultDelay = this.getTimeout(PLAIN_SOCKET_TIMEOUT_KEY, 0);
                defaultDelay = defaultDelay == null ? -1 : defaultDelay - 5000;
                Integer delay = this.getTimeout(KEEP_ALIVE_DELAY_KEY, defaultDelay);
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Whitespace ping period is setted to " + delay + "ms");
                }
                if (delay != null) {
                    this.timer.schedule(this.pingTask, delay.intValue(), (long)delay.intValue());
                }
            }
            this.fireOnConnected(this.context.getSessionObject());
        }
        catch (Exception e) {
            this.terminateAllWorkers();
            throw new JaxmppException((Throwable)e);
        }
    }

    public void startTLS() throws JaxmppException {
        if (this.writer != null) {
            try {
                this.log.fine("Start TLS (oid=" + this.hashCode() + ")");
                Element e = ElementFactory.create((String)"starttls", null, (String)"urn:ietf:params:xml:ns:xmpp-tls");
                this.send(e.getAsString().getBytes(UTF_CHARSET));
            }
            catch (Exception e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void startZLib() throws JaxmppException {
        if (this.writer != null) {
            try {
                this.log.fine("Start ZLIB (oid=" + this.hashCode() + ")");
                Element e = ElementFactory.create((String)"compress", null, (String)"http://jabber.org/protocol/compress");
                e.addChild(ElementFactory.create((String)"method", (String)"zlib", null));
                this.send(e.getAsString().getBytes(UTF_CHARSET));
            }
            catch (Exception e) {
                throw new JaxmppException((Throwable)e);
            }
        }
    }

    public void stop() throws JaxmppException {
        if (this.getState() == Connector.State.disconnected) {
            return;
        }
        this.setStage(Connector.State.disconnecting);
        try {
            this.terminateStream();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on terminating stream", e);
            this.setStage(Connector.State.disconnected);
        }
        finally {
            this.terminateAllWorkers();
        }
    }

    @Deprecated
    public void stop(boolean terminate) throws JaxmppException {
        if (terminate) {
            this.log.finest("Terminating all workers immediatelly (oid=" + this.hashCode() + ")");
            try {
                if (this.pingTask != null) {
                    this.pingTask.cancel();
                    this.pingTask = null;
                }
                this.closeSocket();
            }
            finally {
                this.setStage(Connector.State.disconnected);
                this.context = null;
            }
        } else {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAllWorkers() throws JaxmppException {
        this.log.finest("Terminating all workers (oid=" + this.hashCode() + ")");
        if (this.pingTask != null) {
            this.pingTask.cancel();
            this.pingTask = null;
        }
        if (this.socket != null && this.socket.isConnected()) {
            SocketConnector socketConnector = this;
            synchronized (socketConnector) {
                if (this.closeTimer != null) {
                    this.closeTimer.cancel();
                }
                this.closeTimer = new Timer("SocketConnectorCloseTimer", true);
                this.closeTimer.schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SocketConnector.this.setStage(Connector.State.disconnected);
                        }
                        catch (JaxmppException jaxmppException) {
                            // empty catch block
                        }
                        SocketConnector.this.context = null;
                        SocketConnector.this.closeSocket();
                        SocketConnector socketConnector = SocketConnector.this;
                        synchronized (socketConnector) {
                            if (SocketConnector.this.closeTimer != null) {
                                SocketConnector.this.closeTimer.cancel();
                                SocketConnector.this.closeTimer = null;
                            }
                        }
                    }
                }, 3000L);
            }
        }
        try {
            this.setStage(Connector.State.disconnected);
        }
        catch (JaxmppException jaxmppException) {
            // empty catch block
        }
        try {
            if (this.worker != null) {
                this.worker.interrupt();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with interrupting w2", e);
        }
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Problem with canceling timer", e);
        }
        finally {
            this.timer = null;
        }
    }

    private void terminateStream() throws JaxmppException {
        Connector.State state = this.getState();
        if (state == Connector.State.connected || state == Connector.State.connecting || state == Connector.State.disconnecting) {
            String x = "</stream:stream>";
            this.log.fine("Terminating XMPP Stream");
            this.send(x.getBytes(UTF_CHARSET));
        } else {
            this.log.fine("Stream terminate not sent, because of connection state==" + state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerTerminated(Worker worker) {
        try {
            SocketConnector socketConnector = this;
            synchronized (socketConnector) {
                if (this.closeTimer != null) {
                    this.closeTimer.cancel();
                    this.closeTimer = null;
                }
                this.setStage(Connector.State.disconnected);
            }
        }
        catch (JaxmppException jaxmppException) {
            // empty catch block
        }
        this.log.finest("Worker terminated");
        try {
            if (this.context.getSessionObject().getProperty("s:reconnecting") == Boolean.TRUE) {
                this.context.getSessionObject().setProperty("s:reconnecting", null);
                this.context.getEventBus().fire((Event)new HostChangedHandler.HostChangedEvent(this.context.getSessionObject()));
                this.log.finest("Restarting...");
                this.start();
            } else {
                this.context.getEventBus().fire((Event)new Connector.DisconnectedHandler.DisconnectedEvent(this.context.getSessionObject()));
            }
        }
        catch (Exception e) {
            this.log.warning("Problem : " + e.getMessage());
        }
    }

    public static final class Entry {
        private final String hostname;
        private final Integer port;

        public Entry(String host, Integer port) {
            this.hostname = host;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }
    }

    public static interface HostChangedHandler
    extends EventHandler {
        public void onHostChanged(SessionObject var1);

        public static class HostChangedEvent
        extends JaxmppEvent<HostChangedHandler> {
            public HostChangedEvent(SessionObject sessionObject) {
                super(sessionObject);
            }

            public void dispatch(HostChangedHandler handler) {
                handler.onHostChanged(this.sessionObject);
            }
        }
    }

    public static interface DnsResolver {
        public List<Entry> resolve(String var1);
    }
}

