/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.Service;
import tigase.http.jetty.security.TigasePlainLoginService;

public class JettyHttpServerHelper {
    public static final String CONTEXT_KEY = "context-key";
    private static final Logger log = Logger.getLogger(JettyHttpServerHelper.class.getCanonicalName());

    public static ServletContextHandler createServletContextHandler(DeploymentInfo deployment) {
        ServletInfo[] servletInfos;
        String[] vhosts;
        ServletContextHandler context = new ServletContextHandler(0);
        try {
            context.setSecurityHandler((SecurityHandler)context.getDefaultSecurityHandlerClass().newInstance());
        }
        catch (InstantiationException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        Service service = deployment.getService();
        if (service != null) {
            context.getSecurityHandler().setLoginService((LoginService)new TigasePlainLoginService(service));
        }
        context.setContextPath(deployment.getContextPath());
        if (deployment.getClassLoader() != null) {
            context.setClassLoader(deployment.getClassLoader());
        }
        if ((vhosts = deployment.getVHosts()) != null && vhosts.length > 0) {
            context.setVirtualHosts(vhosts);
        }
        ServletInfo[] servletInfoArray = servletInfos = deployment.getServlets();
        int n = servletInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ServletInfo info = servletInfoArray[n2];
            for (String mapping : info.getMappings()) {
                ServletHolder holder = new ServletHolder(mapping, info.getServletClass());
                holder.setInitParameters(info.getInitParams());
                context.addServlet(holder, mapping);
            }
            ++n2;
        }
        return context;
    }
}

