/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.unified.db.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import tigase.xmpp.jid.BareJID;

public class StoredProcedures
extends tigase.archive.db.derby.StoredProcedures {
    private static final Logger a = Logger.getLogger(StoredProcedures.class.getName());

    public static void addItem(String ownerJid, String buddyJid, String buddyRes, Timestamp ts, Integer direction, String type, String body, String msg, String hash, String itemType, Integer offline, String jingleSid, String jingleAction, String jingleReason, Integer jingleOffline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            long l = StoredProcedures.ensureJid((String)ownerJid);
            long l2 = StoredProcedures.ensureJid((String)buddyJid);
            PreparedStatement preparedStatement = connection.prepareStatement("insert into tig_ma_msgs (owner_id, buddy_id, buddy_res, ts, direction, \"type\", body, msg, stanza_hash, item_type, offline, jingle_sid, jingle_action, jingle_reason, jingle_offline) select ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? from SYSIBM.SYSDUMMY1 where not exists ( select 1 from tig_ma_msgs where owner_id = ? and buddy_id = ? and stanza_hash = ? and ts between ? and ?)", 1);
            Timestamp timestamp = ts;
            Timestamp timestamp2 = ts;
            if ("groupchat".equals(type)) {
                timestamp = new Timestamp(ts.getTime() - 1800000L);
                timestamp2 = new Timestamp(ts.getTime() + 1800000L);
            }
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setLong(++n, l2);
            preparedStatement.setString(++n, buddyRes);
            preparedStatement.setTimestamp(++n, ts);
            preparedStatement.setInt(++n, direction);
            preparedStatement.setString(++n, type);
            preparedStatement.setString(++n, body);
            preparedStatement.setString(++n, msg);
            preparedStatement.setString(++n, hash);
            preparedStatement.setString(++n, itemType);
            preparedStatement.setInt(++n, offline);
            preparedStatement.setString(++n, jingleSid);
            preparedStatement.setString(++n, jingleAction);
            preparedStatement.setString(++n, jingleReason);
            preparedStatement.setInt(++n, jingleOffline);
            preparedStatement.setLong(++n, l);
            preparedStatement.setLong(++n, l2);
            preparedStatement.setString(++n, hash);
            preparedStatement.setTimestamp(++n, timestamp);
            preparedStatement.setTimestamp(++n, timestamp2);
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            long l3 = 0L;
            if (resultSet.next()) {
                l3 = resultSet.getLong(1);
            }
            preparedStatement = connection.prepareStatement("select msg_id from tig_ma_msgs where msg_id = " + l3);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_GetMessages(String ownerJid, String msgIds, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            String string = "select m.msg as message, m.msg_id from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id where o.jid_sha1 = ? and m.offline >= 1";
            if (msgIds != null) {
                string = string + " and m.msg_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_GetMessagesCount(String ownerJid, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select item_type, count(msg_id) from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id where o.jid_sha1 = ? and m.offline >= 1 group by item_type");
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_GetMessagesList(String ownerJid, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select b.jid, m.buddy_res, m.msg_id, m.item_type from tig_ma_msgs m inner join tig_ma_jids o on o.jid_id = m.owner_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where o.jid_sha1 = ? and m.offline >= 1");
            preparedStatement.setString(1, StoredProcedures.sha1OfLower((String)ownerJid));
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void for_RemoveMessages(String ownerJid, String msgIds) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)ownerJid);
            Long l = StoredProcedures.getJidId((BareJID)bareJID, (String)StoredProcedures.sha1OfLower((String)ownerJid));
            if (l == null) {
                return;
            }
            String string = "delete from tig_ma_msgs where offline >= 1 and owner_id = ?";
            if (msgIds != null) {
                string = string + " and msg_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
    }

    public static void for_UnmarkOfflineMessages(String ownerJid, String msgIds) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)ownerJid);
            Long l = StoredProcedures.getJidId((BareJID)bareJID, (String)StoredProcedures.sha1OfLower((String)ownerJid));
            if (l == null) {
                return;
            }
            String string = "delete from tig_ma_msgs  where offline = 2 and owner_id = ?";
            if (msgIds != null) {
                string = string + " and msg_id in (" + msgIds + ")";
            }
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            string = "update tig_ma_msgs set offline = 0 where offline = 1 and owner_id = ?";
            if (msgIds != null) {
                string = string + " and msg_id in (" + msgIds + ")";
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
    }

    public static void getCollections(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, Integer byType, String itemType, Integer offline, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select min(m.ts), b.jid");
            if (byType == 1) {
                stringBuilder.append(", case when m.type = 'groupchat' then cast('groupchat' as varchar(20)) else cast('' as varchar(20)) end as \"type\"");
            } else {
                stringBuilder.append(", cast(null as varchar(20)) as \"type\"");
            }
            stringBuilder.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                stringBuilder.append(" and m.item_type = ?");
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            if (byType == 1) {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid, case when m.type = 'groupchat' then cast('groupchat' as varchar(20)) else cast('' as varchar(20)) end");
            } else {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid");
            }
            stringBuilder.append(" order by min(m.ts), b.jid");
            stringBuilder.append(" offset ? rows fetch next ? rows only");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setString(++n, itemType);
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            preparedStatement.setInt(++n, offset);
            preparedStatement.setInt(++n, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getCollectionsCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, Integer byType, String itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select count(1) from (select min(m.ts), b.jid");
            if (byType == 1) {
                stringBuilder.append(", case when m.type = 'groupchat' then cast('groupchat' as varchar(20)) else cast('' as varchar(20)) end as \"type\"");
            } else {
                stringBuilder.append(", cast(null as varchar(20)) as \"type\"");
            }
            stringBuilder.append(" from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                stringBuilder.append(" and m.item_type = ?");
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            if (byType == 1) {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid, case when m.type = 'groupchat' then cast('groupchat' as varchar(20)) else cast('' as varchar(20)) end");
            } else {
                stringBuilder.append(" group by date(m.ts), m.buddy_id, b.jid");
            }
            stringBuilder.append(") x");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setString(++n, itemType);
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getItemPosition(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, String hash, String itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select m.stanza_hash, row_number() over () as position from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                stringBuilder.append(" and m.item_type = ?");
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            stringBuilder.append(" order by m.ts");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setString(++n, itemType);
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            n = 0;
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (!hash.equals(resultSet.getString(1))) continue;
                n = resultSet.getInt(2);
                break;
            }
            resultSet.close();
            String string = "select " + n + " as position from SYSIBM.SYSDUMMY1 where " + n + " <> 0";
            data[0] = connection.prepareStatement(string).executeQuery();
        }
    }

    public static void getItems(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, String itemType, Integer offline, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select m.msg, m.ts, m.direction, b.jid, m.stanza_hash, m.item_type from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                stringBuilder.append(" and m.item_type = ?");
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            stringBuilder.append(" order by m.ts");
            stringBuilder.append(" offset ? rows fetch next ? rows only");
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setString(++n, itemType);
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            preparedStatement.setInt(++n, offset);
            preparedStatement.setInt(++n, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    public static void getItemsCount(String ownerJid, String buddyJid, Timestamp from, Timestamp to, String tags, String contains, String itemType, Integer offline, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select count(m.msg_id) from tig_ma_msgs m inner join tig_ma_jids o on m.owner_id = o.jid_id inner join tig_ma_jids b on b.jid_id = m.buddy_id where  o.jid_sha1 = ?");
            if (buddyJid != null) {
                stringBuilder.append(" and b.jid_sha1 = ?");
            }
            if (from != null) {
                stringBuilder.append(" and m.ts >= ?");
            }
            if (to != null) {
                stringBuilder.append(" and m.ts <= ?");
            }
            if (itemType != null) {
                stringBuilder.append(" and m.item_type = ?");
            }
            if (offline != null) {
                stringBuilder.append(" and m.offline = ?");
            }
            stringBuilder.append(" and m.offline <> 2");
            StoredProcedures.appendTagsQuery((StringBuilder)stringBuilder, (String)tags);
            StoredProcedures.appendContainsQuery((StringBuilder)stringBuilder, (String)contains);
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
            int n = 0;
            preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)ownerJid));
            if (buddyJid != null) {
                preparedStatement.setString(++n, StoredProcedures.sha1OfLower((String)buddyJid));
            }
            if (from != null) {
                preparedStatement.setTimestamp(++n, from);
            }
            if (to != null) {
                preparedStatement.setTimestamp(++n, to);
            }
            if (itemType != null) {
                preparedStatement.setString(++n, itemType);
            }
            if (offline != null) {
                preparedStatement.setInt(++n, offline);
            }
            data[0] = preparedStatement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryRecent(String ownerJid, Timestamp start, Timestamp end, Integer chat, Integer groupchat, Integer call, Integer call_success, Integer call_missed, Integer call_canceled, Integer limit, Integer offset, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select b2.jid, m2.ts, m2.direction,m2.msg,   case m2.item_type    when 'chat' then case m2.\"type\"     when 'groupchat' then 'groupchat'     else 'chat'    end    when 'call' then 'call'   end as item_type,   case    when m2.item_type <> 'call' then null    when m2.jingle_action='session-accept' or (m2.jingle_action='session-terminate' and m2.jingle_reason = 'success') then 'success'    when m2.jingle_offline = 1     or (m2.jingle_action = 'session-terminate' and (      m2.jingle_reason = 'busy' or m2.jingle_reason = 'timeout'      or m2.jingle_reason = 'failed-application'      or (m2.jingle_reason = 'cancel' and m2.direction = 1 and ac.msg_id is null)     ))     or m2.jingle_action = 'session-initiate' then 'missed'    else 'canceled'   end as condition,   m2.stanza_hash,   {fn timestampdiff(SQL_TSI_FRAC_SECOND, ac.ts, m2.ts)} as duration from ( select max(x2.msg_id) as msg_id from ( select x1.owner_id, x1.buddy_id, max(x1.ts) as ts from  (select   m1.msg_id, m1.owner_id, m1.buddy_id, m1.ts,   case m1.item_type    when 'chat' then case m1.\"type\"     when 'groupchat' then 'groupchat'     else 'chat'    end    when 'call' then 'call'   end as item_type,   case    when m1.item_type <> 'call' then null    when m1.jingle_action='session-accept' or (m1.jingle_action='session-terminate' and m1.jingle_reason = 'success') then 'success'    when m1.jingle_offline = 1     or (m1.jingle_action = 'session-terminate' and (      m1.jingle_reason = 'busy' or m1.jingle_reason = 'timeout'      or m1.jingle_reason = 'failed-application'      or (m1.jingle_reason = 'cancel' and m1.direction = 1 and      not exists(select 1 from tig_ma_msgs m0 where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and m0.jingle_sid = m1.jingle_sid and m0.jingle_action = 'session-accept' and m0.ts < m1.ts))     ))     or m1.jingle_action = 'session-initiate' then 'missed'    else 'canceled'   end as condition  from tig_ma_msgs m1  where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)      and (? is null or ts >= ?)      and (? is null or ts <= ?) \t and m1.offline <> 2  ) as x1 where  (1=? and x1.item_type = 'chat')  or (1=? and x1.item_type = 'groupchat')  or (1=? and x1.item_type = 'call' and (   (1=? and x1.condition = 'success')   or (1=? and x1.condition = 'missed')   or (1=? and x1.condition = 'canceled')  ))  group by x1.owner_id, x1.buddy_id ) as x inner join tig_ma_msgs x2 on x2.owner_id = x.owner_id and x2.buddy_id = x.buddy_id and x2.ts = x.ts group by x.owner_id, x.buddy_id ) as y inner join tig_ma_msgs m2 on m2.msg_id = y.msg_id inner join tig_ma_jids b2 on b2.jid_id = m2.buddy_id left outer join tig_ma_msgs ac on ac.owner_id = m2.owner_id and ac.buddy_id = m2.buddy_id and ac.jingle_sid = m2.jingle_sid and ac.jingle_action = 'session-accept' order by m2.ts desc offset ? rows fetch next ? rows only");
            preparedStatement.setString(1, ownerJid.toString());
            preparedStatement.setTimestamp(2, start);
            preparedStatement.setTimestamp(3, start);
            preparedStatement.setTimestamp(4, end);
            preparedStatement.setTimestamp(5, end);
            preparedStatement.setInt(6, chat);
            preparedStatement.setInt(7, groupchat);
            preparedStatement.setInt(8, call);
            preparedStatement.setInt(9, call_success);
            preparedStatement.setInt(10, call_missed);
            preparedStatement.setInt(11, call_canceled);
            preparedStatement.setInt(12, offset);
            preparedStatement.setInt(13, limit);
            data[0] = preparedStatement.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryRecentCount(String ownerJid, Timestamp start, Timestamp end, Integer chat, Integer groupchat, Integer call, Integer call_success, Integer call_missed, Integer call_canceled, ResultSet[] data) throws SQLException {
        connection.setTransactionIsolation(2);
        try (Connection connection = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement preparedStatement = connection.prepareStatement("select count(1) from ( select max(x2.msg_id) as msg_id from ( select x1.owner_id, x1.buddy_id, max(x1.ts) as ts from  (select   m1.msg_id, m1.owner_id, m1.buddy_id, m1.ts,   case m1.item_type    when 'chat' then case m1.\"type\"     when 'groupchat' then 'groupchat'     else 'chat'    end    when 'call' then 'call'   end as item_type,   case    when m1.item_type <> 'call' then null    when m1.jingle_action='session-accept' or (m1.jingle_action='session-terminate' and m1.jingle_reason = 'success') then 'success'    when m1.jingle_offline = 1     or (m1.jingle_action = 'session-terminate' and (      m1.jingle_reason = 'busy' or m1.jingle_reason = 'timeout'      or m1.jingle_reason = 'failed-application'      or (m1.jingle_reason = 'cancel' and m1.direction = 1 and not exists(select 1 from tig_ma_msgs m0 where m0.owner_id = m1.owner_id and m0.buddy_id = m1.buddy_id and m0.jingle_sid = m1.jingle_sid and m0.jingle_action = 'session-accept' and m0.ts < m1.ts))     ))     or m1.jingle_action = 'session-initiate' then 'missed'    else 'canceled'   end as condition  from tig_ma_msgs m1  where m1.owner_id = (select jid_id from tig_ma_jids where jid = ?)  and (? is null or ts >= ?)  and (? is null or ts <= ?)  and m1.offline <> 2  ) as x1 where  (1=? and x1.item_type = 'chat')  or (1=? and x1.item_type = 'groupchat')  or (1=? and x1.item_type = 'call' and (   (1=? and x1.condition = 'success')   or (1=? and x1.condition = 'missed')   or (1=? and x1.condition = 'canceled')  )) group by x1.owner_id, x1.buddy_id ) as x inner join tig_ma_msgs x2 on x2.owner_id = x.owner_id and x2.buddy_id = x.buddy_id and x2.ts = x.ts group by x.owner_id, x.buddy_id ) as y");
            preparedStatement.setString(1, ownerJid.toString());
            preparedStatement.setTimestamp(2, start);
            preparedStatement.setTimestamp(3, start);
            preparedStatement.setTimestamp(4, end);
            preparedStatement.setTimestamp(5, end);
            preparedStatement.setInt(6, chat);
            preparedStatement.setInt(7, groupchat);
            preparedStatement.setInt(8, call);
            preparedStatement.setInt(9, call_success);
            preparedStatement.setInt(10, call_missed);
            preparedStatement.setInt(11, call_canceled);
            data[0] = preparedStatement.executeQuery();
        }
    }
}

