/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.jid.BareJID;

public abstract class NodeAffiliations
implements IAffiliations {
    protected static final String DELIMITER = ";";
    private static final Logger LOG = Logger.getLogger(NodeAffiliations.class.getName());
    protected final ConcurrentMap<BareJID, UsersAffiliation> affs = new ConcurrentHashMap<BareJID, UsersAffiliation>(16, 0.9f, 8);
    private boolean changed = false;

    public static tigase.pubsub.repository.cached.NodeAffiliations create(Queue<UsersAffiliation> data) {
        tigase.pubsub.repository.cached.NodeAffiliations a = new tigase.pubsub.repository.cached.NodeAffiliations();
        if (data == null) {
            return a;
        }
        a.init(data);
        return a;
    }

    public static tigase.pubsub.repository.cached.NodeAffiliations create(String data) {
        tigase.pubsub.repository.cached.NodeAffiliations a = new tigase.pubsub.repository.cached.NodeAffiliations();
        try {
            a.parse(data);
            return a;
        }
        catch (Exception e) {
            return new tigase.pubsub.repository.cached.NodeAffiliations();
        }
    }

    protected NodeAffiliations() {
    }

    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = new UsersAffiliation(bareJid, affiliation);
        this.affs.put(bareJid, a);
        this.changed = true;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Added affiliation for {0} as {1} (changed: {2})", new Object[]{bareJid, a, this.changed});
        }
    }

    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = this.get(bareJid);
        if (a != null) {
            a.setAffiliation(affiliation);
            this.changed = true;
        } else if (affiliation != Affiliation.none) {
            a = new UsersAffiliation(bareJid, affiliation);
            this.affs.put(bareJid, a);
            this.changed = true;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Changed affiliation for {0} as {1} (changed: {2})", new Object[]{bareJid, a, this.changed});
        }
    }

    public NodeAffiliations clone() throws CloneNotSupportedException {
        tigase.pubsub.repository.cached.NodeAffiliations clone = new tigase.pubsub.repository.cached.NodeAffiliations();
        for (UsersAffiliation a : this.affs.values()) {
            clone.affs.put(a.getJid(), a.clone());
        }
        clone.changed = this.changed;
        return clone;
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        UsersAffiliation[] a = this.affs.values().toArray(new UsersAffiliation[0]);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Affiliation for {0} is {1}", new Object[]{Arrays.asList(a)});
        }
        return a;
    }

    public Map<BareJID, UsersAffiliation> getAffiliationsMap() {
        return this.affs;
    }

    @Override
    public UsersAffiliation getSubscriberAffiliation(BareJID bareJid) {
        UsersAffiliation a = this.get(bareJid);
        if (a == null) {
            a = new UsersAffiliation(bareJid, Affiliation.none);
        }
        LOG.log(Level.FINEST, "Affiliation for {0} is {1}", new Object[]{bareJid, a});
        return a;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public void parse(String data) {
        String[] tokens = data.split(DELIMITER);
        this.affs.clear();
        int c = 0;
        BareJID jid = null;
        String state = null;
        for (String t : tokens) {
            if (c == 1) {
                state = t;
                ++c;
            } else if (c == 0) {
                jid = BareJID.bareJIDInstanceNS((String)t);
                ++c;
            }
            if (c != 2) continue;
            UsersAffiliation b = new UsersAffiliation(jid, Affiliation.valueOf(state));
            this.affs.put(jid, b);
            jid = null;
            state = null;
            c = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(IAffiliations nodeAffiliations) {
        ConcurrentMap<BareJID, UsersAffiliation> concurrentMap = this.affs;
        synchronized (concurrentMap) {
            if (nodeAffiliations instanceof NodeAffiliations) {
                NodeAffiliations na = (NodeAffiliations)nodeAffiliations;
                this.changed = true;
                this.affs.clear();
                for (UsersAffiliation a : na.affs.values()) {
                    this.affs.put(a.getJid(), a);
                }
            }
        }
    }

    public void resetChangedFlag() {
        this.changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize() {
        StringBuilder sb = new StringBuilder();
        ConcurrentMap<BareJID, UsersAffiliation> concurrentMap = this.affs;
        synchronized (concurrentMap) {
            for (UsersAffiliation a : this.affs.values()) {
                if (a.getAffiliation() == Affiliation.none) continue;
                sb.append(a.getJid());
                sb.append(DELIMITER);
                sb.append(a.getAffiliation().name());
                sb.append(DELIMITER);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "NodeAffiliations:" + this.affs;
    }

    protected UsersAffiliation get(BareJID bareJid) {
        UsersAffiliation a = (UsersAffiliation)this.affs.get(bareJid);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Affiliation for {0} is {1}", new Object[]{bareJid, a});
        }
        return a;
    }
}

