/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.List;
import java.util.Map;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.Element;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.MAMRepository;

public interface IPubSubDAO<T, S extends DataSource, Q extends Query>
extends DataSourceAware<S> {
    public void addToRootCollection(BareJID var1, String var2) throws RepositoryException;

    public T createNode(BareJID var1, String var2, BareJID var3, AbstractNodeConfig var4, NodeType var5, T var6) throws RepositoryException;

    public void deleteItem(BareJID var1, T var2, String var3) throws RepositoryException;

    public void deleteNode(BareJID var1, T var2) throws RepositoryException;

    public void destroy();

    public String[] getAllNodesList(BareJID var1) throws RepositoryException;

    @Deprecated
    public String[] getBuddyGroups(BareJID var1, BareJID var2) throws RepositoryException;

    @Deprecated
    public String getBuddySubscription(BareJID var1, BareJID var2) throws RepositoryException;

    public String[] getChildNodes(BareJID var1, String var2) throws RepositoryException;

    public Element getItem(BareJID var1, T var2, String var3) throws RepositoryException;

    public Date getItemCreationDate(BareJID var1, T var2, String var3) throws RepositoryException;

    public String[] getItemsIds(BareJID var1, T var2) throws RepositoryException;

    public String[] getItemsIdsSince(BareJID var1, T var2, Date var3) throws RepositoryException;

    public List<IItems.ItemMeta> getItemsMeta(BareJID var1, T var2, String var3) throws RepositoryException;

    public Date getItemUpdateDate(BareJID var1, T var2, String var3) throws RepositoryException;

    public NodeAffiliations getNodeAffiliations(BareJID var1, T var2) throws RepositoryException;

    @Deprecated
    public String getNodeConfig(BareJID var1, T var2) throws RepositoryException;

    @Deprecated
    public T getNodeId(BareJID var1, String var2) throws RepositoryException;

    public INodeMeta<T> getNodeMeta(BareJID var1, String var2) throws RepositoryException;

    public long getNodesCount(BareJID var1) throws RepositoryException;

    public String[] getNodesList(BareJID var1, String var2) throws RepositoryException;

    public NodeSubscriptions getNodeSubscriptions(BareJID var1, T var2) throws RepositoryException;

    public Map<String, UsersAffiliation> getUserAffiliations(BareJID var1, BareJID var2) throws RepositoryException;

    public Map<BareJID, RosterElement> getUserRoster(BareJID var1) throws RepositoryException;

    public Map<String, UsersSubscription> getUserSubscriptions(BareJID var1, BareJID var2) throws RepositoryException;

    public AbstractNodeConfig parseConfig(String var1, String var2) throws RepositoryException;

    public void queryItems(Q var1, List<T> var2, MAMRepository.ItemHandler<Q, IPubSubRepository.Item> var3) throws RepositoryException, ComponentException;

    public void removeAllFromRootCollection(BareJID var1) throws RepositoryException;

    public void removeService(BareJID var1) throws RepositoryException;

    public void removeFromRootCollection(BareJID var1, T var2) throws RepositoryException;

    public void removeNodeSubscription(BareJID var1, T var2, BareJID var3) throws RepositoryException;

    public void updateNodeAffiliation(BareJID var1, T var2, String var3, UsersAffiliation var4) throws RepositoryException;

    public void updateNodeConfig(BareJID var1, T var2, String var3, T var4) throws RepositoryException;

    public void updateNodeSubscription(BareJID var1, T var2, String var3, UsersSubscription var4) throws RepositoryException;

    public void writeItem(BareJID var1, T var2, long var3, String var5, String var6, Element var7) throws RepositoryException;
}

