/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Map;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.PubSubComponent;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="pubsubConfig", parent=PubSubComponent.class, active=true)
public class PubSubConfig {
    public static final String ADMINS_KEY = "admin";
    private static final String MAX_CACHE_SIZE = "pubsub-repository-cache-size";
    private static final String AUTO_SUBSCRIBE_NODE_CREATOR = "auto-subscribe-node-creator";
    private static final String PUBSUB_HIGH_MEMORY_USAGE_LEVEL_KEY = "pubsub-high-memory-usage-level";
    private static final String PUBSUB_LOW_MEMORY_DELAY_KEY = "pubsub-low-memory-delay";
    private static final String PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_KEY = "pep-remove-empty-geoloc";
    private static final String PUBSUB_PERSISTENT_PEP_KEY = "persistent-pep";
    private static final String PUBSUB_SEND_LAST_PUBLISHED_ITEM_ON_PRESECE_KEY = "send-last-published-item-on-presence";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    @ConfigField(desc="List of admins", alias="admins")
    protected String[] admins;
    protected BareJID serviceBareJID = BareJID.bareJIDInstanceNS((String)"tigase-pubsub");
    @ConfigField(desc="Automatically subscribe creator to node", alias="auto-subscribe-node-creator")
    private boolean autoSubscribeNodeCreator = true;
    @Inject(bean="service")
    private PubSubComponent component;
    @ConfigField(desc="High memory usage level", alias="pubsub-high-memory-usage-level")
    private float highMemoryUsageLevel = 90.0f;
    @ConfigField(desc="Low memory delay", alias="pubsub-low-memory-delay")
    private long lowMemoryDelay = 1000L;
    @ConfigField(desc="Max Cache size", alias="pubsub-repository-cache-size")
    private Integer maxCacheSize = 2000;
    @ConfigField(desc="PEP Remove Empty Geoloc", alias="pep-remove-empty-geoloc")
    private boolean pepRemoveEmptyGeoloc = false;
    @ConfigField(desc="Persistent PEP", alias="persistent-pep")
    private boolean persistentPep = true;
    @ConfigField(desc="Send Last Published Item on Presence", alias="send-last-published-item-on-presence")
    private boolean sendLastPublishedItemOnPresence = true;
    @ConfigField(desc="Subscribe to open nodes with presence based filtered notifications to non-PEP services like in PEP", alias="subscribe-by-presence-filtered-notifications")
    private boolean subscribeByPresenceFilteredNotifications = false;
    @ConfigField(desc="Trust every XMPP entity", alias="trust-every-entity")
    private boolean trustEveryEntity;

    public String[] getAdmins() {
        return this.admins;
    }

    public void setAdmins(String[] strings) {
        this.admins = strings;
    }

    public JID getComponentJID() {
        return this.component.getComponentId();
    }

    public long getDelayOnLowMemory() {
        if (this.isHighMemoryUsage()) {
            return this.lowMemoryDelay;
        }
        return 0L;
    }

    public Integer getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public BareJID getServiceBareJID() {
        return this.serviceBareJID;
    }

    public void setProperties(Map<String, Object> props) {
        this.admins = props.containsKey(ADMINS_KEY) ? (String[])props.get(ADMINS_KEY) : (props.get("--admins") != null ? ((String)props.get("--admins")).split(",") : new String[]{"admin@" + this.component.getDefHostName()});
    }

    public boolean isAutoSubscribeNodeCreator() {
        return this.autoSubscribeNodeCreator;
    }

    public boolean isAdmin(BareJID jid) {
        if (this.trustEveryEntity) {
            return true;
        }
        if (jid == null || this.admins == null) {
            return false;
        }
        for (String adj : this.admins) {
            if (!jid.toString().equals(adj)) continue;
            return true;
        }
        return this.component.isTrusted(jid.toString());
    }

    public boolean isAdmin(JID jid) {
        return this.isAdmin(jid.getBareJID());
    }

    public boolean isPepPeristent() {
        return this.persistentPep;
    }

    public boolean isPepRemoveEmptyGeoloc() {
        return this.pepRemoveEmptyGeoloc;
    }

    public boolean isSendLastPublishedItemOnPresence() {
        return this.sendLastPublishedItemOnPresence;
    }

    public boolean isSubscribeByPresenceFilteredNotifications() {
        return this.subscribeByPresenceFilteredNotifications;
    }

    private boolean isHighMemoryUsage() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsage() > this.highMemoryUsageLevel;
    }
}

